/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.InboundNatPool;
import com.microsoft.azure.management.network.LoadBalancer;
import com.microsoft.azure.management.network.LoadBalancerFrontend;
import com.microsoft.azure.management.network.LoadBalancerInboundNatPool;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.PublicIPAddress;
import com.microsoft.azure.management.network.Subnet;
import com.microsoft.azure.management.network.TransportProtocol;
import com.microsoft.azure.management.network.implementation.LoadBalancerImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;

@LangDefinition
class LoadBalancerInboundNatPoolImpl
extends ChildResourceImpl<InboundNatPool, LoadBalancerImpl, LoadBalancer>
implements LoadBalancerInboundNatPool,
LoadBalancerInboundNatPool.Definition<LoadBalancer.DefinitionStages.WithCreateAndInboundNatPool>,
LoadBalancerInboundNatPool.UpdateDefinition<LoadBalancer.Update>,
LoadBalancerInboundNatPool.Update {
    LoadBalancerInboundNatPoolImpl(InboundNatPool inner, LoadBalancerImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public String name() {
        return ((InboundNatPool)((Object)this.inner())).name();
    }

    @Override
    public TransportProtocol protocol() {
        return ((InboundNatPool)((Object)this.inner())).protocol();
    }

    @Override
    public int backendPort() {
        return Utils.toPrimitiveInt((Integer)((InboundNatPool)((Object)this.inner())).backendPort());
    }

    @Override
    public LoadBalancerFrontend frontend() {
        return ((LoadBalancerImpl)this.parent()).frontends().get(ResourceUtils.nameFromResourceId((String)((InboundNatPool)((Object)this.inner())).frontendIPConfiguration().id()));
    }

    @Override
    public int frontendPortRangeStart() {
        return Utils.toPrimitiveInt((Integer)((InboundNatPool)((Object)this.inner())).frontendPortRangeStart());
    }

    @Override
    public int frontendPortRangeEnd() {
        return Utils.toPrimitiveInt((Integer)((InboundNatPool)((Object)this.inner())).frontendPortRangeEnd());
    }

    @Override
    public LoadBalancerInboundNatPoolImpl toBackendPort(int port) {
        ((InboundNatPool)((Object)this.inner())).withBackendPort(port);
        return this;
    }

    @Override
    public LoadBalancerInboundNatPoolImpl withProtocol(TransportProtocol protocol) {
        ((InboundNatPool)((Object)this.inner())).withProtocol(protocol);
        return this;
    }

    @Override
    public LoadBalancerInboundNatPoolImpl fromFrontend(String frontendName) {
        SubResource frontendRef = ((LoadBalancerImpl)this.parent()).ensureFrontendRef(frontendName);
        if (frontendRef != null) {
            ((InboundNatPool)((Object)this.inner())).withFrontendIPConfiguration(frontendRef);
        }
        return this;
    }

    @Override
    public LoadBalancerInboundNatPoolImpl fromFrontendPortRange(int from, int to) {
        ((InboundNatPool)((Object)this.inner())).withFrontendPortRangeStart(from).withFrontendPortRangeEnd(to);
        return this;
    }

    public LoadBalancerImpl attach() {
        return ((LoadBalancerImpl)this.parent()).withInboundNatPool(this);
    }

    @Override
    public LoadBalancerInboundNatPoolImpl fromExistingPublicIPAddress(PublicIPAddress publicIPAddress) {
        return publicIPAddress != null ? this.fromExistingPublicIPAddress(publicIPAddress.id()) : this;
    }

    @Override
    public LoadBalancerInboundNatPoolImpl fromExistingPublicIPAddress(String resourceId) {
        return null != resourceId ? this.fromFrontend(((LoadBalancerImpl)this.parent()).ensurePublicFrontendWithPip(resourceId).name()) : this;
    }

    @Override
    public LoadBalancerInboundNatPoolImpl fromNewPublicIPAddress(String leafDnsLabel) {
        String frontendName = SdkContext.randomResourceName((String)"fe", (int)20);
        ((LoadBalancerImpl)this.parent()).withNewPublicIPAddress(leafDnsLabel, frontendName);
        return this.fromFrontend(frontendName);
    }

    @Override
    public LoadBalancerInboundNatPoolImpl fromNewPublicIPAddress(Creatable<PublicIPAddress> pipDefinition) {
        String frontendName = SdkContext.randomResourceName((String)"fe", (int)20);
        ((LoadBalancerImpl)this.parent()).withNewPublicIPAddress(pipDefinition, frontendName);
        return this.fromFrontend(frontendName);
    }

    @Override
    public LoadBalancerInboundNatPoolImpl fromNewPublicIPAddress() {
        String dnsLabel = SdkContext.randomResourceName((String)"fe", (int)20);
        return this.fromNewPublicIPAddress(dnsLabel);
    }

    @Override
    public LoadBalancerInboundNatPoolImpl fromExistingSubnet(String networkResourceId, String subnetName) {
        return null != networkResourceId && null != subnetName ? this.fromFrontend(((LoadBalancerImpl)this.parent()).ensurePrivateFrontendWithSubnet(networkResourceId, subnetName).name()) : this;
    }

    @Override
    public LoadBalancerInboundNatPoolImpl fromExistingSubnet(Network network, String subnetName) {
        return null != network && null != subnetName ? this.fromExistingSubnet(network.id(), subnetName) : this;
    }

    @Override
    public LoadBalancerInboundNatPoolImpl fromExistingSubnet(Subnet subnet) {
        return null != subnet ? this.fromExistingSubnet(((Network)subnet.parent()).id(), subnet.name()) : this;
    }
}

