/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.ErrorResponseException;
import com.microsoft.azure.management.network.implementation.FlowLogInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class FlowLogsInner {
    private FlowLogsService service;
    private NetworkManagementClientImpl client;

    public FlowLogsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (FlowLogsService)retrofit.create(FlowLogsService.class);
        this.client = client;
    }

    public FlowLogInner createOrUpdate(String resourceGroupName, String networkWatcherName, String flowLogName, FlowLogInner parameters) {
        return (FlowLogInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<FlowLogInner> createOrUpdateAsync(String resourceGroupName, String networkWatcherName, String flowLogName, FlowLogInner parameters, ServiceCallback<FlowLogInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName, parameters), serviceCallback);
    }

    public Observable<FlowLogInner> createOrUpdateAsync(String resourceGroupName, String networkWatcherName, String flowLogName, FlowLogInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName, parameters).map((Func1)new Func1<ServiceResponse<FlowLogInner>, FlowLogInner>(){

            public FlowLogInner call(ServiceResponse<FlowLogInner> response) {
                return (FlowLogInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FlowLogInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String flowLogName, FlowLogInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (flowLogName == null) {
            throw new IllegalArgumentException("Parameter flowLogName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, networkWatcherName, flowLogName, this.client.subscriptionId(), parameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<FlowLogInner>(){}.getType());
    }

    public FlowLogInner beginCreateOrUpdate(String resourceGroupName, String networkWatcherName, String flowLogName, FlowLogInner parameters) {
        return (FlowLogInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<FlowLogInner> beginCreateOrUpdateAsync(String resourceGroupName, String networkWatcherName, String flowLogName, FlowLogInner parameters, ServiceCallback<FlowLogInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName, parameters), serviceCallback);
    }

    public Observable<FlowLogInner> beginCreateOrUpdateAsync(String resourceGroupName, String networkWatcherName, String flowLogName, FlowLogInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName, parameters).map((Func1)new Func1<ServiceResponse<FlowLogInner>, FlowLogInner>(){

            public FlowLogInner call(ServiceResponse<FlowLogInner> response) {
                return (FlowLogInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FlowLogInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String flowLogName, FlowLogInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (flowLogName == null) {
            throw new IllegalArgumentException("Parameter flowLogName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, networkWatcherName, flowLogName, this.client.subscriptionId(), parameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FlowLogInner>>>(){

            public Observable<ServiceResponse<FlowLogInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FlowLogsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FlowLogInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FlowLogInner>(){}.getType()).register(201, new TypeToken<FlowLogInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public FlowLogInner get(String resourceGroupName, String networkWatcherName, String flowLogName) {
        return (FlowLogInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName).toBlocking().single()).body());
    }

    public ServiceFuture<FlowLogInner> getAsync(String resourceGroupName, String networkWatcherName, String flowLogName, ServiceCallback<FlowLogInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName), serviceCallback);
    }

    public Observable<FlowLogInner> getAsync(String resourceGroupName, String networkWatcherName, String flowLogName) {
        return this.getWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName).map((Func1)new Func1<ServiceResponse<FlowLogInner>, FlowLogInner>(){

            public FlowLogInner call(ServiceResponse<FlowLogInner> response) {
                return (FlowLogInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FlowLogInner>> getWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String flowLogName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (flowLogName == null) {
            throw new IllegalArgumentException("Parameter flowLogName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.get(resourceGroupName, networkWatcherName, flowLogName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FlowLogInner>>>(){

            public Observable<ServiceResponse<FlowLogInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FlowLogsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FlowLogInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FlowLogInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void delete(String resourceGroupName, String networkWatcherName, String flowLogName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String networkWatcherName, String flowLogName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String networkWatcherName, String flowLogName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String flowLogName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (flowLogName == null) {
            throw new IllegalArgumentException("Parameter flowLogName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, networkWatcherName, flowLogName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String networkWatcherName, String flowLogName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String networkWatcherName, String flowLogName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String networkWatcherName, String flowLogName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, flowLogName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String flowLogName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (flowLogName == null) {
            throw new IllegalArgumentException("Parameter flowLogName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.beginDelete(resourceGroupName, networkWatcherName, flowLogName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FlowLogsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<FlowLogInner> list(String resourceGroupName, String networkWatcherName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, networkWatcherName).toBlocking().single();
        return new PagedList<FlowLogInner>((Page)response.body()){

            public Page<FlowLogInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FlowLogsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FlowLogInner>> listAsync(String resourceGroupName, String networkWatcherName, ListOperationCallback<FlowLogInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, networkWatcherName), (Func1)new Func1<String, Observable<ServiceResponse<Page<FlowLogInner>>>>(){

            public Observable<ServiceResponse<Page<FlowLogInner>>> call(String nextPageLink) {
                return FlowLogsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FlowLogInner>> listAsync(String resourceGroupName, String networkWatcherName) {
        return this.listWithServiceResponseAsync(resourceGroupName, networkWatcherName).map((Func1)new Func1<ServiceResponse<Page<FlowLogInner>>, Page<FlowLogInner>>(){

            public Page<FlowLogInner> call(ServiceResponse<Page<FlowLogInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FlowLogInner>>> listWithServiceResponseAsync(String resourceGroupName, String networkWatcherName) {
        return this.listSinglePageAsync(resourceGroupName, networkWatcherName).concatMap((Func1)new Func1<ServiceResponse<Page<FlowLogInner>>, Observable<ServiceResponse<Page<FlowLogInner>>>>(){

            public Observable<ServiceResponse<Page<FlowLogInner>>> call(ServiceResponse<Page<FlowLogInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FlowLogsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FlowLogInner>>> listSinglePageAsync(String resourceGroupName, String networkWatcherName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(resourceGroupName, networkWatcherName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FlowLogInner>>>>(){

            public Observable<ServiceResponse<Page<FlowLogInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FlowLogsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FlowLogInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<FlowLogInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<FlowLogInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<FlowLogInner>((Page)response.body()){

            public Page<FlowLogInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FlowLogsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FlowLogInner>> listNextAsync(String nextPageLink, ServiceFuture<List<FlowLogInner>> serviceFuture, ListOperationCallback<FlowLogInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<FlowLogInner>>>>(){

            public Observable<ServiceResponse<Page<FlowLogInner>>> call(String nextPageLink) {
                return FlowLogsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FlowLogInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<FlowLogInner>>, Page<FlowLogInner>>(){

            public Page<FlowLogInner> call(ServiceResponse<Page<FlowLogInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FlowLogInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<FlowLogInner>>, Observable<ServiceResponse<Page<FlowLogInner>>>>(){

            public Observable<ServiceResponse<Page<FlowLogInner>>> call(ServiceResponse<Page<FlowLogInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FlowLogsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FlowLogInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FlowLogInner>>>>(){

            public Observable<ServiceResponse<Page<FlowLogInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FlowLogsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FlowLogInner>> listNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<FlowLogInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface FlowLogsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FlowLogs createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/flowLogs/{flowLogName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="flowLogName") String var3, @Path(value="subscriptionId") String var4, @Body FlowLogInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FlowLogs beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/flowLogs/{flowLogName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="flowLogName") String var3, @Path(value="subscriptionId") String var4, @Body FlowLogInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FlowLogs get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/flowLogs/{flowLogName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="flowLogName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FlowLogs delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/flowLogs/{flowLogName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="flowLogName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FlowLogs beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/flowLogs/{flowLogName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="flowLogName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FlowLogs list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/flowLogs")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FlowLogs listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

