/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.management.network.implementation.ExpressRoutePortInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ExpressRoutePortsInner
implements InnerSupportsGet<ExpressRoutePortInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<ExpressRoutePortInner> {
    private ExpressRoutePortsService service;
    private NetworkManagementClientImpl client;

    public ExpressRoutePortsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (ExpressRoutePortsService)retrofit.create(ExpressRoutePortsService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String expressRoutePortName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, expressRoutePortName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String expressRoutePortName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, expressRoutePortName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String expressRoutePortName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, expressRoutePortName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String expressRoutePortName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (expressRoutePortName == null) {
            throw new IllegalArgumentException("Parameter expressRoutePortName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, expressRoutePortName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String expressRoutePortName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, expressRoutePortName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String expressRoutePortName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, expressRoutePortName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String expressRoutePortName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, expressRoutePortName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String expressRoutePortName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (expressRoutePortName == null) {
            throw new IllegalArgumentException("Parameter expressRoutePortName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, expressRoutePortName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExpressRoutePortsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ExpressRoutePortInner getByResourceGroup(String resourceGroupName, String expressRoutePortName) {
        return (ExpressRoutePortInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, expressRoutePortName).toBlocking().single()).body());
    }

    public ServiceFuture<ExpressRoutePortInner> getByResourceGroupAsync(String resourceGroupName, String expressRoutePortName, ServiceCallback<ExpressRoutePortInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, expressRoutePortName), serviceCallback);
    }

    public Observable<ExpressRoutePortInner> getByResourceGroupAsync(String resourceGroupName, String expressRoutePortName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, expressRoutePortName).map((Func1)new Func1<ServiceResponse<ExpressRoutePortInner>, ExpressRoutePortInner>(){

            public ExpressRoutePortInner call(ServiceResponse<ExpressRoutePortInner> response) {
                return (ExpressRoutePortInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ExpressRoutePortInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String expressRoutePortName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (expressRoutePortName == null) {
            throw new IllegalArgumentException("Parameter expressRoutePortName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, expressRoutePortName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ExpressRoutePortInner>>>(){

            public Observable<ServiceResponse<ExpressRoutePortInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExpressRoutePortsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ExpressRoutePortInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ExpressRoutePortInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ExpressRoutePortInner createOrUpdate(String resourceGroupName, String expressRoutePortName, ExpressRoutePortInner parameters) {
        return (ExpressRoutePortInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, expressRoutePortName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<ExpressRoutePortInner> createOrUpdateAsync(String resourceGroupName, String expressRoutePortName, ExpressRoutePortInner parameters, ServiceCallback<ExpressRoutePortInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, expressRoutePortName, parameters), serviceCallback);
    }

    public Observable<ExpressRoutePortInner> createOrUpdateAsync(String resourceGroupName, String expressRoutePortName, ExpressRoutePortInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, expressRoutePortName, parameters).map((Func1)new Func1<ServiceResponse<ExpressRoutePortInner>, ExpressRoutePortInner>(){

            public ExpressRoutePortInner call(ServiceResponse<ExpressRoutePortInner> response) {
                return (ExpressRoutePortInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ExpressRoutePortInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String expressRoutePortName, ExpressRoutePortInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (expressRoutePortName == null) {
            throw new IllegalArgumentException("Parameter expressRoutePortName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, expressRoutePortName, "2019-11-01", parameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ExpressRoutePortInner>(){}.getType());
    }

    public ExpressRoutePortInner beginCreateOrUpdate(String resourceGroupName, String expressRoutePortName, ExpressRoutePortInner parameters) {
        return (ExpressRoutePortInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, expressRoutePortName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ExpressRoutePortInner> beginCreateOrUpdateAsync(String resourceGroupName, String expressRoutePortName, ExpressRoutePortInner parameters, ServiceCallback<ExpressRoutePortInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, expressRoutePortName, parameters), serviceCallback);
    }

    public Observable<ExpressRoutePortInner> beginCreateOrUpdateAsync(String resourceGroupName, String expressRoutePortName, ExpressRoutePortInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, expressRoutePortName, parameters).map((Func1)new Func1<ServiceResponse<ExpressRoutePortInner>, ExpressRoutePortInner>(){

            public ExpressRoutePortInner call(ServiceResponse<ExpressRoutePortInner> response) {
                return (ExpressRoutePortInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ExpressRoutePortInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String expressRoutePortName, ExpressRoutePortInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (expressRoutePortName == null) {
            throw new IllegalArgumentException("Parameter expressRoutePortName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, expressRoutePortName, "2019-11-01", parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ExpressRoutePortInner>>>(){

            public Observable<ServiceResponse<ExpressRoutePortInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExpressRoutePortsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ExpressRoutePortInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ExpressRoutePortInner>(){}.getType()).register(201, new TypeToken<ExpressRoutePortInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ExpressRoutePortInner updateTags(String resourceGroupName, String expressRoutePortName) {
        return (ExpressRoutePortInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, expressRoutePortName).toBlocking().single()).body());
    }

    public ServiceFuture<ExpressRoutePortInner> updateTagsAsync(String resourceGroupName, String expressRoutePortName, ServiceCallback<ExpressRoutePortInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, expressRoutePortName), serviceCallback);
    }

    public Observable<ExpressRoutePortInner> updateTagsAsync(String resourceGroupName, String expressRoutePortName) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, expressRoutePortName).map((Func1)new Func1<ServiceResponse<ExpressRoutePortInner>, ExpressRoutePortInner>(){

            public ExpressRoutePortInner call(ServiceResponse<ExpressRoutePortInner> response) {
                return (ExpressRoutePortInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ExpressRoutePortInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String expressRoutePortName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (expressRoutePortName == null) {
            throw new IllegalArgumentException("Parameter expressRoutePortName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Object tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        return this.service.updateTags(this.client.subscriptionId(), resourceGroupName, expressRoutePortName, "2019-11-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ExpressRoutePortInner>>>(){

            public Observable<ServiceResponse<ExpressRoutePortInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExpressRoutePortsInner.this.updateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ExpressRoutePortInner updateTags(String resourceGroupName, String expressRoutePortName, Map<String, String> tags) {
        return (ExpressRoutePortInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, expressRoutePortName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<ExpressRoutePortInner> updateTagsAsync(String resourceGroupName, String expressRoutePortName, Map<String, String> tags, ServiceCallback<ExpressRoutePortInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, expressRoutePortName, tags), serviceCallback);
    }

    public Observable<ExpressRoutePortInner> updateTagsAsync(String resourceGroupName, String expressRoutePortName, Map<String, String> tags) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, expressRoutePortName, tags).map((Func1)new Func1<ServiceResponse<ExpressRoutePortInner>, ExpressRoutePortInner>(){

            public ExpressRoutePortInner call(ServiceResponse<ExpressRoutePortInner> response) {
                return (ExpressRoutePortInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ExpressRoutePortInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String expressRoutePortName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (expressRoutePortName == null) {
            throw new IllegalArgumentException("Parameter expressRoutePortName is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2019-11-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        return this.service.updateTags(this.client.subscriptionId(), resourceGroupName, expressRoutePortName, "2019-11-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ExpressRoutePortInner>>>(){

            public Observable<ServiceResponse<ExpressRoutePortInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExpressRoutePortsInner.this.updateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ExpressRoutePortInner> updateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ExpressRoutePortInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ExpressRoutePortInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<ExpressRoutePortInner>((Page)response.body()){

            public Page<ExpressRoutePortInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ExpressRoutePortsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ExpressRoutePortInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<ExpressRoutePortInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ExpressRoutePortInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRoutePortInner>>> call(String nextPageLink) {
                return ExpressRoutePortsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ExpressRoutePortInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<ExpressRoutePortInner>>, Page<ExpressRoutePortInner>>(){

            public Page<ExpressRoutePortInner> call(ServiceResponse<Page<ExpressRoutePortInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRoutePortInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<ExpressRoutePortInner>>, Observable<ServiceResponse<Page<ExpressRoutePortInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRoutePortInner>>> call(ServiceResponse<Page<ExpressRoutePortInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ExpressRoutePortsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRoutePortInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ExpressRoutePortInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRoutePortInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ExpressRoutePortsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ExpressRoutePortInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ExpressRoutePortInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ExpressRoutePortInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ExpressRoutePortInner>((Page)response.body()){

            public Page<ExpressRoutePortInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ExpressRoutePortsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ExpressRoutePortInner>> listAsync(ListOperationCallback<ExpressRoutePortInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ExpressRoutePortInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRoutePortInner>>> call(String nextPageLink) {
                return ExpressRoutePortsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ExpressRoutePortInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ExpressRoutePortInner>>, Page<ExpressRoutePortInner>>(){

            public Page<ExpressRoutePortInner> call(ServiceResponse<Page<ExpressRoutePortInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRoutePortInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ExpressRoutePortInner>>, Observable<ServiceResponse<Page<ExpressRoutePortInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRoutePortInner>>> call(ServiceResponse<Page<ExpressRoutePortInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ExpressRoutePortsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRoutePortInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ExpressRoutePortInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRoutePortInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ExpressRoutePortsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ExpressRoutePortInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ExpressRoutePortInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ExpressRoutePortInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ExpressRoutePortInner>((Page)response.body()){

            public Page<ExpressRoutePortInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ExpressRoutePortsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ExpressRoutePortInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<ExpressRoutePortInner>> serviceFuture, ListOperationCallback<ExpressRoutePortInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ExpressRoutePortInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRoutePortInner>>> call(String nextPageLink) {
                return ExpressRoutePortsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ExpressRoutePortInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ExpressRoutePortInner>>, Page<ExpressRoutePortInner>>(){

            public Page<ExpressRoutePortInner> call(ServiceResponse<Page<ExpressRoutePortInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRoutePortInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ExpressRoutePortInner>>, Observable<ServiceResponse<Page<ExpressRoutePortInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRoutePortInner>>> call(ServiceResponse<Page<ExpressRoutePortInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ExpressRoutePortsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRoutePortInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ExpressRoutePortInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRoutePortInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ExpressRoutePortsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ExpressRoutePortInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ExpressRoutePortInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ExpressRoutePortInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ExpressRoutePortInner>((Page)response.body()){

            public Page<ExpressRoutePortInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ExpressRoutePortsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ExpressRoutePortInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ExpressRoutePortInner>> serviceFuture, ListOperationCallback<ExpressRoutePortInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ExpressRoutePortInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRoutePortInner>>> call(String nextPageLink) {
                return ExpressRoutePortsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ExpressRoutePortInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ExpressRoutePortInner>>, Page<ExpressRoutePortInner>>(){

            public Page<ExpressRoutePortInner> call(ServiceResponse<Page<ExpressRoutePortInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRoutePortInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ExpressRoutePortInner>>, Observable<ServiceResponse<Page<ExpressRoutePortInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRoutePortInner>>> call(ServiceResponse<Page<ExpressRoutePortInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ExpressRoutePortsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRoutePortInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ExpressRoutePortInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRoutePortInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ExpressRoutePortsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ExpressRoutePortInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ExpressRoutePortInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ExpressRoutePortsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRoutePorts delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ExpressRoutePorts/{expressRoutePortName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="expressRoutePortName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRoutePorts beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ExpressRoutePorts/{expressRoutePortName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="expressRoutePortName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRoutePorts getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ExpressRoutePorts/{expressRoutePortName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="expressRoutePortName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRoutePorts createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ExpressRoutePorts/{expressRoutePortName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="expressRoutePortName") String var3, @Query(value="api-version") String var4, @Body ExpressRoutePortInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRoutePorts beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ExpressRoutePorts/{expressRoutePortName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="expressRoutePortName") String var3, @Query(value="api-version") String var4, @Body ExpressRoutePortInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRoutePorts updateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ExpressRoutePorts/{expressRoutePortName}")
        public Observable<Response<ResponseBody>> updateTags(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="expressRoutePortName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRoutePorts listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ExpressRoutePorts")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRoutePorts list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/ExpressRoutePorts")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRoutePorts listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRoutePorts listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

