/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ExpressRouteCircuit;
import com.microsoft.azure.management.network.ExpressRouteCircuitPeering;
import com.microsoft.azure.management.network.ExpressRouteCircuitPeerings;
import com.microsoft.azure.management.network.ExpressRouteCircuitServiceProviderProperties;
import com.microsoft.azure.management.network.ExpressRouteCircuitSkuType;
import com.microsoft.azure.management.network.ProvisioningState;
import com.microsoft.azure.management.network.ServiceProviderProvisioningState;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitAuthorizationInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitPeeringImpl;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitPeeringInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitPeeringsImpl;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.model.GroupableParentResourceWithTagsImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class ExpressRouteCircuitImpl
extends GroupableParentResourceWithTagsImpl<ExpressRouteCircuit, ExpressRouteCircuitInner, ExpressRouteCircuitImpl, NetworkManager>
implements ExpressRouteCircuit,
ExpressRouteCircuit.Definition,
ExpressRouteCircuit.Update {
    private ExpressRouteCircuitPeeringsImpl peerings;
    private Map<String, ExpressRouteCircuitPeering> expressRouteCircuitPeerings;

    ExpressRouteCircuitImpl(String name, ExpressRouteCircuitInner innerObject, NetworkManager manager) {
        super(name, innerObject, manager);
        this.initializeChildrenFromInner();
    }

    @Override
    public ExpressRouteCircuitImpl withServiceProvider(String serviceProviderName) {
        this.ensureServiceProviderProperties().withServiceProviderName(serviceProviderName);
        return this;
    }

    @Override
    public ExpressRouteCircuitImpl withPeeringLocation(String location) {
        this.ensureServiceProviderProperties().withPeeringLocation(location);
        return this;
    }

    @Override
    public ExpressRouteCircuitImpl withBandwidthInMbps(int bandwidthInMbps) {
        this.ensureServiceProviderProperties().withBandwidthInMbps(bandwidthInMbps);
        return this;
    }

    @Override
    public ExpressRouteCircuitImpl withSku(ExpressRouteCircuitSkuType sku) {
        ((ExpressRouteCircuitInner)((Object)this.inner())).withSku(sku.sku());
        return this;
    }

    @Override
    public ExpressRouteCircuitImpl withClassicOperations() {
        ((ExpressRouteCircuitInner)((Object)this.inner())).withAllowClassicOperations(true);
        return this;
    }

    @Override
    public ExpressRouteCircuitImpl withoutClassicOperations() {
        ((ExpressRouteCircuitInner)((Object)this.inner())).withAllowClassicOperations(false);
        return this;
    }

    @Override
    public ExpressRouteCircuitImpl withAuthorization(String authorizationName) {
        this.ensureAuthorizations().add(new ExpressRouteCircuitAuthorizationInner().withName(authorizationName));
        return this;
    }

    private List<ExpressRouteCircuitAuthorizationInner> ensureAuthorizations() {
        if (((ExpressRouteCircuitInner)((Object)this.inner())).authorizations() == null) {
            ((ExpressRouteCircuitInner)((Object)this.inner())).withAuthorizations(new ArrayList<ExpressRouteCircuitAuthorizationInner>());
        }
        return ((ExpressRouteCircuitInner)((Object)this.inner())).authorizations();
    }

    private ExpressRouteCircuitServiceProviderProperties ensureServiceProviderProperties() {
        if (((ExpressRouteCircuitInner)((Object)this.inner())).serviceProviderProperties() == null) {
            ((ExpressRouteCircuitInner)((Object)this.inner())).withServiceProviderProperties(new ExpressRouteCircuitServiceProviderProperties());
        }
        return ((ExpressRouteCircuitInner)((Object)this.inner())).serviceProviderProperties();
    }

    protected void beforeCreating() {
    }

    protected void afterCreating() {
    }

    protected Observable<ExpressRouteCircuitInner> createInner() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).expressRouteCircuits().createOrUpdateAsync(this.resourceGroupName(), this.name(), (ExpressRouteCircuitInner)((Object)this.inner()));
    }

    protected void initializeChildrenFromInner() {
        this.expressRouteCircuitPeerings = new HashMap<String, ExpressRouteCircuitPeering>();
        if (((ExpressRouteCircuitInner)((Object)this.inner())).peerings() != null) {
            for (ExpressRouteCircuitPeeringInner peering : ((ExpressRouteCircuitInner)((Object)this.inner())).peerings()) {
                this.expressRouteCircuitPeerings.put(peering.name(), new ExpressRouteCircuitPeeringImpl(this, peering, ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).expressRouteCircuitPeerings(), peering.peeringType()));
            }
        }
    }

    protected Observable<ExpressRouteCircuitInner> getInnerAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).expressRouteCircuits().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public Observable<ExpressRouteCircuit> refreshAsync() {
        return super.refreshAsync().map((Func1)new Func1<ExpressRouteCircuit, ExpressRouteCircuit>(){

            public ExpressRouteCircuit call(ExpressRouteCircuit expressRouteCircuit) {
                ExpressRouteCircuitImpl impl = (ExpressRouteCircuitImpl)expressRouteCircuit;
                impl.initializeChildrenFromInner();
                return impl;
            }
        });
    }

    @Override
    protected Observable<ExpressRouteCircuitInner> applyTagsToInnerAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).expressRouteCircuits().updateTagsAsync(this.resourceGroupName(), this.name(), ((ExpressRouteCircuitInner)((Object)this.inner())).getTags());
    }

    @Override
    public ExpressRouteCircuitPeerings peerings() {
        if (this.peerings == null) {
            this.peerings = new ExpressRouteCircuitPeeringsImpl(this);
        }
        return this.peerings;
    }

    @Override
    public ExpressRouteCircuitSkuType sku() {
        return ExpressRouteCircuitSkuType.fromSku(((ExpressRouteCircuitInner)((Object)this.inner())).sku());
    }

    @Override
    public boolean isAllowClassicOperations() {
        return Utils.toPrimitiveBoolean((Boolean)((ExpressRouteCircuitInner)((Object)this.inner())).allowClassicOperations());
    }

    @Override
    public String circuitProvisioningState() {
        return ((ExpressRouteCircuitInner)((Object)this.inner())).circuitProvisioningState();
    }

    @Override
    public ServiceProviderProvisioningState serviceProviderProvisioningState() {
        return ((ExpressRouteCircuitInner)((Object)this.inner())).serviceProviderProvisioningState();
    }

    @Override
    public String serviceKey() {
        return ((ExpressRouteCircuitInner)((Object)this.inner())).serviceKey();
    }

    @Override
    public String serviceProviderNotes() {
        return ((ExpressRouteCircuitInner)((Object)this.inner())).serviceProviderNotes();
    }

    @Override
    public ExpressRouteCircuitServiceProviderProperties serviceProviderProperties() {
        return ((ExpressRouteCircuitInner)((Object)this.inner())).serviceProviderProperties();
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((ExpressRouteCircuitInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public Map<String, ExpressRouteCircuitPeering> peeringsMap() {
        return this.expressRouteCircuitPeerings;
    }
}

