/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.NetworkPeeringGatewayUse;
import com.microsoft.azure.management.network.VirtualNetworkPeeringState;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.VirtualNetworkPeeringInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.IndependentChild;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.List;
import rx.Observable;

@Fluent
@Beta(value=Beta.SinceVersion.V1_3_0)
public interface NetworkPeering
extends IndependentChild<NetworkManager>,
HasInner<VirtualNetworkPeeringInner>,
Refreshable<NetworkPeering>,
Updatable<Update> {
    public String networkId();

    @Beta(value=Beta.SinceVersion.V1_10_0)
    public List<String> remoteAddressSpaces();

    @Method
    public boolean checkAccessBetweenNetworks();

    public String remoteNetworkId();

    @Method
    public Network getRemoteNetwork();

    @Method
    public Observable<Network> getRemoteNetworkAsync();

    @Method
    public NetworkPeering getRemotePeering();

    @Method
    public Observable<NetworkPeering> getRemotePeeringAsync();

    public VirtualNetworkPeeringState state();

    public NetworkPeeringGatewayUse gatewayUse();

    public boolean isTrafficForwardingFromRemoteNetworkAllowed();

    public boolean isSameSubscription();

    public static interface UpdateStages {

        public static interface WithAccess {
            public Update withAccessBetweenBothNetworks();

            public Update withoutAccessFromEitherNetwork();
        }

        public static interface WithTrafficForwarding {
            public Update withTrafficForwardingFromRemoteNetwork();

            public Update withoutTrafficForwardingFromRemoteNetwork();

            public Update withTrafficForwardingToRemoteNetwork();

            public Update withoutTrafficForwardingToRemoteNetwork();

            public Update withTrafficForwardingBetweenBothNetworks();

            public Update withoutTrafficForwardingFromEitherNetwork();
        }

        public static interface WithGatewayUse {
            public Update withGatewayUseByRemoteNetworkAllowed();

            public Update withGatewayUseByRemoteNetworkStarted();

            public Update withGatewayUseOnRemoteNetworkStarted();

            public Update withoutGatewayUseOnRemoteNetwork();

            public Update withoutAnyGatewayUse();

            public Update withoutGatewayUseByRemoteNetwork();
        }
    }

    public static interface Update
    extends Appliable<NetworkPeering>,
    UpdateStages.WithTrafficForwarding,
    UpdateStages.WithAccess,
    UpdateStages.WithGatewayUse {
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithCreate,
    DefinitionStages.WithRemoteNetwork {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<NetworkPeering>,
        WithGatewayUse,
        WithTrafficForwarding,
        WithAccess {
        }

        public static interface WithAccess {
            public WithCreate withoutAccessFromEitherNetwork();
        }

        public static interface WithGatewayUse {
            public WithCreate withGatewayUseByRemoteNetworkAllowed();

            public WithCreate withGatewayUseByRemoteNetworkStarted();

            public WithCreate withGatewayUseOnRemoteNetworkStarted();

            public WithCreate withoutAnyGatewayUse();
        }

        public static interface WithTrafficForwarding {
            public WithCreate withTrafficForwardingFromRemoteNetwork();

            public WithCreate withTrafficForwardingToRemoteNetwork();

            public WithCreate withTrafficForwardingBetweenBothNetworks();
        }

        public static interface WithRemoteNetwork {
            public WithCreate withRemoteNetwork(String var1);

            public WithCreate withRemoteNetwork(Network var1);
        }

        public static interface Blank
        extends WithRemoteNetwork {
        }
    }
}

