/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for Severity.
 */
public final class Severity {
    /** Static value Error for Severity. */
    public static final Severity ERROR = new Severity("Error");

    /** Static value Warning for Severity. */
    public static final Severity WARNING = new Severity("Warning");

    private String value;

    /**
     * Creates a custom value for Severity.
     * @param value the custom value
     */
    public Severity(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Severity)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Severity rhs = (Severity) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
