/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import java.util.List;
import com.microsoft.azure.management.network.implementation.SecurityRuleInner;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * All security rules associated with the network interface.
 */
public class SecurityRuleAssociations {
    /**
     * The networkInterfaceAssociation property.
     */
    @JsonProperty(value = "networkInterfaceAssociation")
    private NetworkInterfaceAssociation networkInterfaceAssociation;

    /**
     * The subnetAssociation property.
     */
    @JsonProperty(value = "subnetAssociation")
    private SubnetAssociation subnetAssociation;

    /**
     * Collection of default security rules of the network security group.
     */
    @JsonProperty(value = "defaultSecurityRules")
    private List<SecurityRuleInner> defaultSecurityRules;

    /**
     * Collection of effective security rules.
     */
    @JsonProperty(value = "effectiveSecurityRules")
    private List<EffectiveNetworkSecurityRule> effectiveSecurityRules;

    /**
     * Get the networkInterfaceAssociation value.
     *
     * @return the networkInterfaceAssociation value
     */
    public NetworkInterfaceAssociation networkInterfaceAssociation() {
        return this.networkInterfaceAssociation;
    }

    /**
     * Set the networkInterfaceAssociation value.
     *
     * @param networkInterfaceAssociation the networkInterfaceAssociation value to set
     * @return the SecurityRuleAssociations object itself.
     */
    public SecurityRuleAssociations withNetworkInterfaceAssociation(NetworkInterfaceAssociation networkInterfaceAssociation) {
        this.networkInterfaceAssociation = networkInterfaceAssociation;
        return this;
    }

    /**
     * Get the subnetAssociation value.
     *
     * @return the subnetAssociation value
     */
    public SubnetAssociation subnetAssociation() {
        return this.subnetAssociation;
    }

    /**
     * Set the subnetAssociation value.
     *
     * @param subnetAssociation the subnetAssociation value to set
     * @return the SecurityRuleAssociations object itself.
     */
    public SecurityRuleAssociations withSubnetAssociation(SubnetAssociation subnetAssociation) {
        this.subnetAssociation = subnetAssociation;
        return this;
    }

    /**
     * Get the defaultSecurityRules value.
     *
     * @return the defaultSecurityRules value
     */
    public List<SecurityRuleInner> defaultSecurityRules() {
        return this.defaultSecurityRules;
    }

    /**
     * Set the defaultSecurityRules value.
     *
     * @param defaultSecurityRules the defaultSecurityRules value to set
     * @return the SecurityRuleAssociations object itself.
     */
    public SecurityRuleAssociations withDefaultSecurityRules(List<SecurityRuleInner> defaultSecurityRules) {
        this.defaultSecurityRules = defaultSecurityRules;
        return this;
    }

    /**
     * Get the effectiveSecurityRules value.
     *
     * @return the effectiveSecurityRules value
     */
    public List<EffectiveNetworkSecurityRule> effectiveSecurityRules() {
        return this.effectiveSecurityRules;
    }

    /**
     * Set the effectiveSecurityRules value.
     *
     * @param effectiveSecurityRules the effectiveSecurityRules value to set
     * @return the SecurityRuleAssociations object itself.
     */
    public SecurityRuleAssociations withEffectiveSecurityRules(List<EffectiveNetworkSecurityRule> effectiveSecurityRules) {
        this.effectiveSecurityRules = effectiveSecurityRules;
        return this;
    }

}
