/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for PublicIPAddressSkuName.
 */
public final class PublicIPAddressSkuName {
    /** Static value Basic for PublicIPAddressSkuName. */
    public static final PublicIPAddressSkuName BASIC = new PublicIPAddressSkuName("Basic");

    /** Static value Standard for PublicIPAddressSkuName. */
    public static final PublicIPAddressSkuName STANDARD = new PublicIPAddressSkuName("Standard");

    private String value;

    /**
     * Creates a custom value for PublicIPAddressSkuName.
     * @param value the custom value
     */
    public PublicIPAddressSkuName(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PublicIPAddressSkuName)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PublicIPAddressSkuName rhs = (PublicIPAddressSkuName) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
