/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for LoadBalancerSkuName.
 */
public final class LoadBalancerSkuName {
    /** Static value Basic for LoadBalancerSkuName. */
    public static final LoadBalancerSkuName BASIC = new LoadBalancerSkuName("Basic");

    /** Static value Standard for LoadBalancerSkuName. */
    public static final LoadBalancerSkuName STANDARD = new LoadBalancerSkuName("Standard");

    private String value;

    /**
     * Creates a custom value for LoadBalancerSkuName.
     * @param value the custom value
     */
    public LoadBalancerSkuName(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof LoadBalancerSkuName)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        LoadBalancerSkuName rhs = (LoadBalancerSkuName) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
