/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for AuthenticationMethod.
 */
public final class AuthenticationMethod {
    /** Static value EAPTLS for AuthenticationMethod. */
    public static final AuthenticationMethod EAPTLS = new AuthenticationMethod("EAPTLS");

    /** Static value EAPMSCHAPv2 for AuthenticationMethod. */
    public static final AuthenticationMethod EAPMSCHAPV2 = new AuthenticationMethod("EAPMSCHAPv2");

    private String value;

    /**
     * Creates a custom value for AuthenticationMethod.
     * @param value the custom value
     */
    public AuthenticationMethod(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AuthenticationMethod)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        AuthenticationMethod rhs = (AuthenticationMethod) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
