/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for AssociationType.
 */
public final class AssociationType {
    /** Static value Associated for AssociationType. */
    public static final AssociationType ASSOCIATED = new AssociationType("Associated");

    /** Static value Contains for AssociationType. */
    public static final AssociationType CONTAINS = new AssociationType("Contains");

    private String value;

    /**
     * Creates a custom value for AssociationType.
     * @param value the custom value
     */
    public AssociationType(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AssociationType)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        AssociationType rhs = (AssociationType) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
