/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for Access.
 */
public final class Access {
    /** Static value Allow for Access. */
    public static final Access ALLOW = new Access("Allow");

    /** Static value Deny for Access. */
    public static final Access DENY = new Access("Deny");

    private String value;

    /**
     * Creates a custom value for Access.
     * @param value the custom value
     */
    public Access(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Access)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Access rhs = (Access) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
