/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.management.network.ErrorException;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.VpnSiteLinkConnectionInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class VpnSiteLinkConnectionsInner {
    private VpnSiteLinkConnectionsService service;
    private NetworkManagementClientImpl client;

    public VpnSiteLinkConnectionsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (VpnSiteLinkConnectionsService)retrofit.create(VpnSiteLinkConnectionsService.class);
        this.client = client;
    }

    public VpnSiteLinkConnectionInner get(String resourceGroupName, String gatewayName, String connectionName, String linkConnectionName) {
        return (VpnSiteLinkConnectionInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, gatewayName, connectionName, linkConnectionName).toBlocking().single()).body());
    }

    public ServiceFuture<VpnSiteLinkConnectionInner> getAsync(String resourceGroupName, String gatewayName, String connectionName, String linkConnectionName, ServiceCallback<VpnSiteLinkConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, gatewayName, connectionName, linkConnectionName), serviceCallback);
    }

    public Observable<VpnSiteLinkConnectionInner> getAsync(String resourceGroupName, String gatewayName, String connectionName, String linkConnectionName) {
        return this.getWithServiceResponseAsync(resourceGroupName, gatewayName, connectionName, linkConnectionName).map((Func1)new Func1<ServiceResponse<VpnSiteLinkConnectionInner>, VpnSiteLinkConnectionInner>(){

            public VpnSiteLinkConnectionInner call(ServiceResponse<VpnSiteLinkConnectionInner> response) {
                return (VpnSiteLinkConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VpnSiteLinkConnectionInner>> getWithServiceResponseAsync(String resourceGroupName, String gatewayName, String connectionName, String linkConnectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (connectionName == null) {
            throw new IllegalArgumentException("Parameter connectionName is required and cannot be null.");
        }
        if (linkConnectionName == null) {
            throw new IllegalArgumentException("Parameter linkConnectionName is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, gatewayName, connectionName, linkConnectionName, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnSiteLinkConnectionInner>>>(){

            public Observable<ServiceResponse<VpnSiteLinkConnectionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VpnSiteLinkConnectionsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VpnSiteLinkConnectionInner> getDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VpnSiteLinkConnectionInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    static interface VpnSiteLinkConnectionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSiteLinkConnections get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnGateways/{gatewayName}/vpnConnections/{connectionName}/vpnLinkConnections/{linkConnectionName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="gatewayName") String var3, @Path(value="connectionName") String var4, @Path(value="linkConnectionName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);
    }
}

