/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.network.ErrorException;
import com.microsoft.azure.management.network.implementation.ApplicationGatewaysInner;
import com.microsoft.azure.management.network.implementation.ApplicationSecurityGroupsInner;
import com.microsoft.azure.management.network.implementation.AvailableDelegationsInner;
import com.microsoft.azure.management.network.implementation.AvailableEndpointServicesInner;
import com.microsoft.azure.management.network.implementation.AvailablePrivateEndpointTypesInner;
import com.microsoft.azure.management.network.implementation.AvailableResourceGroupDelegationsInner;
import com.microsoft.azure.management.network.implementation.AzureFirewallFqdnTagsInner;
import com.microsoft.azure.management.network.implementation.AzureFirewallsInner;
import com.microsoft.azure.management.network.implementation.BastionHostsInner;
import com.microsoft.azure.management.network.implementation.BgpServiceCommunitiesInner;
import com.microsoft.azure.management.network.implementation.ConnectionMonitorsInner;
import com.microsoft.azure.management.network.implementation.DdosCustomPoliciesInner;
import com.microsoft.azure.management.network.implementation.DdosProtectionPlansInner;
import com.microsoft.azure.management.network.implementation.DefaultSecurityRulesInner;
import com.microsoft.azure.management.network.implementation.DnsNameAvailabilityResultInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitAuthorizationsInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitConnectionsInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitPeeringsInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitsInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteConnectionsInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCrossConnectionPeeringsInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCrossConnectionsInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteGatewaysInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteLinksInner;
import com.microsoft.azure.management.network.implementation.ExpressRoutePortsInner;
import com.microsoft.azure.management.network.implementation.ExpressRoutePortsLocationsInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteServiceProvidersInner;
import com.microsoft.azure.management.network.implementation.HubVirtualNetworkConnectionsInner;
import com.microsoft.azure.management.network.implementation.InboundNatRulesInner;
import com.microsoft.azure.management.network.implementation.LoadBalancerBackendAddressPoolsInner;
import com.microsoft.azure.management.network.implementation.LoadBalancerFrontendIPConfigurationsInner;
import com.microsoft.azure.management.network.implementation.LoadBalancerLoadBalancingRulesInner;
import com.microsoft.azure.management.network.implementation.LoadBalancerNetworkInterfacesInner;
import com.microsoft.azure.management.network.implementation.LoadBalancerOutboundRulesInner;
import com.microsoft.azure.management.network.implementation.LoadBalancerProbesInner;
import com.microsoft.azure.management.network.implementation.LoadBalancersInner;
import com.microsoft.azure.management.network.implementation.LocalNetworkGatewaysInner;
import com.microsoft.azure.management.network.implementation.NatGatewaysInner;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceIPConfigurationsInner;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceLoadBalancersInner;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceTapConfigurationsInner;
import com.microsoft.azure.management.network.implementation.NetworkInterfacesInner;
import com.microsoft.azure.management.network.implementation.NetworkProfilesInner;
import com.microsoft.azure.management.network.implementation.NetworkSecurityGroupsInner;
import com.microsoft.azure.management.network.implementation.NetworkWatchersInner;
import com.microsoft.azure.management.network.implementation.OperationsInner;
import com.microsoft.azure.management.network.implementation.P2sVpnGatewaysInner;
import com.microsoft.azure.management.network.implementation.P2sVpnServerConfigurationsInner;
import com.microsoft.azure.management.network.implementation.PacketCapturesInner;
import com.microsoft.azure.management.network.implementation.PeerExpressRouteCircuitConnectionsInner;
import com.microsoft.azure.management.network.implementation.PrivateEndpointsInner;
import com.microsoft.azure.management.network.implementation.PrivateLinkServicesInner;
import com.microsoft.azure.management.network.implementation.PublicIPAddressesInner;
import com.microsoft.azure.management.network.implementation.PublicIPPrefixesInner;
import com.microsoft.azure.management.network.implementation.ResourceNavigationLinksInner;
import com.microsoft.azure.management.network.implementation.RouteFilterRulesInner;
import com.microsoft.azure.management.network.implementation.RouteFiltersInner;
import com.microsoft.azure.management.network.implementation.RouteTablesInner;
import com.microsoft.azure.management.network.implementation.RoutesInner;
import com.microsoft.azure.management.network.implementation.SecurityRulesInner;
import com.microsoft.azure.management.network.implementation.ServiceAssociationLinksInner;
import com.microsoft.azure.management.network.implementation.ServiceEndpointPoliciesInner;
import com.microsoft.azure.management.network.implementation.ServiceEndpointPolicyDefinitionsInner;
import com.microsoft.azure.management.network.implementation.ServiceTagsInner;
import com.microsoft.azure.management.network.implementation.SubnetsInner;
import com.microsoft.azure.management.network.implementation.UsagesInner;
import com.microsoft.azure.management.network.implementation.VirtualHubsInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworkGatewayConnectionsInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworkGatewaysInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworkPeeringsInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworkTapsInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworksInner;
import com.microsoft.azure.management.network.implementation.VirtualWANsInner;
import com.microsoft.azure.management.network.implementation.VirtualWanSecurityProvidersInner;
import com.microsoft.azure.management.network.implementation.VpnConnectionsInner;
import com.microsoft.azure.management.network.implementation.VpnGatewaysInner;
import com.microsoft.azure.management.network.implementation.VpnLinkConnectionsInner;
import com.microsoft.azure.management.network.implementation.VpnSiteLinkConnectionsInner;
import com.microsoft.azure.management.network.implementation.VpnSiteLinksInner;
import com.microsoft.azure.management.network.implementation.VpnSitesConfigurationsInner;
import com.microsoft.azure.management.network.implementation.VpnSitesInner;
import com.microsoft.azure.management.network.implementation.WebApplicationFirewallPoliciesInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class NetworkManagementClientImpl
extends AzureServiceClient {
    private NetworkManagementClientService service;
    private AzureClient azureClient;
    private String subscriptionId;
    private String apiVersion;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private ApplicationGatewaysInner applicationGateways;
    private ApplicationSecurityGroupsInner applicationSecurityGroups;
    private AvailableDelegationsInner availableDelegations;
    private AvailableResourceGroupDelegationsInner availableResourceGroupDelegations;
    private AzureFirewallsInner azureFirewalls;
    private AzureFirewallFqdnTagsInner azureFirewallFqdnTags;
    private BastionHostsInner bastionHosts;
    private DdosCustomPoliciesInner ddosCustomPolicies;
    private DdosProtectionPlansInner ddosProtectionPlans;
    private AvailableEndpointServicesInner availableEndpointServices;
    private ExpressRouteCircuitAuthorizationsInner expressRouteCircuitAuthorizations;
    private ExpressRouteCircuitPeeringsInner expressRouteCircuitPeerings;
    private ExpressRouteCircuitConnectionsInner expressRouteCircuitConnections;
    private PeerExpressRouteCircuitConnectionsInner peerExpressRouteCircuitConnections;
    private ExpressRouteCircuitsInner expressRouteCircuits;
    private ExpressRouteServiceProvidersInner expressRouteServiceProviders;
    private ExpressRouteCrossConnectionsInner expressRouteCrossConnections;
    private ExpressRouteCrossConnectionPeeringsInner expressRouteCrossConnectionPeerings;
    private ExpressRouteGatewaysInner expressRouteGateways;
    private ExpressRouteConnectionsInner expressRouteConnections;
    private ExpressRoutePortsLocationsInner expressRoutePortsLocations;
    private ExpressRoutePortsInner expressRoutePorts;
    private ExpressRouteLinksInner expressRouteLinks;
    private LoadBalancersInner loadBalancers;
    private LoadBalancerBackendAddressPoolsInner loadBalancerBackendAddressPools;
    private LoadBalancerFrontendIPConfigurationsInner loadBalancerFrontendIPConfigurations;
    private InboundNatRulesInner inboundNatRules;
    private LoadBalancerLoadBalancingRulesInner loadBalancerLoadBalancingRules;
    private LoadBalancerOutboundRulesInner loadBalancerOutboundRules;
    private LoadBalancerNetworkInterfacesInner loadBalancerNetworkInterfaces;
    private LoadBalancerProbesInner loadBalancerProbes;
    private NatGatewaysInner natGateways;
    private NetworkInterfacesInner networkInterfaces;
    private NetworkInterfaceIPConfigurationsInner networkInterfaceIPConfigurations;
    private NetworkInterfaceLoadBalancersInner networkInterfaceLoadBalancers;
    private NetworkInterfaceTapConfigurationsInner networkInterfaceTapConfigurations;
    private NetworkProfilesInner networkProfiles;
    private NetworkSecurityGroupsInner networkSecurityGroups;
    private SecurityRulesInner securityRules;
    private DefaultSecurityRulesInner defaultSecurityRules;
    private NetworkWatchersInner networkWatchers;
    private PacketCapturesInner packetCaptures;
    private ConnectionMonitorsInner connectionMonitors;
    private OperationsInner operations;
    private PrivateEndpointsInner privateEndpoints;
    private AvailablePrivateEndpointTypesInner availablePrivateEndpointTypes;
    private PrivateLinkServicesInner privateLinkServices;
    private PublicIPAddressesInner publicIPAddresses;
    private PublicIPPrefixesInner publicIPPrefixes;
    private RouteFiltersInner routeFilters;
    private RouteFilterRulesInner routeFilterRules;
    private RouteTablesInner routeTables;
    private RoutesInner routes;
    private BgpServiceCommunitiesInner bgpServiceCommunities;
    private ServiceEndpointPoliciesInner serviceEndpointPolicies;
    private ServiceEndpointPolicyDefinitionsInner serviceEndpointPolicyDefinitions;
    private ServiceTagsInner serviceTags;
    private UsagesInner usages;
    private VirtualNetworksInner virtualNetworks;
    private SubnetsInner subnets;
    private ResourceNavigationLinksInner resourceNavigationLinks;
    private ServiceAssociationLinksInner serviceAssociationLinks;
    private VirtualNetworkPeeringsInner virtualNetworkPeerings;
    private VirtualNetworkGatewaysInner virtualNetworkGateways;
    private VirtualNetworkGatewayConnectionsInner virtualNetworkGatewayConnections;
    private LocalNetworkGatewaysInner localNetworkGateways;
    private VirtualNetworkTapsInner virtualNetworkTaps;
    private VirtualWANsInner virtualWans;
    private VpnSitesInner vpnSites;
    private VpnSiteLinksInner vpnSiteLinks;
    private VpnSitesConfigurationsInner vpnSitesConfigurations;
    private VirtualHubsInner virtualHubs;
    private HubVirtualNetworkConnectionsInner hubVirtualNetworkConnections;
    private VpnGatewaysInner vpnGateways;
    private VpnConnectionsInner vpnConnections;
    private VpnSiteLinkConnectionsInner vpnSiteLinkConnections;
    private VpnLinkConnectionsInner vpnLinkConnections;
    private P2sVpnServerConfigurationsInner p2sVpnServerConfigurations;
    private P2sVpnGatewaysInner p2sVpnGateways;
    private WebApplicationFirewallPoliciesInner webApplicationFirewallPolicies;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public NetworkManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public NetworkManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public NetworkManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public NetworkManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public ApplicationGatewaysInner applicationGateways() {
        return this.applicationGateways;
    }

    public ApplicationSecurityGroupsInner applicationSecurityGroups() {
        return this.applicationSecurityGroups;
    }

    public AvailableDelegationsInner availableDelegations() {
        return this.availableDelegations;
    }

    public AvailableResourceGroupDelegationsInner availableResourceGroupDelegations() {
        return this.availableResourceGroupDelegations;
    }

    public AzureFirewallsInner azureFirewalls() {
        return this.azureFirewalls;
    }

    public AzureFirewallFqdnTagsInner azureFirewallFqdnTags() {
        return this.azureFirewallFqdnTags;
    }

    public BastionHostsInner bastionHosts() {
        return this.bastionHosts;
    }

    public DdosCustomPoliciesInner ddosCustomPolicies() {
        return this.ddosCustomPolicies;
    }

    public DdosProtectionPlansInner ddosProtectionPlans() {
        return this.ddosProtectionPlans;
    }

    public AvailableEndpointServicesInner availableEndpointServices() {
        return this.availableEndpointServices;
    }

    public ExpressRouteCircuitAuthorizationsInner expressRouteCircuitAuthorizations() {
        return this.expressRouteCircuitAuthorizations;
    }

    public ExpressRouteCircuitPeeringsInner expressRouteCircuitPeerings() {
        return this.expressRouteCircuitPeerings;
    }

    public ExpressRouteCircuitConnectionsInner expressRouteCircuitConnections() {
        return this.expressRouteCircuitConnections;
    }

    public PeerExpressRouteCircuitConnectionsInner peerExpressRouteCircuitConnections() {
        return this.peerExpressRouteCircuitConnections;
    }

    public ExpressRouteCircuitsInner expressRouteCircuits() {
        return this.expressRouteCircuits;
    }

    public ExpressRouteServiceProvidersInner expressRouteServiceProviders() {
        return this.expressRouteServiceProviders;
    }

    public ExpressRouteCrossConnectionsInner expressRouteCrossConnections() {
        return this.expressRouteCrossConnections;
    }

    public ExpressRouteCrossConnectionPeeringsInner expressRouteCrossConnectionPeerings() {
        return this.expressRouteCrossConnectionPeerings;
    }

    public ExpressRouteGatewaysInner expressRouteGateways() {
        return this.expressRouteGateways;
    }

    public ExpressRouteConnectionsInner expressRouteConnections() {
        return this.expressRouteConnections;
    }

    public ExpressRoutePortsLocationsInner expressRoutePortsLocations() {
        return this.expressRoutePortsLocations;
    }

    public ExpressRoutePortsInner expressRoutePorts() {
        return this.expressRoutePorts;
    }

    public ExpressRouteLinksInner expressRouteLinks() {
        return this.expressRouteLinks;
    }

    public LoadBalancersInner loadBalancers() {
        return this.loadBalancers;
    }

    public LoadBalancerBackendAddressPoolsInner loadBalancerBackendAddressPools() {
        return this.loadBalancerBackendAddressPools;
    }

    public LoadBalancerFrontendIPConfigurationsInner loadBalancerFrontendIPConfigurations() {
        return this.loadBalancerFrontendIPConfigurations;
    }

    public InboundNatRulesInner inboundNatRules() {
        return this.inboundNatRules;
    }

    public LoadBalancerLoadBalancingRulesInner loadBalancerLoadBalancingRules() {
        return this.loadBalancerLoadBalancingRules;
    }

    public LoadBalancerOutboundRulesInner loadBalancerOutboundRules() {
        return this.loadBalancerOutboundRules;
    }

    public LoadBalancerNetworkInterfacesInner loadBalancerNetworkInterfaces() {
        return this.loadBalancerNetworkInterfaces;
    }

    public LoadBalancerProbesInner loadBalancerProbes() {
        return this.loadBalancerProbes;
    }

    public NatGatewaysInner natGateways() {
        return this.natGateways;
    }

    public NetworkInterfacesInner networkInterfaces() {
        return this.networkInterfaces;
    }

    public NetworkInterfaceIPConfigurationsInner networkInterfaceIPConfigurations() {
        return this.networkInterfaceIPConfigurations;
    }

    public NetworkInterfaceLoadBalancersInner networkInterfaceLoadBalancers() {
        return this.networkInterfaceLoadBalancers;
    }

    public NetworkInterfaceTapConfigurationsInner networkInterfaceTapConfigurations() {
        return this.networkInterfaceTapConfigurations;
    }

    public NetworkProfilesInner networkProfiles() {
        return this.networkProfiles;
    }

    public NetworkSecurityGroupsInner networkSecurityGroups() {
        return this.networkSecurityGroups;
    }

    public SecurityRulesInner securityRules() {
        return this.securityRules;
    }

    public DefaultSecurityRulesInner defaultSecurityRules() {
        return this.defaultSecurityRules;
    }

    public NetworkWatchersInner networkWatchers() {
        return this.networkWatchers;
    }

    public PacketCapturesInner packetCaptures() {
        return this.packetCaptures;
    }

    public ConnectionMonitorsInner connectionMonitors() {
        return this.connectionMonitors;
    }

    public OperationsInner operations() {
        return this.operations;
    }

    public PrivateEndpointsInner privateEndpoints() {
        return this.privateEndpoints;
    }

    public AvailablePrivateEndpointTypesInner availablePrivateEndpointTypes() {
        return this.availablePrivateEndpointTypes;
    }

    public PrivateLinkServicesInner privateLinkServices() {
        return this.privateLinkServices;
    }

    public PublicIPAddressesInner publicIPAddresses() {
        return this.publicIPAddresses;
    }

    public PublicIPPrefixesInner publicIPPrefixes() {
        return this.publicIPPrefixes;
    }

    public RouteFiltersInner routeFilters() {
        return this.routeFilters;
    }

    public RouteFilterRulesInner routeFilterRules() {
        return this.routeFilterRules;
    }

    public RouteTablesInner routeTables() {
        return this.routeTables;
    }

    public RoutesInner routes() {
        return this.routes;
    }

    public BgpServiceCommunitiesInner bgpServiceCommunities() {
        return this.bgpServiceCommunities;
    }

    public ServiceEndpointPoliciesInner serviceEndpointPolicies() {
        return this.serviceEndpointPolicies;
    }

    public ServiceEndpointPolicyDefinitionsInner serviceEndpointPolicyDefinitions() {
        return this.serviceEndpointPolicyDefinitions;
    }

    public ServiceTagsInner serviceTags() {
        return this.serviceTags;
    }

    public UsagesInner usages() {
        return this.usages;
    }

    public VirtualNetworksInner virtualNetworks() {
        return this.virtualNetworks;
    }

    public SubnetsInner subnets() {
        return this.subnets;
    }

    public ResourceNavigationLinksInner resourceNavigationLinks() {
        return this.resourceNavigationLinks;
    }

    public ServiceAssociationLinksInner serviceAssociationLinks() {
        return this.serviceAssociationLinks;
    }

    public VirtualNetworkPeeringsInner virtualNetworkPeerings() {
        return this.virtualNetworkPeerings;
    }

    public VirtualNetworkGatewaysInner virtualNetworkGateways() {
        return this.virtualNetworkGateways;
    }

    public VirtualNetworkGatewayConnectionsInner virtualNetworkGatewayConnections() {
        return this.virtualNetworkGatewayConnections;
    }

    public LocalNetworkGatewaysInner localNetworkGateways() {
        return this.localNetworkGateways;
    }

    public VirtualNetworkTapsInner virtualNetworkTaps() {
        return this.virtualNetworkTaps;
    }

    public VirtualWANsInner virtualWans() {
        return this.virtualWans;
    }

    public VpnSitesInner vpnSites() {
        return this.vpnSites;
    }

    public VpnSiteLinksInner vpnSiteLinks() {
        return this.vpnSiteLinks;
    }

    public VpnSitesConfigurationsInner vpnSitesConfigurations() {
        return this.vpnSitesConfigurations;
    }

    public VirtualHubsInner virtualHubs() {
        return this.virtualHubs;
    }

    public HubVirtualNetworkConnectionsInner hubVirtualNetworkConnections() {
        return this.hubVirtualNetworkConnections;
    }

    public VpnGatewaysInner vpnGateways() {
        return this.vpnGateways;
    }

    public VpnConnectionsInner vpnConnections() {
        return this.vpnConnections;
    }

    public VpnSiteLinkConnectionsInner vpnSiteLinkConnections() {
        return this.vpnSiteLinkConnections;
    }

    public VpnLinkConnectionsInner vpnLinkConnections() {
        return this.vpnLinkConnections;
    }

    public P2sVpnServerConfigurationsInner p2sVpnServerConfigurations() {
        return this.p2sVpnServerConfigurations;
    }

    public P2sVpnGatewaysInner p2sVpnGateways() {
        return this.p2sVpnGateways;
    }

    public WebApplicationFirewallPoliciesInner webApplicationFirewallPolicies() {
        return this.webApplicationFirewallPolicies;
    }

    public NetworkManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public NetworkManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public NetworkManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.applicationGateways = new ApplicationGatewaysInner(this.restClient().retrofit(), this);
        this.applicationSecurityGroups = new ApplicationSecurityGroupsInner(this.restClient().retrofit(), this);
        this.availableDelegations = new AvailableDelegationsInner(this.restClient().retrofit(), this);
        this.availableResourceGroupDelegations = new AvailableResourceGroupDelegationsInner(this.restClient().retrofit(), this);
        this.azureFirewalls = new AzureFirewallsInner(this.restClient().retrofit(), this);
        this.azureFirewallFqdnTags = new AzureFirewallFqdnTagsInner(this.restClient().retrofit(), this);
        this.bastionHosts = new BastionHostsInner(this.restClient().retrofit(), this);
        this.ddosCustomPolicies = new DdosCustomPoliciesInner(this.restClient().retrofit(), this);
        this.ddosProtectionPlans = new DdosProtectionPlansInner(this.restClient().retrofit(), this);
        this.availableEndpointServices = new AvailableEndpointServicesInner(this.restClient().retrofit(), this);
        this.expressRouteCircuitAuthorizations = new ExpressRouteCircuitAuthorizationsInner(this.restClient().retrofit(), this);
        this.expressRouteCircuitPeerings = new ExpressRouteCircuitPeeringsInner(this.restClient().retrofit(), this);
        this.expressRouteCircuitConnections = new ExpressRouteCircuitConnectionsInner(this.restClient().retrofit(), this);
        this.peerExpressRouteCircuitConnections = new PeerExpressRouteCircuitConnectionsInner(this.restClient().retrofit(), this);
        this.expressRouteCircuits = new ExpressRouteCircuitsInner(this.restClient().retrofit(), this);
        this.expressRouteServiceProviders = new ExpressRouteServiceProvidersInner(this.restClient().retrofit(), this);
        this.expressRouteCrossConnections = new ExpressRouteCrossConnectionsInner(this.restClient().retrofit(), this);
        this.expressRouteCrossConnectionPeerings = new ExpressRouteCrossConnectionPeeringsInner(this.restClient().retrofit(), this);
        this.expressRouteGateways = new ExpressRouteGatewaysInner(this.restClient().retrofit(), this);
        this.expressRouteConnections = new ExpressRouteConnectionsInner(this.restClient().retrofit(), this);
        this.expressRoutePortsLocations = new ExpressRoutePortsLocationsInner(this.restClient().retrofit(), this);
        this.expressRoutePorts = new ExpressRoutePortsInner(this.restClient().retrofit(), this);
        this.expressRouteLinks = new ExpressRouteLinksInner(this.restClient().retrofit(), this);
        this.loadBalancers = new LoadBalancersInner(this.restClient().retrofit(), this);
        this.loadBalancerBackendAddressPools = new LoadBalancerBackendAddressPoolsInner(this.restClient().retrofit(), this);
        this.loadBalancerFrontendIPConfigurations = new LoadBalancerFrontendIPConfigurationsInner(this.restClient().retrofit(), this);
        this.inboundNatRules = new InboundNatRulesInner(this.restClient().retrofit(), this);
        this.loadBalancerLoadBalancingRules = new LoadBalancerLoadBalancingRulesInner(this.restClient().retrofit(), this);
        this.loadBalancerOutboundRules = new LoadBalancerOutboundRulesInner(this.restClient().retrofit(), this);
        this.loadBalancerNetworkInterfaces = new LoadBalancerNetworkInterfacesInner(this.restClient().retrofit(), this);
        this.loadBalancerProbes = new LoadBalancerProbesInner(this.restClient().retrofit(), this);
        this.natGateways = new NatGatewaysInner(this.restClient().retrofit(), this);
        this.networkInterfaces = new NetworkInterfacesInner(this.restClient().retrofit(), this);
        this.networkInterfaceIPConfigurations = new NetworkInterfaceIPConfigurationsInner(this.restClient().retrofit(), this);
        this.networkInterfaceLoadBalancers = new NetworkInterfaceLoadBalancersInner(this.restClient().retrofit(), this);
        this.networkInterfaceTapConfigurations = new NetworkInterfaceTapConfigurationsInner(this.restClient().retrofit(), this);
        this.networkProfiles = new NetworkProfilesInner(this.restClient().retrofit(), this);
        this.networkSecurityGroups = new NetworkSecurityGroupsInner(this.restClient().retrofit(), this);
        this.securityRules = new SecurityRulesInner(this.restClient().retrofit(), this);
        this.defaultSecurityRules = new DefaultSecurityRulesInner(this.restClient().retrofit(), this);
        this.networkWatchers = new NetworkWatchersInner(this.restClient().retrofit(), this);
        this.packetCaptures = new PacketCapturesInner(this.restClient().retrofit(), this);
        this.connectionMonitors = new ConnectionMonitorsInner(this.restClient().retrofit(), this);
        this.operations = new OperationsInner(this.restClient().retrofit(), this);
        this.privateEndpoints = new PrivateEndpointsInner(this.restClient().retrofit(), this);
        this.availablePrivateEndpointTypes = new AvailablePrivateEndpointTypesInner(this.restClient().retrofit(), this);
        this.privateLinkServices = new PrivateLinkServicesInner(this.restClient().retrofit(), this);
        this.publicIPAddresses = new PublicIPAddressesInner(this.restClient().retrofit(), this);
        this.publicIPPrefixes = new PublicIPPrefixesInner(this.restClient().retrofit(), this);
        this.routeFilters = new RouteFiltersInner(this.restClient().retrofit(), this);
        this.routeFilterRules = new RouteFilterRulesInner(this.restClient().retrofit(), this);
        this.routeTables = new RouteTablesInner(this.restClient().retrofit(), this);
        this.routes = new RoutesInner(this.restClient().retrofit(), this);
        this.bgpServiceCommunities = new BgpServiceCommunitiesInner(this.restClient().retrofit(), this);
        this.serviceEndpointPolicies = new ServiceEndpointPoliciesInner(this.restClient().retrofit(), this);
        this.serviceEndpointPolicyDefinitions = new ServiceEndpointPolicyDefinitionsInner(this.restClient().retrofit(), this);
        this.serviceTags = new ServiceTagsInner(this.restClient().retrofit(), this);
        this.usages = new UsagesInner(this.restClient().retrofit(), this);
        this.virtualNetworks = new VirtualNetworksInner(this.restClient().retrofit(), this);
        this.subnets = new SubnetsInner(this.restClient().retrofit(), this);
        this.resourceNavigationLinks = new ResourceNavigationLinksInner(this.restClient().retrofit(), this);
        this.serviceAssociationLinks = new ServiceAssociationLinksInner(this.restClient().retrofit(), this);
        this.virtualNetworkPeerings = new VirtualNetworkPeeringsInner(this.restClient().retrofit(), this);
        this.virtualNetworkGateways = new VirtualNetworkGatewaysInner(this.restClient().retrofit(), this);
        this.virtualNetworkGatewayConnections = new VirtualNetworkGatewayConnectionsInner(this.restClient().retrofit(), this);
        this.localNetworkGateways = new LocalNetworkGatewaysInner(this.restClient().retrofit(), this);
        this.virtualNetworkTaps = new VirtualNetworkTapsInner(this.restClient().retrofit(), this);
        this.virtualWans = new VirtualWANsInner(this.restClient().retrofit(), this);
        this.vpnSites = new VpnSitesInner(this.restClient().retrofit(), this);
        this.vpnSiteLinks = new VpnSiteLinksInner(this.restClient().retrofit(), this);
        this.vpnSitesConfigurations = new VpnSitesConfigurationsInner(this.restClient().retrofit(), this);
        this.virtualHubs = new VirtualHubsInner(this.restClient().retrofit(), this);
        this.hubVirtualNetworkConnections = new HubVirtualNetworkConnectionsInner(this.restClient().retrofit(), this);
        this.vpnGateways = new VpnGatewaysInner(this.restClient().retrofit(), this);
        this.vpnConnections = new VpnConnectionsInner(this.restClient().retrofit(), this);
        this.vpnSiteLinkConnections = new VpnSiteLinkConnectionsInner(this.restClient().retrofit(), this);
        this.vpnLinkConnections = new VpnLinkConnectionsInner(this.restClient().retrofit(), this);
        this.p2sVpnServerConfigurations = new P2sVpnServerConfigurationsInner(this.restClient().retrofit(), this);
        this.p2sVpnGateways = new P2sVpnGatewaysInner(this.restClient().retrofit(), this);
        this.webApplicationFirewallPolicies = new WebApplicationFirewallPoliciesInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
        this.initializeService();
    }

    public String userAgent() {
        return String.format("%s (%s)", super.userAgent(), "NetworkManagementClient");
    }

    private void initializeService() {
        this.service = (NetworkManagementClientService)this.restClient().retrofit().create(NetworkManagementClientService.class);
    }

    public DnsNameAvailabilityResultInner checkDnsNameAvailability(String location, String domainNameLabel) {
        return (DnsNameAvailabilityResultInner)((ServiceResponse)this.checkDnsNameAvailabilityWithServiceResponseAsync(location, domainNameLabel).toBlocking().single()).body();
    }

    public ServiceFuture<DnsNameAvailabilityResultInner> checkDnsNameAvailabilityAsync(String location, String domainNameLabel, ServiceCallback<DnsNameAvailabilityResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkDnsNameAvailabilityWithServiceResponseAsync(location, domainNameLabel), serviceCallback);
    }

    public Observable<DnsNameAvailabilityResultInner> checkDnsNameAvailabilityAsync(String location, String domainNameLabel) {
        return this.checkDnsNameAvailabilityWithServiceResponseAsync(location, domainNameLabel).map((Func1)new Func1<ServiceResponse<DnsNameAvailabilityResultInner>, DnsNameAvailabilityResultInner>(){

            public DnsNameAvailabilityResultInner call(ServiceResponse<DnsNameAvailabilityResultInner> response) {
                return (DnsNameAvailabilityResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DnsNameAvailabilityResultInner>> checkDnsNameAvailabilityWithServiceResponseAsync(String location, String domainNameLabel) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (domainNameLabel == null) {
            throw new IllegalArgumentException("Parameter domainNameLabel is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.checkDnsNameAvailability(location, this.subscriptionId(), domainNameLabel, "2019-06-01", this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DnsNameAvailabilityResultInner>>>(){

            public Observable<ServiceResponse<DnsNameAvailabilityResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkManagementClientImpl.this.checkDnsNameAvailabilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DnsNameAvailabilityResultInner> checkDnsNameAvailabilityDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<DnsNameAvailabilityResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VirtualWanSecurityProvidersInner supportedSecurityProviders(String resourceGroupName, String virtualWANName) {
        return (VirtualWanSecurityProvidersInner)((ServiceResponse)this.supportedSecurityProvidersWithServiceResponseAsync(resourceGroupName, virtualWANName).toBlocking().single()).body();
    }

    public ServiceFuture<VirtualWanSecurityProvidersInner> supportedSecurityProvidersAsync(String resourceGroupName, String virtualWANName, ServiceCallback<VirtualWanSecurityProvidersInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.supportedSecurityProvidersWithServiceResponseAsync(resourceGroupName, virtualWANName), serviceCallback);
    }

    public Observable<VirtualWanSecurityProvidersInner> supportedSecurityProvidersAsync(String resourceGroupName, String virtualWANName) {
        return this.supportedSecurityProvidersWithServiceResponseAsync(resourceGroupName, virtualWANName).map((Func1)new Func1<ServiceResponse<VirtualWanSecurityProvidersInner>, VirtualWanSecurityProvidersInner>(){

            public VirtualWanSecurityProvidersInner call(ServiceResponse<VirtualWanSecurityProvidersInner> response) {
                return (VirtualWanSecurityProvidersInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VirtualWanSecurityProvidersInner>> supportedSecurityProvidersWithServiceResponseAsync(String resourceGroupName, String virtualWANName) {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.supportedSecurityProviders(this.subscriptionId(), resourceGroupName, virtualWANName, "2019-06-01", this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualWanSecurityProvidersInner>>>(){

            public Observable<ServiceResponse<VirtualWanSecurityProvidersInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkManagementClientImpl.this.supportedSecurityProvidersDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualWanSecurityProvidersInner> supportedSecurityProvidersDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<VirtualWanSecurityProvidersInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    static interface NetworkManagementClientService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient checkDnsNameAvailability"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/locations/{location}/CheckDnsNameAvailability")
        public Observable<Response<ResponseBody>> checkDnsNameAvailability(@Path(value="location") String var1, @Path(value="subscriptionId") String var2, @Query(value="domainNameLabel") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient supportedSecurityProviders"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWANName}/supportedSecurityProviders")
        public Observable<Response<ResponseBody>> supportedSecurityProviders(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualWANName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);
    }
}

