/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceIPConfigurationInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class NetworkInterfaceIPConfigurationsInner {
    private NetworkInterfaceIPConfigurationsService service;
    private NetworkManagementClientImpl client;

    public NetworkInterfaceIPConfigurationsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (NetworkInterfaceIPConfigurationsService)retrofit.create(NetworkInterfaceIPConfigurationsService.class);
        this.client = client;
    }

    public PagedList<NetworkInterfaceIPConfigurationInner> list(String resourceGroupName, String networkInterfaceName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, networkInterfaceName).toBlocking().single();
        return new PagedList<NetworkInterfaceIPConfigurationInner>((Page)response.body()){

            public Page<NetworkInterfaceIPConfigurationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NetworkInterfaceIPConfigurationsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<NetworkInterfaceIPConfigurationInner>> listAsync(String resourceGroupName, String networkInterfaceName, ListOperationCallback<NetworkInterfaceIPConfigurationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, networkInterfaceName), (Func1)new Func1<String, Observable<ServiceResponse<Page<NetworkInterfaceIPConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<NetworkInterfaceIPConfigurationInner>>> call(String nextPageLink) {
                return NetworkInterfaceIPConfigurationsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<NetworkInterfaceIPConfigurationInner>> listAsync(String resourceGroupName, String networkInterfaceName) {
        return this.listWithServiceResponseAsync(resourceGroupName, networkInterfaceName).map((Func1)new Func1<ServiceResponse<Page<NetworkInterfaceIPConfigurationInner>>, Page<NetworkInterfaceIPConfigurationInner>>(){

            public Page<NetworkInterfaceIPConfigurationInner> call(ServiceResponse<Page<NetworkInterfaceIPConfigurationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<NetworkInterfaceIPConfigurationInner>>> listWithServiceResponseAsync(String resourceGroupName, String networkInterfaceName) {
        return this.listSinglePageAsync(resourceGroupName, networkInterfaceName).concatMap((Func1)new Func1<ServiceResponse<Page<NetworkInterfaceIPConfigurationInner>>, Observable<ServiceResponse<Page<NetworkInterfaceIPConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<NetworkInterfaceIPConfigurationInner>>> call(ServiceResponse<Page<NetworkInterfaceIPConfigurationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NetworkInterfaceIPConfigurationsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<NetworkInterfaceIPConfigurationInner>>> listSinglePageAsync(String resourceGroupName, String networkInterfaceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkInterfaceName == null) {
            throw new IllegalArgumentException("Parameter networkInterfaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.list(resourceGroupName, networkInterfaceName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<NetworkInterfaceIPConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<NetworkInterfaceIPConfigurationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NetworkInterfaceIPConfigurationsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<NetworkInterfaceIPConfigurationInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<NetworkInterfaceIPConfigurationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public NetworkInterfaceIPConfigurationInner get(String resourceGroupName, String networkInterfaceName, String ipConfigurationName) {
        return (NetworkInterfaceIPConfigurationInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, networkInterfaceName, ipConfigurationName).toBlocking().single()).body());
    }

    public ServiceFuture<NetworkInterfaceIPConfigurationInner> getAsync(String resourceGroupName, String networkInterfaceName, String ipConfigurationName, ServiceCallback<NetworkInterfaceIPConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, networkInterfaceName, ipConfigurationName), serviceCallback);
    }

    public Observable<NetworkInterfaceIPConfigurationInner> getAsync(String resourceGroupName, String networkInterfaceName, String ipConfigurationName) {
        return this.getWithServiceResponseAsync(resourceGroupName, networkInterfaceName, ipConfigurationName).map((Func1)new Func1<ServiceResponse<NetworkInterfaceIPConfigurationInner>, NetworkInterfaceIPConfigurationInner>(){

            public NetworkInterfaceIPConfigurationInner call(ServiceResponse<NetworkInterfaceIPConfigurationInner> response) {
                return (NetworkInterfaceIPConfigurationInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<NetworkInterfaceIPConfigurationInner>> getWithServiceResponseAsync(String resourceGroupName, String networkInterfaceName, String ipConfigurationName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkInterfaceName == null) {
            throw new IllegalArgumentException("Parameter networkInterfaceName is required and cannot be null.");
        }
        if (ipConfigurationName == null) {
            throw new IllegalArgumentException("Parameter ipConfigurationName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.get(resourceGroupName, networkInterfaceName, ipConfigurationName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<NetworkInterfaceIPConfigurationInner>>>(){

            public Observable<ServiceResponse<NetworkInterfaceIPConfigurationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkInterfaceIPConfigurationsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<NetworkInterfaceIPConfigurationInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<NetworkInterfaceIPConfigurationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<NetworkInterfaceIPConfigurationInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<NetworkInterfaceIPConfigurationInner>((Page)response.body()){

            public Page<NetworkInterfaceIPConfigurationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NetworkInterfaceIPConfigurationsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<NetworkInterfaceIPConfigurationInner>> listNextAsync(String nextPageLink, ServiceFuture<List<NetworkInterfaceIPConfigurationInner>> serviceFuture, ListOperationCallback<NetworkInterfaceIPConfigurationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<NetworkInterfaceIPConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<NetworkInterfaceIPConfigurationInner>>> call(String nextPageLink) {
                return NetworkInterfaceIPConfigurationsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<NetworkInterfaceIPConfigurationInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<NetworkInterfaceIPConfigurationInner>>, Page<NetworkInterfaceIPConfigurationInner>>(){

            public Page<NetworkInterfaceIPConfigurationInner> call(ServiceResponse<Page<NetworkInterfaceIPConfigurationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<NetworkInterfaceIPConfigurationInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<NetworkInterfaceIPConfigurationInner>>, Observable<ServiceResponse<Page<NetworkInterfaceIPConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<NetworkInterfaceIPConfigurationInner>>> call(ServiceResponse<Page<NetworkInterfaceIPConfigurationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NetworkInterfaceIPConfigurationsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<NetworkInterfaceIPConfigurationInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<NetworkInterfaceIPConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<NetworkInterfaceIPConfigurationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NetworkInterfaceIPConfigurationsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<NetworkInterfaceIPConfigurationInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<NetworkInterfaceIPConfigurationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface NetworkInterfaceIPConfigurationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkInterfaceIPConfigurations list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}/ipConfigurations")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="networkInterfaceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkInterfaceIPConfigurations get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}/ipConfigurations/{ipConfigurationName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="networkInterfaceName") String var2, @Path(value="ipConfigurationName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkInterfaceIPConfigurations listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

