/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.FrontendIPConfigurationInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class LoadBalancerFrontendIPConfigurationsInner {
    private LoadBalancerFrontendIPConfigurationsService service;
    private NetworkManagementClientImpl client;

    public LoadBalancerFrontendIPConfigurationsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (LoadBalancerFrontendIPConfigurationsService)retrofit.create(LoadBalancerFrontendIPConfigurationsService.class);
        this.client = client;
    }

    public PagedList<FrontendIPConfigurationInner> list(String resourceGroupName, String loadBalancerName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, loadBalancerName).toBlocking().single();
        return new PagedList<FrontendIPConfigurationInner>((Page)response.body()){

            public Page<FrontendIPConfigurationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LoadBalancerFrontendIPConfigurationsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FrontendIPConfigurationInner>> listAsync(String resourceGroupName, String loadBalancerName, ListOperationCallback<FrontendIPConfigurationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, loadBalancerName), (Func1)new Func1<String, Observable<ServiceResponse<Page<FrontendIPConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<FrontendIPConfigurationInner>>> call(String nextPageLink) {
                return LoadBalancerFrontendIPConfigurationsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FrontendIPConfigurationInner>> listAsync(String resourceGroupName, String loadBalancerName) {
        return this.listWithServiceResponseAsync(resourceGroupName, loadBalancerName).map((Func1)new Func1<ServiceResponse<Page<FrontendIPConfigurationInner>>, Page<FrontendIPConfigurationInner>>(){

            public Page<FrontendIPConfigurationInner> call(ServiceResponse<Page<FrontendIPConfigurationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FrontendIPConfigurationInner>>> listWithServiceResponseAsync(String resourceGroupName, String loadBalancerName) {
        return this.listSinglePageAsync(resourceGroupName, loadBalancerName).concatMap((Func1)new Func1<ServiceResponse<Page<FrontendIPConfigurationInner>>, Observable<ServiceResponse<Page<FrontendIPConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<FrontendIPConfigurationInner>>> call(ServiceResponse<Page<FrontendIPConfigurationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LoadBalancerFrontendIPConfigurationsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FrontendIPConfigurationInner>>> listSinglePageAsync(String resourceGroupName, String loadBalancerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.list(resourceGroupName, loadBalancerName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FrontendIPConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<FrontendIPConfigurationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LoadBalancerFrontendIPConfigurationsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FrontendIPConfigurationInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<FrontendIPConfigurationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public FrontendIPConfigurationInner get(String resourceGroupName, String loadBalancerName, String frontendIPConfigurationName) {
        return (FrontendIPConfigurationInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName, frontendIPConfigurationName).toBlocking().single()).body());
    }

    public ServiceFuture<FrontendIPConfigurationInner> getAsync(String resourceGroupName, String loadBalancerName, String frontendIPConfigurationName, ServiceCallback<FrontendIPConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName, frontendIPConfigurationName), serviceCallback);
    }

    public Observable<FrontendIPConfigurationInner> getAsync(String resourceGroupName, String loadBalancerName, String frontendIPConfigurationName) {
        return this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName, frontendIPConfigurationName).map((Func1)new Func1<ServiceResponse<FrontendIPConfigurationInner>, FrontendIPConfigurationInner>(){

            public FrontendIPConfigurationInner call(ServiceResponse<FrontendIPConfigurationInner> response) {
                return (FrontendIPConfigurationInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FrontendIPConfigurationInner>> getWithServiceResponseAsync(String resourceGroupName, String loadBalancerName, String frontendIPConfigurationName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (frontendIPConfigurationName == null) {
            throw new IllegalArgumentException("Parameter frontendIPConfigurationName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.get(resourceGroupName, loadBalancerName, frontendIPConfigurationName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FrontendIPConfigurationInner>>>(){

            public Observable<ServiceResponse<FrontendIPConfigurationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LoadBalancerFrontendIPConfigurationsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FrontendIPConfigurationInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FrontendIPConfigurationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<FrontendIPConfigurationInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<FrontendIPConfigurationInner>((Page)response.body()){

            public Page<FrontendIPConfigurationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LoadBalancerFrontendIPConfigurationsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FrontendIPConfigurationInner>> listNextAsync(String nextPageLink, ServiceFuture<List<FrontendIPConfigurationInner>> serviceFuture, ListOperationCallback<FrontendIPConfigurationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<FrontendIPConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<FrontendIPConfigurationInner>>> call(String nextPageLink) {
                return LoadBalancerFrontendIPConfigurationsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FrontendIPConfigurationInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<FrontendIPConfigurationInner>>, Page<FrontendIPConfigurationInner>>(){

            public Page<FrontendIPConfigurationInner> call(ServiceResponse<Page<FrontendIPConfigurationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FrontendIPConfigurationInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<FrontendIPConfigurationInner>>, Observable<ServiceResponse<Page<FrontendIPConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<FrontendIPConfigurationInner>>> call(ServiceResponse<Page<FrontendIPConfigurationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LoadBalancerFrontendIPConfigurationsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FrontendIPConfigurationInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FrontendIPConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<FrontendIPConfigurationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LoadBalancerFrontendIPConfigurationsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FrontendIPConfigurationInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<FrontendIPConfigurationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface LoadBalancerFrontendIPConfigurationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.LoadBalancerFrontendIPConfigurations list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/frontendIPConfigurations")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.LoadBalancerFrontendIPConfigurations get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/frontendIPConfigurations/{frontendIPConfigurationName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="frontendIPConfigurationName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.LoadBalancerFrontendIPConfigurations listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

