/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.LongRunningFinalState;
import com.microsoft.azure.LongRunningOperationOptions;
import com.microsoft.azure.management.network.ErrorResponseException;
import com.microsoft.azure.management.network.implementation.ConnectionMonitorInner;
import com.microsoft.azure.management.network.implementation.ConnectionMonitorQueryResultInner;
import com.microsoft.azure.management.network.implementation.ConnectionMonitorResultInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl1;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ConnectionMonitorsInner {
    private ConnectionMonitorsService service;
    private NetworkManagementClientImpl client;

    public ConnectionMonitorsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (ConnectionMonitorsService)retrofit.create(ConnectionMonitorsService.class);
        this.client = client;
    }

    public ConnectionMonitorResultInner createOrUpdate(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ConnectionMonitorInner parameters) {
        return (ConnectionMonitorResultInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<ConnectionMonitorResultInner> createOrUpdateAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ConnectionMonitorInner parameters, ServiceCallback<ConnectionMonitorResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName, parameters), serviceCallback);
    }

    public Observable<ConnectionMonitorResultInner> createOrUpdateAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ConnectionMonitorInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName, parameters).map((Func1)new Func1<ServiceResponse<ConnectionMonitorResultInner>, ConnectionMonitorResultInner>(){

            public ConnectionMonitorResultInner call(ServiceResponse<ConnectionMonitorResultInner> response) {
                return (ConnectionMonitorResultInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ConnectionMonitorResultInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ConnectionMonitorInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (connectionMonitorName == null) {
            throw new IllegalArgumentException("Parameter connectionMonitorName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, networkWatcherName, connectionMonitorName, this.client.subscriptionId(), parameters, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ConnectionMonitorResultInner>(){}.getType());
    }

    public ConnectionMonitorResultInner beginCreateOrUpdate(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ConnectionMonitorInner parameters) {
        return (ConnectionMonitorResultInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ConnectionMonitorResultInner> beginCreateOrUpdateAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ConnectionMonitorInner parameters, ServiceCallback<ConnectionMonitorResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName, parameters), serviceCallback);
    }

    public Observable<ConnectionMonitorResultInner> beginCreateOrUpdateAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ConnectionMonitorInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName, parameters).map((Func1)new Func1<ServiceResponse<ConnectionMonitorResultInner>, ConnectionMonitorResultInner>(){

            public ConnectionMonitorResultInner call(ServiceResponse<ConnectionMonitorResultInner> response) {
                return (ConnectionMonitorResultInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ConnectionMonitorResultInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ConnectionMonitorInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (connectionMonitorName == null) {
            throw new IllegalArgumentException("Parameter connectionMonitorName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2019-06-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, networkWatcherName, connectionMonitorName, this.client.subscriptionId(), parameters, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ConnectionMonitorResultInner>>>(){

            public Observable<ServiceResponse<ConnectionMonitorResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ConnectionMonitorsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ConnectionMonitorResultInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ConnectionMonitorResultInner>(){}.getType()).register(201, new TypeToken<ConnectionMonitorResultInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public ConnectionMonitorResultInner get(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        return (ConnectionMonitorResultInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName).toBlocking().single()).body());
    }

    public ServiceFuture<ConnectionMonitorResultInner> getAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ServiceCallback<ConnectionMonitorResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName), serviceCallback);
    }

    public Observable<ConnectionMonitorResultInner> getAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        return this.getWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName).map((Func1)new Func1<ServiceResponse<ConnectionMonitorResultInner>, ConnectionMonitorResultInner>(){

            public ConnectionMonitorResultInner call(ServiceResponse<ConnectionMonitorResultInner> response) {
                return (ConnectionMonitorResultInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ConnectionMonitorResultInner>> getWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (connectionMonitorName == null) {
            throw new IllegalArgumentException("Parameter connectionMonitorName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.get(resourceGroupName, networkWatcherName, connectionMonitorName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ConnectionMonitorResultInner>>>(){

            public Observable<ServiceResponse<ConnectionMonitorResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ConnectionMonitorsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ConnectionMonitorResultInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ConnectionMonitorResultInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void delete(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (connectionMonitorName == null) {
            throw new IllegalArgumentException("Parameter connectionMonitorName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, networkWatcherName, connectionMonitorName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (connectionMonitorName == null) {
            throw new IllegalArgumentException("Parameter connectionMonitorName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.beginDelete(resourceGroupName, networkWatcherName, connectionMonitorName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ConnectionMonitorsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void stop(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        ((ServiceResponse)this.stopWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> stopAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.stopWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName), serviceCallback);
    }

    public Observable<Void> stopAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        return this.stopWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> stopWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (connectionMonitorName == null) {
            throw new IllegalArgumentException("Parameter connectionMonitorName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.stop(resourceGroupName, networkWatcherName, connectionMonitorName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<Void>(){}.getType());
    }

    public void beginStop(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        ((ServiceResponse)this.beginStopWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginStopAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginStopWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName), serviceCallback);
    }

    public Observable<Void> beginStopAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        return this.beginStopWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginStopWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (connectionMonitorName == null) {
            throw new IllegalArgumentException("Parameter connectionMonitorName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.beginStop(resourceGroupName, networkWatcherName, connectionMonitorName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ConnectionMonitorsInner.this.beginStopDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginStopDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void start(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        ((ServiceResponse)this.startWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> startAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.startWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName), serviceCallback);
    }

    public Observable<Void> startAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        return this.startWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> startWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (connectionMonitorName == null) {
            throw new IllegalArgumentException("Parameter connectionMonitorName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.start(resourceGroupName, networkWatcherName, connectionMonitorName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<Void>(){}.getType());
    }

    public void beginStart(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        ((ServiceResponse)this.beginStartWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginStartAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginStartWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName), serviceCallback);
    }

    public Observable<Void> beginStartAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        return this.beginStartWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginStartWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (connectionMonitorName == null) {
            throw new IllegalArgumentException("Parameter connectionMonitorName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.beginStart(resourceGroupName, networkWatcherName, connectionMonitorName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ConnectionMonitorsInner.this.beginStartDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginStartDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public ConnectionMonitorQueryResultInner query(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        return (ConnectionMonitorQueryResultInner)((ServiceResponse)this.queryWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName).toBlocking().last()).body();
    }

    public ServiceFuture<ConnectionMonitorQueryResultInner> queryAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ServiceCallback<ConnectionMonitorQueryResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.queryWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName), serviceCallback);
    }

    public Observable<ConnectionMonitorQueryResultInner> queryAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        return this.queryWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName).map((Func1)new Func1<ServiceResponse<ConnectionMonitorQueryResultInner>, ConnectionMonitorQueryResultInner>(){

            public ConnectionMonitorQueryResultInner call(ServiceResponse<ConnectionMonitorQueryResultInner> response) {
                return (ConnectionMonitorQueryResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ConnectionMonitorQueryResultInner>> queryWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (connectionMonitorName == null) {
            throw new IllegalArgumentException("Parameter connectionMonitorName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.query(resourceGroupName, networkWatcherName, connectionMonitorName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<ConnectionMonitorQueryResultInner>(){}.getType());
    }

    public ConnectionMonitorQueryResultInner beginQuery(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        return (ConnectionMonitorQueryResultInner)((ServiceResponse)this.beginQueryWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName).toBlocking().single()).body();
    }

    public ServiceFuture<ConnectionMonitorQueryResultInner> beginQueryAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ServiceCallback<ConnectionMonitorQueryResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginQueryWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName), serviceCallback);
    }

    public Observable<ConnectionMonitorQueryResultInner> beginQueryAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        return this.beginQueryWithServiceResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName).map((Func1)new Func1<ServiceResponse<ConnectionMonitorQueryResultInner>, ConnectionMonitorQueryResultInner>(){

            public ConnectionMonitorQueryResultInner call(ServiceResponse<ConnectionMonitorQueryResultInner> response) {
                return (ConnectionMonitorQueryResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ConnectionMonitorQueryResultInner>> beginQueryWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (connectionMonitorName == null) {
            throw new IllegalArgumentException("Parameter connectionMonitorName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.beginQuery(resourceGroupName, networkWatcherName, connectionMonitorName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ConnectionMonitorQueryResultInner>>>(){

            public Observable<ServiceResponse<ConnectionMonitorQueryResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ConnectionMonitorsInner.this.beginQueryDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ConnectionMonitorQueryResultInner> beginQueryDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ConnectionMonitorQueryResultInner>(){}.getType()).register(202, new TypeToken<ConnectionMonitorQueryResultInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public List<ConnectionMonitorResultInner> list(String resourceGroupName, String networkWatcherName) {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync(resourceGroupName, networkWatcherName).toBlocking().single()).body();
    }

    public ServiceFuture<List<ConnectionMonitorResultInner>> listAsync(String resourceGroupName, String networkWatcherName, ServiceCallback<List<ConnectionMonitorResultInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceGroupName, networkWatcherName), serviceCallback);
    }

    public Observable<List<ConnectionMonitorResultInner>> listAsync(String resourceGroupName, String networkWatcherName) {
        return this.listWithServiceResponseAsync(resourceGroupName, networkWatcherName).map((Func1)new Func1<ServiceResponse<List<ConnectionMonitorResultInner>>, List<ConnectionMonitorResultInner>>(){

            public List<ConnectionMonitorResultInner> call(ServiceResponse<List<ConnectionMonitorResultInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<ConnectionMonitorResultInner>>> listWithServiceResponseAsync(String resourceGroupName, String networkWatcherName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.list(resourceGroupName, networkWatcherName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ConnectionMonitorResultInner>>>>(){

            public Observable<ServiceResponse<List<ConnectionMonitorResultInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ConnectionMonitorsInner.this.listDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ConnectionMonitorResultInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ConnectionMonitorResultInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface ConnectionMonitorsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ConnectionMonitors createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="connectionMonitorName") String var3, @Path(value="subscriptionId") String var4, @Body ConnectionMonitorInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ConnectionMonitors beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="connectionMonitorName") String var3, @Path(value="subscriptionId") String var4, @Body ConnectionMonitorInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ConnectionMonitors get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="connectionMonitorName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ConnectionMonitors delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="connectionMonitorName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ConnectionMonitors beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="connectionMonitorName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ConnectionMonitors stop"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}/stop")
        public Observable<Response<ResponseBody>> stop(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="connectionMonitorName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ConnectionMonitors beginStop"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}/stop")
        public Observable<Response<ResponseBody>> beginStop(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="connectionMonitorName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ConnectionMonitors start"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}/start")
        public Observable<Response<ResponseBody>> start(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="connectionMonitorName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ConnectionMonitors beginStart"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}/start")
        public Observable<Response<ResponseBody>> beginStart(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="connectionMonitorName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ConnectionMonitors query"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}/query")
        public Observable<Response<ResponseBody>> query(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="connectionMonitorName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ConnectionMonitors beginQuery"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}/query")
        public Observable<Response<ResponseBody>> beginQuery(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="connectionMonitorName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ConnectionMonitors list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);
    }
}

