/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ApplicationGateway;
import com.microsoft.azure.management.network.ApplicationGatewayFrontend;
import com.microsoft.azure.management.network.ApplicationGatewayHttpListener;
import com.microsoft.azure.management.network.ApplicationGatewayListener;
import com.microsoft.azure.management.network.ApplicationGatewayProtocol;
import com.microsoft.azure.management.network.ApplicationGatewaySslCertificate;
import com.microsoft.azure.management.network.PublicIPAddress;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewaySslCertificateImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import java.io.File;
import java.io.IOException;

@LangDefinition
class ApplicationGatewayListenerImpl
extends ChildResourceImpl<ApplicationGatewayHttpListener, ApplicationGatewayImpl, ApplicationGateway>
implements ApplicationGatewayListener,
ApplicationGatewayListener.Definition<ApplicationGateway.DefinitionStages.WithCreate>,
ApplicationGatewayListener.UpdateDefinition<ApplicationGateway.Update>,
ApplicationGatewayListener.Update {
    ApplicationGatewayListenerImpl(ApplicationGatewayHttpListener inner, ApplicationGatewayImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public String networkId() {
        ApplicationGatewayFrontend frontend = this.frontend();
        if (frontend != null) {
            return frontend.networkId();
        }
        return null;
    }

    public String subnetName() {
        ApplicationGatewayFrontend frontend = this.frontend();
        if (frontend != null) {
            return frontend.subnetName();
        }
        return null;
    }

    @Override
    public boolean requiresServerNameIndication() {
        if (((ApplicationGatewayHttpListener)((Object)this.inner())).requireServerNameIndication() != null) {
            return ((ApplicationGatewayHttpListener)((Object)this.inner())).requireServerNameIndication();
        }
        return false;
    }

    @Override
    public String hostName() {
        return ((ApplicationGatewayHttpListener)((Object)this.inner())).hostName();
    }

    @Override
    public String publicIPAddressId() {
        ApplicationGatewayFrontend frontend = this.frontend();
        if (frontend == null) {
            return null;
        }
        return frontend.publicIPAddressId();
    }

    @Override
    public PublicIPAddress getPublicIPAddress() {
        String pipId = this.publicIPAddressId();
        if (pipId == null) {
            return null;
        }
        return (PublicIPAddress)((NetworkManager)((ApplicationGatewayImpl)this.parent()).manager()).publicIPAddresses().getById(pipId);
    }

    public String name() {
        return ((ApplicationGatewayHttpListener)((Object)this.inner())).name();
    }

    @Override
    public ApplicationGatewaySslCertificate sslCertificate() {
        SubResource certRef = ((ApplicationGatewayHttpListener)((Object)this.inner())).sslCertificate();
        if (certRef == null) {
            return null;
        }
        String name = ResourceUtils.nameFromResourceId((String)certRef.id());
        return ((ApplicationGatewayImpl)this.parent()).sslCertificates().get(name);
    }

    @Override
    public ApplicationGatewayProtocol protocol() {
        return ((ApplicationGatewayHttpListener)((Object)this.inner())).protocol();
    }

    @Override
    public int frontendPortNumber() {
        String name = this.frontendPortName();
        if (name == null) {
            return 0;
        }
        if (!((ApplicationGatewayImpl)this.parent()).frontendPorts().containsKey(name)) {
            return 0;
        }
        return ((ApplicationGatewayImpl)this.parent()).frontendPorts().get(name);
    }

    @Override
    public String frontendPortName() {
        if (((ApplicationGatewayHttpListener)((Object)this.inner())).frontendPort() != null) {
            return ResourceUtils.nameFromResourceId((String)((ApplicationGatewayHttpListener)((Object)this.inner())).frontendPort().id());
        }
        return null;
    }

    @Override
    public ApplicationGatewayFrontend frontend() {
        SubResource frontendInner = ((ApplicationGatewayHttpListener)((Object)this.inner())).frontendIPConfiguration();
        if (frontendInner == null) {
            return null;
        }
        String frontendName = ResourceUtils.nameFromResourceId((String)frontendInner.id());
        return ((ApplicationGatewayImpl)this.parent()).frontends().get(frontendName);
    }

    public ApplicationGatewayImpl attach() {
        ((ApplicationGatewayImpl)this.parent()).withHttpListener(this);
        return (ApplicationGatewayImpl)this.parent();
    }

    private ApplicationGatewayListenerImpl withFrontend(String name) {
        SubResource frontendRef = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/frontendIPConfigurations/" + name);
        ((ApplicationGatewayHttpListener)((Object)this.inner())).withFrontendIPConfiguration(frontendRef);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withFrontendPort(String name) {
        SubResource portRef = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/frontendPorts/" + name);
        ((ApplicationGatewayHttpListener)((Object)this.inner())).withFrontendPort(portRef);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withFrontendPort(int portNumber) {
        String portName = ((ApplicationGatewayImpl)this.parent()).frontendPortNameFromNumber(portNumber);
        if (portName == null) {
            portName = SdkContext.randomResourceName((String)"port", (int)9);
            ((ApplicationGatewayImpl)this.parent()).withFrontendPort(portNumber, portName);
        }
        return this.withFrontendPort(portName);
    }

    @Override
    public ApplicationGatewayListenerImpl withSslCertificate(String name) {
        SubResource certRef = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/sslCertificates/" + name);
        ((ApplicationGatewayHttpListener)((Object)this.inner())).withSslCertificate(certRef);
        return this;
    }

    public ApplicationGatewayListenerImpl withSslCertificateFromPfxFile(File pfxFile) throws IOException {
        return this.withSslCertificateFromPfxFile(pfxFile, null);
    }

    private ApplicationGatewayListenerImpl withSslCertificateFromPfxFile(File pfxFile, String name) throws IOException {
        if (name == null) {
            name = SdkContext.randomResourceName((String)"cert", (int)10);
        }
        ((ApplicationGatewayImpl)this.parent()).defineSslCertificate(name).withPfxFromFile(pfxFile).attach();
        return this.withSslCertificate(name);
    }

    @Override
    public ApplicationGatewayListenerImpl withSslCertificatePassword(String password) {
        ApplicationGatewaySslCertificateImpl sslCert = (ApplicationGatewaySslCertificateImpl)this.sslCertificate();
        if (sslCert != null) {
            sslCert.withPfxPassword(password);
        }
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withHttp() {
        ((ApplicationGatewayHttpListener)((Object)this.inner())).withProtocol(ApplicationGatewayProtocol.HTTP);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withHttps() {
        ((ApplicationGatewayHttpListener)((Object)this.inner())).withProtocol(ApplicationGatewayProtocol.HTTPS);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withHostName(String hostname) {
        ((ApplicationGatewayHttpListener)((Object)this.inner())).withHostName(hostname);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withServerNameIndication() {
        ((ApplicationGatewayHttpListener)((Object)this.inner())).withRequireServerNameIndication(true);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withoutServerNameIndication() {
        ((ApplicationGatewayHttpListener)((Object)this.inner())).withRequireServerNameIndication(false);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withPrivateFrontend() {
        this.withFrontend(((ApplicationGatewayImpl)this.parent()).ensureDefaultPrivateFrontend().name());
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withPublicFrontend() {
        this.withFrontend(((ApplicationGatewayImpl)this.parent()).ensureDefaultPublicFrontend().name());
        return this;
    }
}

