/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import java.util.List;
import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.network.OfficeTrafficCategory;
import com.microsoft.azure.management.network.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.rest.SkipParentValidation;
import com.microsoft.azure.Resource;

/**
 * VirtualWAN Resource.
 */
@JsonFlatten
@SkipParentValidation
public class VirtualWANInner extends Resource {
    /**
     * Vpn encryption to be disabled or not.
     */
    @JsonProperty(value = "properties.disableVpnEncryption")
    private Boolean disableVpnEncryption;

    /**
     * List of VirtualHubs in the VirtualWAN.
     */
    @JsonProperty(value = "properties.virtualHubs", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> virtualHubs;

    /**
     * List of VpnSites in the VirtualWAN.
     */
    @JsonProperty(value = "properties.vpnSites", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> vpnSites;

    /**
     * The Security Provider name.
     */
    @JsonProperty(value = "properties.securityProviderName")
    private String securityProviderName;

    /**
     * True if branch to branch traffic is allowed.
     */
    @JsonProperty(value = "properties.allowBranchToBranchTraffic")
    private Boolean allowBranchToBranchTraffic;

    /**
     * True if Vnet to Vnet traffic is allowed.
     */
    @JsonProperty(value = "properties.allowVnetToVnetTraffic")
    private Boolean allowVnetToVnetTraffic;

    /**
     * The office local breakout category. Possible values include: 'Optimize',
     * 'OptimizeAndAllow', 'All', 'None'.
     */
    @JsonProperty(value = "properties.office365LocalBreakoutCategory")
    private OfficeTrafficCategory office365LocalBreakoutCategory;

    /**
     * List of all P2SVpnServerConfigurations associated with the virtual wan.
     */
    @JsonProperty(value = "properties.p2SVpnServerConfigurations")
    private List<P2SVpnServerConfigurationInner> p2SVpnServerConfigurations;

    /**
     * The provisioning state of the resource. Possible values include:
     * 'Succeeded', 'Updating', 'Deleting', 'Failed'.
     */
    @JsonProperty(value = "properties.provisioningState")
    private ProvisioningState provisioningState;

    /**
     * Gets a unique read-only string that changes whenever the resource is
     * updated.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /**
     * Resource ID.
     */
    @JsonProperty(value = "id")
    private String id;

    /**
     * Get vpn encryption to be disabled or not.
     *
     * @return the disableVpnEncryption value
     */
    public Boolean disableVpnEncryption() {
        return this.disableVpnEncryption;
    }

    /**
     * Set vpn encryption to be disabled or not.
     *
     * @param disableVpnEncryption the disableVpnEncryption value to set
     * @return the VirtualWANInner object itself.
     */
    public VirtualWANInner withDisableVpnEncryption(Boolean disableVpnEncryption) {
        this.disableVpnEncryption = disableVpnEncryption;
        return this;
    }

    /**
     * Get list of VirtualHubs in the VirtualWAN.
     *
     * @return the virtualHubs value
     */
    public List<SubResource> virtualHubs() {
        return this.virtualHubs;
    }

    /**
     * Get list of VpnSites in the VirtualWAN.
     *
     * @return the vpnSites value
     */
    public List<SubResource> vpnSites() {
        return this.vpnSites;
    }

    /**
     * Get the Security Provider name.
     *
     * @return the securityProviderName value
     */
    public String securityProviderName() {
        return this.securityProviderName;
    }

    /**
     * Set the Security Provider name.
     *
     * @param securityProviderName the securityProviderName value to set
     * @return the VirtualWANInner object itself.
     */
    public VirtualWANInner withSecurityProviderName(String securityProviderName) {
        this.securityProviderName = securityProviderName;
        return this;
    }

    /**
     * Get true if branch to branch traffic is allowed.
     *
     * @return the allowBranchToBranchTraffic value
     */
    public Boolean allowBranchToBranchTraffic() {
        return this.allowBranchToBranchTraffic;
    }

    /**
     * Set true if branch to branch traffic is allowed.
     *
     * @param allowBranchToBranchTraffic the allowBranchToBranchTraffic value to set
     * @return the VirtualWANInner object itself.
     */
    public VirtualWANInner withAllowBranchToBranchTraffic(Boolean allowBranchToBranchTraffic) {
        this.allowBranchToBranchTraffic = allowBranchToBranchTraffic;
        return this;
    }

    /**
     * Get true if Vnet to Vnet traffic is allowed.
     *
     * @return the allowVnetToVnetTraffic value
     */
    public Boolean allowVnetToVnetTraffic() {
        return this.allowVnetToVnetTraffic;
    }

    /**
     * Set true if Vnet to Vnet traffic is allowed.
     *
     * @param allowVnetToVnetTraffic the allowVnetToVnetTraffic value to set
     * @return the VirtualWANInner object itself.
     */
    public VirtualWANInner withAllowVnetToVnetTraffic(Boolean allowVnetToVnetTraffic) {
        this.allowVnetToVnetTraffic = allowVnetToVnetTraffic;
        return this;
    }

    /**
     * Get the office local breakout category. Possible values include: 'Optimize', 'OptimizeAndAllow', 'All', 'None'.
     *
     * @return the office365LocalBreakoutCategory value
     */
    public OfficeTrafficCategory office365LocalBreakoutCategory() {
        return this.office365LocalBreakoutCategory;
    }

    /**
     * Set the office local breakout category. Possible values include: 'Optimize', 'OptimizeAndAllow', 'All', 'None'.
     *
     * @param office365LocalBreakoutCategory the office365LocalBreakoutCategory value to set
     * @return the VirtualWANInner object itself.
     */
    public VirtualWANInner withOffice365LocalBreakoutCategory(OfficeTrafficCategory office365LocalBreakoutCategory) {
        this.office365LocalBreakoutCategory = office365LocalBreakoutCategory;
        return this;
    }

    /**
     * Get list of all P2SVpnServerConfigurations associated with the virtual wan.
     *
     * @return the p2SVpnServerConfigurations value
     */
    public List<P2SVpnServerConfigurationInner> p2SVpnServerConfigurations() {
        return this.p2SVpnServerConfigurations;
    }

    /**
     * Set list of all P2SVpnServerConfigurations associated with the virtual wan.
     *
     * @param p2SVpnServerConfigurations the p2SVpnServerConfigurations value to set
     * @return the VirtualWANInner object itself.
     */
    public VirtualWANInner withP2SVpnServerConfigurations(List<P2SVpnServerConfigurationInner> p2SVpnServerConfigurations) {
        this.p2SVpnServerConfigurations = p2SVpnServerConfigurations;
        return this;
    }

    /**
     * Get the provisioning state of the resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'.
     *
     * @return the provisioningState value
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set the provisioning state of the resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'.
     *
     * @param provisioningState the provisioningState value to set
     * @return the VirtualWANInner object itself.
     */
    public VirtualWANInner withProvisioningState(ProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Get gets a unique read-only string that changes whenever the resource is updated.
     *
     * @return the etag value
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get resource ID.
     *
     * @return the id value
     */
    public String id() {
        return this.id;
    }

    /**
     * Set resource ID.
     *
     * @param id the id value to set
     * @return the VirtualWANInner object itself.
     */
    public VirtualWANInner withId(String id) {
        this.id = id;
        return this;
    }

}
