/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in ServiceEndpointPolicies.
 */
public class ServiceEndpointPoliciesInner implements InnerSupportsGet<ServiceEndpointPolicyInner>, InnerSupportsDelete<Void>, InnerSupportsListing<ServiceEndpointPolicyInner> {
    /** The Retrofit service to perform REST calls. */
    private ServiceEndpointPoliciesService service;
    /** The service client containing this operation class. */
    private NetworkManagementClientImpl client;

    /**
     * Initializes an instance of ServiceEndpointPoliciesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ServiceEndpointPoliciesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = retrofit.create(ServiceEndpointPoliciesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for ServiceEndpointPolicies to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ServiceEndpointPoliciesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicies delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("serviceEndpointPolicyName") String serviceEndpointPolicyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicies beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("serviceEndpointPolicyName") String serviceEndpointPolicyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicies getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("serviceEndpointPolicyName") String serviceEndpointPolicyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Query("$expand") String expand, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicies createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("serviceEndpointPolicyName") String serviceEndpointPolicyName, @Path("subscriptionId") String subscriptionId, @Body ServiceEndpointPolicyInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicies beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("serviceEndpointPolicyName") String serviceEndpointPolicyName, @Path("subscriptionId") String subscriptionId, @Body ServiceEndpointPolicyInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicies update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("serviceEndpointPolicyName") String serviceEndpointPolicyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body TagsObject parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicies beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("serviceEndpointPolicyName") String serviceEndpointPolicyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body TagsObject parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicies list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Network/ServiceEndpointPolicies")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicies listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicies listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicies listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Deletes the specified service endpoint policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String serviceEndpointPolicyName) {
        deleteWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName).toBlocking().last().body();
    }

    /**
     * Deletes the specified service endpoint policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serviceEndpointPolicyName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName), serviceCallback);
    }

    /**
     * Deletes the specified service endpoint policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String serviceEndpointPolicyName) {
        return deleteWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified service endpoint policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, serviceEndpointPolicyName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes the specified service endpoint policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String serviceEndpointPolicyName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName).toBlocking().single().body();
    }

    /**
     * Deletes the specified service endpoint policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String serviceEndpointPolicyName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName), serviceCallback);
    }

    /**
     * Deletes the specified service endpoint policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String serviceEndpointPolicyName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified service endpoint policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        return service.beginDelete(resourceGroupName, serviceEndpointPolicyName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the specified service Endpoint Policies in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ServiceEndpointPolicyInner object if successful.
     */
    public ServiceEndpointPolicyInner getByResourceGroup(String resourceGroupName, String serviceEndpointPolicyName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName).toBlocking().single().body();
    }

    /**
     * Gets the specified service Endpoint Policies in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ServiceEndpointPolicyInner> getByResourceGroupAsync(String resourceGroupName, String serviceEndpointPolicyName, final ServiceCallback<ServiceEndpointPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName), serviceCallback);
    }

    /**
     * Gets the specified service Endpoint Policies in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServiceEndpointPolicyInner object
     */
    public Observable<ServiceEndpointPolicyInner> getByResourceGroupAsync(String resourceGroupName, String serviceEndpointPolicyName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName).map(new Func1<ServiceResponse<ServiceEndpointPolicyInner>, ServiceEndpointPolicyInner>() {
            @Override
            public ServiceEndpointPolicyInner call(ServiceResponse<ServiceEndpointPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the specified service Endpoint Policies in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServiceEndpointPolicyInner object
     */
    public Observable<ServiceResponse<ServiceEndpointPolicyInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        final String expand = null;
        return service.getByResourceGroup(resourceGroupName, serviceEndpointPolicyName, this.client.subscriptionId(), apiVersion, expand, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServiceEndpointPolicyInner>>>() {
                @Override
                public Observable<ServiceResponse<ServiceEndpointPolicyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ServiceEndpointPolicyInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets the specified service Endpoint Policies in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param expand Expands referenced resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ServiceEndpointPolicyInner object if successful.
     */
    public ServiceEndpointPolicyInner getByResourceGroup(String resourceGroupName, String serviceEndpointPolicyName, String expand) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, expand).toBlocking().single().body();
    }

    /**
     * Gets the specified service Endpoint Policies in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param expand Expands referenced resources.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ServiceEndpointPolicyInner> getByResourceGroupAsync(String resourceGroupName, String serviceEndpointPolicyName, String expand, final ServiceCallback<ServiceEndpointPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, expand), serviceCallback);
    }

    /**
     * Gets the specified service Endpoint Policies in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param expand Expands referenced resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServiceEndpointPolicyInner object
     */
    public Observable<ServiceEndpointPolicyInner> getByResourceGroupAsync(String resourceGroupName, String serviceEndpointPolicyName, String expand) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, expand).map(new Func1<ServiceResponse<ServiceEndpointPolicyInner>, ServiceEndpointPolicyInner>() {
            @Override
            public ServiceEndpointPolicyInner call(ServiceResponse<ServiceEndpointPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the specified service Endpoint Policies in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param expand Expands referenced resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServiceEndpointPolicyInner object
     */
    public Observable<ServiceResponse<ServiceEndpointPolicyInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        return service.getByResourceGroup(resourceGroupName, serviceEndpointPolicyName, this.client.subscriptionId(), apiVersion, expand, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServiceEndpointPolicyInner>>>() {
                @Override
                public Observable<ServiceResponse<ServiceEndpointPolicyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ServiceEndpointPolicyInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ServiceEndpointPolicyInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ServiceEndpointPolicyInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ServiceEndpointPolicyInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates a service Endpoint Policies.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param parameters Parameters supplied to the create or update service endpoint policy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ServiceEndpointPolicyInner object if successful.
     */
    public ServiceEndpointPolicyInner createOrUpdate(String resourceGroupName, String serviceEndpointPolicyName, ServiceEndpointPolicyInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, parameters).toBlocking().last().body();
    }

    /**
     * Creates or updates a service Endpoint Policies.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param parameters Parameters supplied to the create or update service endpoint policy operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ServiceEndpointPolicyInner> createOrUpdateAsync(String resourceGroupName, String serviceEndpointPolicyName, ServiceEndpointPolicyInner parameters, final ServiceCallback<ServiceEndpointPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, parameters), serviceCallback);
    }

    /**
     * Creates or updates a service Endpoint Policies.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param parameters Parameters supplied to the create or update service endpoint policy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceEndpointPolicyInner> createOrUpdateAsync(String resourceGroupName, String serviceEndpointPolicyName, ServiceEndpointPolicyInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, parameters).map(new Func1<ServiceResponse<ServiceEndpointPolicyInner>, ServiceEndpointPolicyInner>() {
            @Override
            public ServiceEndpointPolicyInner call(ServiceResponse<ServiceEndpointPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a service Endpoint Policies.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param parameters Parameters supplied to the create or update service endpoint policy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<ServiceEndpointPolicyInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName, ServiceEndpointPolicyInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, serviceEndpointPolicyName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ServiceEndpointPolicyInner>() { }.getType());
    }

    /**
     * Creates or updates a service Endpoint Policies.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param parameters Parameters supplied to the create or update service endpoint policy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ServiceEndpointPolicyInner object if successful.
     */
    public ServiceEndpointPolicyInner beginCreateOrUpdate(String resourceGroupName, String serviceEndpointPolicyName, ServiceEndpointPolicyInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates a service Endpoint Policies.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param parameters Parameters supplied to the create or update service endpoint policy operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ServiceEndpointPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceEndpointPolicyName, ServiceEndpointPolicyInner parameters, final ServiceCallback<ServiceEndpointPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, parameters), serviceCallback);
    }

    /**
     * Creates or updates a service Endpoint Policies.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param parameters Parameters supplied to the create or update service endpoint policy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServiceEndpointPolicyInner object
     */
    public Observable<ServiceEndpointPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceEndpointPolicyName, ServiceEndpointPolicyInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, parameters).map(new Func1<ServiceResponse<ServiceEndpointPolicyInner>, ServiceEndpointPolicyInner>() {
            @Override
            public ServiceEndpointPolicyInner call(ServiceResponse<ServiceEndpointPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a service Endpoint Policies.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param parameters Parameters supplied to the create or update service endpoint policy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServiceEndpointPolicyInner object
     */
    public Observable<ServiceResponse<ServiceEndpointPolicyInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName, ServiceEndpointPolicyInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2019-06-01";
        return service.beginCreateOrUpdate(resourceGroupName, serviceEndpointPolicyName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServiceEndpointPolicyInner>>>() {
                @Override
                public Observable<ServiceResponse<ServiceEndpointPolicyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ServiceEndpointPolicyInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ServiceEndpointPolicyInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ServiceEndpointPolicyInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ServiceEndpointPolicyInner>() { }.getType())
                .register(201, new TypeToken<ServiceEndpointPolicyInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates service Endpoint Policies.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ServiceEndpointPolicyInner object if successful.
     */
    public ServiceEndpointPolicyInner update(String resourceGroupName, String serviceEndpointPolicyName) {
        return updateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName).toBlocking().last().body();
    }

    /**
     * Updates service Endpoint Policies.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ServiceEndpointPolicyInner> updateAsync(String resourceGroupName, String serviceEndpointPolicyName, final ServiceCallback<ServiceEndpointPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName), serviceCallback);
    }

    /**
     * Updates service Endpoint Policies.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceEndpointPolicyInner> updateAsync(String resourceGroupName, String serviceEndpointPolicyName) {
        return updateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName).map(new Func1<ServiceResponse<ServiceEndpointPolicyInner>, ServiceEndpointPolicyInner>() {
            @Override
            public ServiceEndpointPolicyInner call(ServiceResponse<ServiceEndpointPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates service Endpoint Policies.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<ServiceEndpointPolicyInner>> updateWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        final Map<String, String> tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        Observable<Response<ResponseBody>> observable = service.update(resourceGroupName, serviceEndpointPolicyName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ServiceEndpointPolicyInner>() { }.getType());
    }
    /**
     * Updates service Endpoint Policies.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ServiceEndpointPolicyInner object if successful.
     */
    public ServiceEndpointPolicyInner update(String resourceGroupName, String serviceEndpointPolicyName, Map<String, String> tags) {
        return updateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, tags).toBlocking().last().body();
    }

    /**
     * Updates service Endpoint Policies.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param tags Resource tags.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ServiceEndpointPolicyInner> updateAsync(String resourceGroupName, String serviceEndpointPolicyName, Map<String, String> tags, final ServiceCallback<ServiceEndpointPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, tags), serviceCallback);
    }

    /**
     * Updates service Endpoint Policies.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceEndpointPolicyInner> updateAsync(String resourceGroupName, String serviceEndpointPolicyName, Map<String, String> tags) {
        return updateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, tags).map(new Func1<ServiceResponse<ServiceEndpointPolicyInner>, ServiceEndpointPolicyInner>() {
            @Override
            public ServiceEndpointPolicyInner call(ServiceResponse<ServiceEndpointPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates service Endpoint Policies.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<ServiceEndpointPolicyInner>> updateWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        final String apiVersion = "2019-06-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = service.update(resourceGroupName, serviceEndpointPolicyName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ServiceEndpointPolicyInner>() { }.getType());
    }

    /**
     * Updates service Endpoint Policies.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ServiceEndpointPolicyInner object if successful.
     */
    public ServiceEndpointPolicyInner beginUpdate(String resourceGroupName, String serviceEndpointPolicyName) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName).toBlocking().single().body();
    }

    /**
     * Updates service Endpoint Policies.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ServiceEndpointPolicyInner> beginUpdateAsync(String resourceGroupName, String serviceEndpointPolicyName, final ServiceCallback<ServiceEndpointPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName), serviceCallback);
    }

    /**
     * Updates service Endpoint Policies.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServiceEndpointPolicyInner object
     */
    public Observable<ServiceEndpointPolicyInner> beginUpdateAsync(String resourceGroupName, String serviceEndpointPolicyName) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName).map(new Func1<ServiceResponse<ServiceEndpointPolicyInner>, ServiceEndpointPolicyInner>() {
            @Override
            public ServiceEndpointPolicyInner call(ServiceResponse<ServiceEndpointPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates service Endpoint Policies.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServiceEndpointPolicyInner object
     */
    public Observable<ServiceResponse<ServiceEndpointPolicyInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        final Map<String, String> tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        return service.beginUpdate(resourceGroupName, serviceEndpointPolicyName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServiceEndpointPolicyInner>>>() {
                @Override
                public Observable<ServiceResponse<ServiceEndpointPolicyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ServiceEndpointPolicyInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Updates service Endpoint Policies.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ServiceEndpointPolicyInner object if successful.
     */
    public ServiceEndpointPolicyInner beginUpdate(String resourceGroupName, String serviceEndpointPolicyName, Map<String, String> tags) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, tags).toBlocking().single().body();
    }

    /**
     * Updates service Endpoint Policies.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param tags Resource tags.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ServiceEndpointPolicyInner> beginUpdateAsync(String resourceGroupName, String serviceEndpointPolicyName, Map<String, String> tags, final ServiceCallback<ServiceEndpointPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, tags), serviceCallback);
    }

    /**
     * Updates service Endpoint Policies.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServiceEndpointPolicyInner object
     */
    public Observable<ServiceEndpointPolicyInner> beginUpdateAsync(String resourceGroupName, String serviceEndpointPolicyName, Map<String, String> tags) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, tags).map(new Func1<ServiceResponse<ServiceEndpointPolicyInner>, ServiceEndpointPolicyInner>() {
            @Override
            public ServiceEndpointPolicyInner call(ServiceResponse<ServiceEndpointPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates service Endpoint Policies.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServiceEndpointPolicyInner object
     */
    public Observable<ServiceResponse<ServiceEndpointPolicyInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        final String apiVersion = "2019-06-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        return service.beginUpdate(resourceGroupName, serviceEndpointPolicyName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServiceEndpointPolicyInner>>>() {
                @Override
                public Observable<ServiceResponse<ServiceEndpointPolicyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ServiceEndpointPolicyInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ServiceEndpointPolicyInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ServiceEndpointPolicyInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ServiceEndpointPolicyInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all the service endpoint policies in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ServiceEndpointPolicyInner&gt; object if successful.
     */
    public PagedList<ServiceEndpointPolicyInner> list() {
        ServiceResponse<Page<ServiceEndpointPolicyInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<ServiceEndpointPolicyInner>(response.body()) {
            @Override
            public Page<ServiceEndpointPolicyInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the service endpoint policies in a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ServiceEndpointPolicyInner>> listAsync(final ListOperationCallback<ServiceEndpointPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the service endpoint policies in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ServiceEndpointPolicyInner&gt; object
     */
    public Observable<Page<ServiceEndpointPolicyInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<ServiceEndpointPolicyInner>>, Page<ServiceEndpointPolicyInner>>() {
                @Override
                public Page<ServiceEndpointPolicyInner> call(ServiceResponse<Page<ServiceEndpointPolicyInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the service endpoint policies in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ServiceEndpointPolicyInner&gt; object
     */
    public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<ServiceEndpointPolicyInner>>, Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> call(ServiceResponse<Page<ServiceEndpointPolicyInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the service endpoint policies in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ServiceEndpointPolicyInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ServiceEndpointPolicyInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ServiceEndpointPolicyInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ServiceEndpointPolicyInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ServiceEndpointPolicyInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ServiceEndpointPolicyInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all service endpoint Policies in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ServiceEndpointPolicyInner&gt; object if successful.
     */
    public PagedList<ServiceEndpointPolicyInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<ServiceEndpointPolicyInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<ServiceEndpointPolicyInner>(response.body()) {
            @Override
            public Page<ServiceEndpointPolicyInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all service endpoint Policies in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ServiceEndpointPolicyInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<ServiceEndpointPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all service endpoint Policies in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ServiceEndpointPolicyInner&gt; object
     */
    public Observable<Page<ServiceEndpointPolicyInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<ServiceEndpointPolicyInner>>, Page<ServiceEndpointPolicyInner>>() {
                @Override
                public Page<ServiceEndpointPolicyInner> call(ServiceResponse<Page<ServiceEndpointPolicyInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all service endpoint Policies in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ServiceEndpointPolicyInner&gt; object
     */
    public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<ServiceEndpointPolicyInner>>, Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> call(ServiceResponse<Page<ServiceEndpointPolicyInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all service endpoint Policies in a resource group.
     *
    ServiceResponse<PageImpl<ServiceEndpointPolicyInner>> * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ServiceEndpointPolicyInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ServiceEndpointPolicyInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ServiceEndpointPolicyInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ServiceEndpointPolicyInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ServiceEndpointPolicyInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ServiceEndpointPolicyInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all the service endpoint policies in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ServiceEndpointPolicyInner&gt; object if successful.
     */
    public PagedList<ServiceEndpointPolicyInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<ServiceEndpointPolicyInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ServiceEndpointPolicyInner>(response.body()) {
            @Override
            public Page<ServiceEndpointPolicyInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the service endpoint policies in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ServiceEndpointPolicyInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<ServiceEndpointPolicyInner>> serviceFuture, final ListOperationCallback<ServiceEndpointPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the service endpoint policies in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ServiceEndpointPolicyInner&gt; object
     */
    public Observable<Page<ServiceEndpointPolicyInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ServiceEndpointPolicyInner>>, Page<ServiceEndpointPolicyInner>>() {
                @Override
                public Page<ServiceEndpointPolicyInner> call(ServiceResponse<Page<ServiceEndpointPolicyInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the service endpoint policies in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ServiceEndpointPolicyInner&gt; object
     */
    public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ServiceEndpointPolicyInner>>, Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> call(ServiceResponse<Page<ServiceEndpointPolicyInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the service endpoint policies in a subscription.
     *
    ServiceResponse<PageImpl<ServiceEndpointPolicyInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ServiceEndpointPolicyInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ServiceEndpointPolicyInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ServiceEndpointPolicyInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ServiceEndpointPolicyInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ServiceEndpointPolicyInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ServiceEndpointPolicyInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all service endpoint Policies in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ServiceEndpointPolicyInner&gt; object if successful.
     */
    public PagedList<ServiceEndpointPolicyInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<ServiceEndpointPolicyInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ServiceEndpointPolicyInner>(response.body()) {
            @Override
            public Page<ServiceEndpointPolicyInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all service endpoint Policies in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ServiceEndpointPolicyInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<ServiceEndpointPolicyInner>> serviceFuture, final ListOperationCallback<ServiceEndpointPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all service endpoint Policies in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ServiceEndpointPolicyInner&gt; object
     */
    public Observable<Page<ServiceEndpointPolicyInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ServiceEndpointPolicyInner>>, Page<ServiceEndpointPolicyInner>>() {
                @Override
                public Page<ServiceEndpointPolicyInner> call(ServiceResponse<Page<ServiceEndpointPolicyInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all service endpoint Policies in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ServiceEndpointPolicyInner&gt; object
     */
    public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ServiceEndpointPolicyInner>>, Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> call(ServiceResponse<Page<ServiceEndpointPolicyInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all service endpoint Policies in a resource group.
     *
    ServiceResponse<PageImpl<ServiceEndpointPolicyInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ServiceEndpointPolicyInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ServiceEndpointPolicyInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ServiceEndpointPolicyInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ServiceEndpointPolicyInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ServiceEndpointPolicyInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ServiceEndpointPolicyInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
