/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.network.ErrorException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in P2sVpnServerConfigurations.
 */
public class P2sVpnServerConfigurationsInner {
    /** The Retrofit service to perform REST calls. */
    private P2sVpnServerConfigurationsService service;
    /** The service client containing this operation class. */
    private NetworkManagementClientImpl client;

    /**
     * Initializes an instance of P2sVpnServerConfigurationsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public P2sVpnServerConfigurationsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = retrofit.create(P2sVpnServerConfigurationsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for P2sVpnServerConfigurations to be
     * used by Retrofit to perform actually REST calls.
     */
    interface P2sVpnServerConfigurationsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnServerConfigurations get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWanName}/p2sVpnServerConfigurations/{p2SVpnServerConfigurationName}")
        Observable<Response<ResponseBody>> get(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("virtualWanName") String virtualWanName, @Path("p2SVpnServerConfigurationName") String p2SVpnServerConfigurationName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnServerConfigurations createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWanName}/p2sVpnServerConfigurations/{p2SVpnServerConfigurationName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("virtualWanName") String virtualWanName, @Path("p2SVpnServerConfigurationName") String p2SVpnServerConfigurationName, @Query("api-version") String apiVersion, @Body P2SVpnServerConfigurationInner p2SVpnServerConfigurationParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnServerConfigurations beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWanName}/p2sVpnServerConfigurations/{p2SVpnServerConfigurationName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("virtualWanName") String virtualWanName, @Path("p2SVpnServerConfigurationName") String p2SVpnServerConfigurationName, @Query("api-version") String apiVersion, @Body P2SVpnServerConfigurationInner p2SVpnServerConfigurationParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnServerConfigurations delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWanName}/p2sVpnServerConfigurations/{p2SVpnServerConfigurationName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("virtualWanName") String virtualWanName, @Path("p2SVpnServerConfigurationName") String p2SVpnServerConfigurationName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnServerConfigurations beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWanName}/p2sVpnServerConfigurations/{p2SVpnServerConfigurationName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("virtualWanName") String virtualWanName, @Path("p2SVpnServerConfigurationName") String p2SVpnServerConfigurationName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnServerConfigurations listByVirtualWan" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWanName}/p2sVpnServerConfigurations")
        Observable<Response<ResponseBody>> listByVirtualWan(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("virtualWanName") String virtualWanName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnServerConfigurations listByVirtualWanNext" })
        @GET
        Observable<Response<ResponseBody>> listByVirtualWanNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Retrieves the details of a P2SVpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the P2SVpnServerConfiguration.
     * @param virtualWanName The name of the VirtualWan.
     * @param p2SVpnServerConfigurationName The name of the P2SVpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the P2SVpnServerConfigurationInner object if successful.
     */
    public P2SVpnServerConfigurationInner get(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName) {
        return getWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName).toBlocking().single().body();
    }

    /**
     * Retrieves the details of a P2SVpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the P2SVpnServerConfiguration.
     * @param virtualWanName The name of the VirtualWan.
     * @param p2SVpnServerConfigurationName The name of the P2SVpnServerConfiguration.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<P2SVpnServerConfigurationInner> getAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName, final ServiceCallback<P2SVpnServerConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName), serviceCallback);
    }

    /**
     * Retrieves the details of a P2SVpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the P2SVpnServerConfiguration.
     * @param virtualWanName The name of the VirtualWan.
     * @param p2SVpnServerConfigurationName The name of the P2SVpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the P2SVpnServerConfigurationInner object
     */
    public Observable<P2SVpnServerConfigurationInner> getAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName) {
        return getWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName).map(new Func1<ServiceResponse<P2SVpnServerConfigurationInner>, P2SVpnServerConfigurationInner>() {
            @Override
            public P2SVpnServerConfigurationInner call(ServiceResponse<P2SVpnServerConfigurationInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves the details of a P2SVpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the P2SVpnServerConfiguration.
     * @param virtualWanName The name of the VirtualWan.
     * @param p2SVpnServerConfigurationName The name of the P2SVpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the P2SVpnServerConfigurationInner object
     */
    public Observable<ServiceResponse<P2SVpnServerConfigurationInner>> getWithServiceResponseAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWanName == null) {
            throw new IllegalArgumentException("Parameter virtualWanName is required and cannot be null.");
        }
        if (p2SVpnServerConfigurationName == null) {
            throw new IllegalArgumentException("Parameter p2SVpnServerConfigurationName is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        return service.get(this.client.subscriptionId(), resourceGroupName, virtualWanName, p2SVpnServerConfigurationName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<P2SVpnServerConfigurationInner>>>() {
                @Override
                public Observable<ServiceResponse<P2SVpnServerConfigurationInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<P2SVpnServerConfigurationInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<P2SVpnServerConfigurationInner> getDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<P2SVpnServerConfigurationInner, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<P2SVpnServerConfigurationInner>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Creates a P2SVpnServerConfiguration to associate with a VirtualWan if it doesn't exist else updates the existing P2SVpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWanName The name of the VirtualWan.
     * @param p2SVpnServerConfigurationName The name of the P2SVpnServerConfiguration.
     * @param p2SVpnServerConfigurationParameters Parameters supplied to create or Update a P2SVpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the P2SVpnServerConfigurationInner object if successful.
     */
    public P2SVpnServerConfigurationInner createOrUpdate(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName, P2SVpnServerConfigurationInner p2SVpnServerConfigurationParameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName, p2SVpnServerConfigurationParameters).toBlocking().last().body();
    }

    /**
     * Creates a P2SVpnServerConfiguration to associate with a VirtualWan if it doesn't exist else updates the existing P2SVpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWanName The name of the VirtualWan.
     * @param p2SVpnServerConfigurationName The name of the P2SVpnServerConfiguration.
     * @param p2SVpnServerConfigurationParameters Parameters supplied to create or Update a P2SVpnServerConfiguration.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<P2SVpnServerConfigurationInner> createOrUpdateAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName, P2SVpnServerConfigurationInner p2SVpnServerConfigurationParameters, final ServiceCallback<P2SVpnServerConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName, p2SVpnServerConfigurationParameters), serviceCallback);
    }

    /**
     * Creates a P2SVpnServerConfiguration to associate with a VirtualWan if it doesn't exist else updates the existing P2SVpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWanName The name of the VirtualWan.
     * @param p2SVpnServerConfigurationName The name of the P2SVpnServerConfiguration.
     * @param p2SVpnServerConfigurationParameters Parameters supplied to create or Update a P2SVpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<P2SVpnServerConfigurationInner> createOrUpdateAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName, P2SVpnServerConfigurationInner p2SVpnServerConfigurationParameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName, p2SVpnServerConfigurationParameters).map(new Func1<ServiceResponse<P2SVpnServerConfigurationInner>, P2SVpnServerConfigurationInner>() {
            @Override
            public P2SVpnServerConfigurationInner call(ServiceResponse<P2SVpnServerConfigurationInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a P2SVpnServerConfiguration to associate with a VirtualWan if it doesn't exist else updates the existing P2SVpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWanName The name of the VirtualWan.
     * @param p2SVpnServerConfigurationName The name of the P2SVpnServerConfiguration.
     * @param p2SVpnServerConfigurationParameters Parameters supplied to create or Update a P2SVpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<P2SVpnServerConfigurationInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName, P2SVpnServerConfigurationInner p2SVpnServerConfigurationParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWanName == null) {
            throw new IllegalArgumentException("Parameter virtualWanName is required and cannot be null.");
        }
        if (p2SVpnServerConfigurationName == null) {
            throw new IllegalArgumentException("Parameter p2SVpnServerConfigurationName is required and cannot be null.");
        }
        if (p2SVpnServerConfigurationParameters == null) {
            throw new IllegalArgumentException("Parameter p2SVpnServerConfigurationParameters is required and cannot be null.");
        }
        Validator.validate(p2SVpnServerConfigurationParameters);
        final String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, virtualWanName, p2SVpnServerConfigurationName, apiVersion, p2SVpnServerConfigurationParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<P2SVpnServerConfigurationInner>() { }.getType());
    }

    /**
     * Creates a P2SVpnServerConfiguration to associate with a VirtualWan if it doesn't exist else updates the existing P2SVpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWanName The name of the VirtualWan.
     * @param p2SVpnServerConfigurationName The name of the P2SVpnServerConfiguration.
     * @param p2SVpnServerConfigurationParameters Parameters supplied to create or Update a P2SVpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the P2SVpnServerConfigurationInner object if successful.
     */
    public P2SVpnServerConfigurationInner beginCreateOrUpdate(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName, P2SVpnServerConfigurationInner p2SVpnServerConfigurationParameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName, p2SVpnServerConfigurationParameters).toBlocking().single().body();
    }

    /**
     * Creates a P2SVpnServerConfiguration to associate with a VirtualWan if it doesn't exist else updates the existing P2SVpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWanName The name of the VirtualWan.
     * @param p2SVpnServerConfigurationName The name of the P2SVpnServerConfiguration.
     * @param p2SVpnServerConfigurationParameters Parameters supplied to create or Update a P2SVpnServerConfiguration.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<P2SVpnServerConfigurationInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName, P2SVpnServerConfigurationInner p2SVpnServerConfigurationParameters, final ServiceCallback<P2SVpnServerConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName, p2SVpnServerConfigurationParameters), serviceCallback);
    }

    /**
     * Creates a P2SVpnServerConfiguration to associate with a VirtualWan if it doesn't exist else updates the existing P2SVpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWanName The name of the VirtualWan.
     * @param p2SVpnServerConfigurationName The name of the P2SVpnServerConfiguration.
     * @param p2SVpnServerConfigurationParameters Parameters supplied to create or Update a P2SVpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the P2SVpnServerConfigurationInner object
     */
    public Observable<P2SVpnServerConfigurationInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName, P2SVpnServerConfigurationInner p2SVpnServerConfigurationParameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName, p2SVpnServerConfigurationParameters).map(new Func1<ServiceResponse<P2SVpnServerConfigurationInner>, P2SVpnServerConfigurationInner>() {
            @Override
            public P2SVpnServerConfigurationInner call(ServiceResponse<P2SVpnServerConfigurationInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a P2SVpnServerConfiguration to associate with a VirtualWan if it doesn't exist else updates the existing P2SVpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWanName The name of the VirtualWan.
     * @param p2SVpnServerConfigurationName The name of the P2SVpnServerConfiguration.
     * @param p2SVpnServerConfigurationParameters Parameters supplied to create or Update a P2SVpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the P2SVpnServerConfigurationInner object
     */
    public Observable<ServiceResponse<P2SVpnServerConfigurationInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName, P2SVpnServerConfigurationInner p2SVpnServerConfigurationParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWanName == null) {
            throw new IllegalArgumentException("Parameter virtualWanName is required and cannot be null.");
        }
        if (p2SVpnServerConfigurationName == null) {
            throw new IllegalArgumentException("Parameter p2SVpnServerConfigurationName is required and cannot be null.");
        }
        if (p2SVpnServerConfigurationParameters == null) {
            throw new IllegalArgumentException("Parameter p2SVpnServerConfigurationParameters is required and cannot be null.");
        }
        Validator.validate(p2SVpnServerConfigurationParameters);
        final String apiVersion = "2019-06-01";
        return service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, virtualWanName, p2SVpnServerConfigurationName, apiVersion, p2SVpnServerConfigurationParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<P2SVpnServerConfigurationInner>>>() {
                @Override
                public Observable<ServiceResponse<P2SVpnServerConfigurationInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<P2SVpnServerConfigurationInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<P2SVpnServerConfigurationInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<P2SVpnServerConfigurationInner, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<P2SVpnServerConfigurationInner>() { }.getType())
                .register(201, new TypeToken<P2SVpnServerConfigurationInner>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Deletes a P2SVpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the P2SVpnServerConfiguration.
     * @param virtualWanName The name of the VirtualWan.
     * @param p2SVpnServerConfigurationName The name of the P2SVpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName) {
        deleteWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName).toBlocking().last().body();
    }

    /**
     * Deletes a P2SVpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the P2SVpnServerConfiguration.
     * @param virtualWanName The name of the VirtualWan.
     * @param p2SVpnServerConfigurationName The name of the P2SVpnServerConfiguration.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName), serviceCallback);
    }

    /**
     * Deletes a P2SVpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the P2SVpnServerConfiguration.
     * @param virtualWanName The name of the VirtualWan.
     * @param p2SVpnServerConfigurationName The name of the P2SVpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName) {
        return deleteWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a P2SVpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the P2SVpnServerConfiguration.
     * @param virtualWanName The name of the VirtualWan.
     * @param p2SVpnServerConfigurationName The name of the P2SVpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWanName == null) {
            throw new IllegalArgumentException("Parameter virtualWanName is required and cannot be null.");
        }
        if (p2SVpnServerConfigurationName == null) {
            throw new IllegalArgumentException("Parameter p2SVpnServerConfigurationName is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = service.delete(this.client.subscriptionId(), resourceGroupName, virtualWanName, p2SVpnServerConfigurationName, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a P2SVpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the P2SVpnServerConfiguration.
     * @param virtualWanName The name of the VirtualWan.
     * @param p2SVpnServerConfigurationName The name of the P2SVpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName).toBlocking().single().body();
    }

    /**
     * Deletes a P2SVpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the P2SVpnServerConfiguration.
     * @param virtualWanName The name of the VirtualWan.
     * @param p2SVpnServerConfigurationName The name of the P2SVpnServerConfiguration.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName), serviceCallback);
    }

    /**
     * Deletes a P2SVpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the P2SVpnServerConfiguration.
     * @param virtualWanName The name of the VirtualWan.
     * @param p2SVpnServerConfigurationName The name of the P2SVpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a P2SVpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the P2SVpnServerConfiguration.
     * @param virtualWanName The name of the VirtualWan.
     * @param p2SVpnServerConfigurationName The name of the P2SVpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWanName == null) {
            throw new IllegalArgumentException("Parameter virtualWanName is required and cannot be null.");
        }
        if (p2SVpnServerConfigurationName == null) {
            throw new IllegalArgumentException("Parameter p2SVpnServerConfigurationName is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        return service.beginDelete(this.client.subscriptionId(), resourceGroupName, virtualWanName, p2SVpnServerConfigurationName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Retrieves all P2SVpnServerConfigurations for a particular VirtualWan.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWanName The name of the VirtualWan.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;P2SVpnServerConfigurationInner&gt; object if successful.
     */
    public PagedList<P2SVpnServerConfigurationInner> listByVirtualWan(final String resourceGroupName, final String virtualWanName) {
        ServiceResponse<Page<P2SVpnServerConfigurationInner>> response = listByVirtualWanSinglePageAsync(resourceGroupName, virtualWanName).toBlocking().single();
        return new PagedList<P2SVpnServerConfigurationInner>(response.body()) {
            @Override
            public Page<P2SVpnServerConfigurationInner> nextPage(String nextPageLink) {
                return listByVirtualWanNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves all P2SVpnServerConfigurations for a particular VirtualWan.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWanName The name of the VirtualWan.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<P2SVpnServerConfigurationInner>> listByVirtualWanAsync(final String resourceGroupName, final String virtualWanName, final ListOperationCallback<P2SVpnServerConfigurationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByVirtualWanSinglePageAsync(resourceGroupName, virtualWanName),
            new Func1<String, Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>> call(String nextPageLink) {
                    return listByVirtualWanNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves all P2SVpnServerConfigurations for a particular VirtualWan.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWanName The name of the VirtualWan.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;P2SVpnServerConfigurationInner&gt; object
     */
    public Observable<Page<P2SVpnServerConfigurationInner>> listByVirtualWanAsync(final String resourceGroupName, final String virtualWanName) {
        return listByVirtualWanWithServiceResponseAsync(resourceGroupName, virtualWanName)
            .map(new Func1<ServiceResponse<Page<P2SVpnServerConfigurationInner>>, Page<P2SVpnServerConfigurationInner>>() {
                @Override
                public Page<P2SVpnServerConfigurationInner> call(ServiceResponse<Page<P2SVpnServerConfigurationInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves all P2SVpnServerConfigurations for a particular VirtualWan.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWanName The name of the VirtualWan.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;P2SVpnServerConfigurationInner&gt; object
     */
    public Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>> listByVirtualWanWithServiceResponseAsync(final String resourceGroupName, final String virtualWanName) {
        return listByVirtualWanSinglePageAsync(resourceGroupName, virtualWanName)
            .concatMap(new Func1<ServiceResponse<Page<P2SVpnServerConfigurationInner>>, Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>> call(ServiceResponse<Page<P2SVpnServerConfigurationInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByVirtualWanNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves all P2SVpnServerConfigurations for a particular VirtualWan.
     *
    ServiceResponse<PageImpl<P2SVpnServerConfigurationInner>> * @param resourceGroupName The resource group name of the VirtualWan.
    ServiceResponse<PageImpl<P2SVpnServerConfigurationInner>> * @param virtualWanName The name of the VirtualWan.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;P2SVpnServerConfigurationInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>> listByVirtualWanSinglePageAsync(final String resourceGroupName, final String virtualWanName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWanName == null) {
            throw new IllegalArgumentException("Parameter virtualWanName is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        return service.listByVirtualWan(this.client.subscriptionId(), resourceGroupName, virtualWanName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<P2SVpnServerConfigurationInner>> result = listByVirtualWanDelegate(response);
                        return Observable.just(new ServiceResponse<Page<P2SVpnServerConfigurationInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<P2SVpnServerConfigurationInner>> listByVirtualWanDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<P2SVpnServerConfigurationInner>, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<P2SVpnServerConfigurationInner>>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Retrieves all P2SVpnServerConfigurations for a particular VirtualWan.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;P2SVpnServerConfigurationInner&gt; object if successful.
     */
    public PagedList<P2SVpnServerConfigurationInner> listByVirtualWanNext(final String nextPageLink) {
        ServiceResponse<Page<P2SVpnServerConfigurationInner>> response = listByVirtualWanNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<P2SVpnServerConfigurationInner>(response.body()) {
            @Override
            public Page<P2SVpnServerConfigurationInner> nextPage(String nextPageLink) {
                return listByVirtualWanNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves all P2SVpnServerConfigurations for a particular VirtualWan.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<P2SVpnServerConfigurationInner>> listByVirtualWanNextAsync(final String nextPageLink, final ServiceFuture<List<P2SVpnServerConfigurationInner>> serviceFuture, final ListOperationCallback<P2SVpnServerConfigurationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByVirtualWanNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>> call(String nextPageLink) {
                    return listByVirtualWanNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves all P2SVpnServerConfigurations for a particular VirtualWan.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;P2SVpnServerConfigurationInner&gt; object
     */
    public Observable<Page<P2SVpnServerConfigurationInner>> listByVirtualWanNextAsync(final String nextPageLink) {
        return listByVirtualWanNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<P2SVpnServerConfigurationInner>>, Page<P2SVpnServerConfigurationInner>>() {
                @Override
                public Page<P2SVpnServerConfigurationInner> call(ServiceResponse<Page<P2SVpnServerConfigurationInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves all P2SVpnServerConfigurations for a particular VirtualWan.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;P2SVpnServerConfigurationInner&gt; object
     */
    public Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>> listByVirtualWanNextWithServiceResponseAsync(final String nextPageLink) {
        return listByVirtualWanNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<P2SVpnServerConfigurationInner>>, Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>> call(ServiceResponse<Page<P2SVpnServerConfigurationInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByVirtualWanNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves all P2SVpnServerConfigurations for a particular VirtualWan.
     *
    ServiceResponse<PageImpl<P2SVpnServerConfigurationInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;P2SVpnServerConfigurationInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>> listByVirtualWanNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByVirtualWanNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<P2SVpnServerConfigurationInner>> result = listByVirtualWanNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<P2SVpnServerConfigurationInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<P2SVpnServerConfigurationInner>> listByVirtualWanNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<P2SVpnServerConfigurationInner>, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<P2SVpnServerConfigurationInner>>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

}
