/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.network.ErrorException;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * Initializes a new instance of the NetworkManagementClientImpl class.
 */
public class NetworkManagementClientImpl extends AzureServiceClient {
    /** The Retrofit service to perform REST calls. */
    private NetworkManagementClientService service;
    /** the {@link AzureClient} used for long running operations. */
    private AzureClient azureClient;

    /**
     * Gets the {@link AzureClient} used for long running operations.
     * @return the azure client;
     */
    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    /** The subscription credentials which uniquely identify the Microsoft Azure subscription. The subscription ID forms part of the URI for every service call. */
    private String subscriptionId;

    /**
     * Gets The subscription credentials which uniquely identify the Microsoft Azure subscription. The subscription ID forms part of the URI for every service call.
     *
     * @return the subscriptionId value.
     */
    public String subscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Sets The subscription credentials which uniquely identify the Microsoft Azure subscription. The subscription ID forms part of the URI for every service call.
     *
     * @param subscriptionId the subscriptionId value.
     * @return the service client itself
     */
    public NetworkManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    /** Client API version. */
    private String apiVersion;

    /**
     * Gets Client API version.
     *
     * @return the apiVersion value.
     */
    public String apiVersion() {
        return this.apiVersion;
    }

    /** The preferred language for the response. */
    private String acceptLanguage;

    /**
     * Gets The preferred language for the response.
     *
     * @return the acceptLanguage value.
     */
    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    /**
     * Sets The preferred language for the response.
     *
     * @param acceptLanguage the acceptLanguage value.
     * @return the service client itself
     */
    public NetworkManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    /** The retry timeout in seconds for Long Running Operations. Default value is 30. */
    private int longRunningOperationRetryTimeout;

    /**
     * Gets The retry timeout in seconds for Long Running Operations. Default value is 30.
     *
     * @return the longRunningOperationRetryTimeout value.
     */
    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    /**
     * Sets The retry timeout in seconds for Long Running Operations. Default value is 30.
     *
     * @param longRunningOperationRetryTimeout the longRunningOperationRetryTimeout value.
     * @return the service client itself
     */
    public NetworkManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    /** Whether a unique x-ms-client-request-id should be generated. When set to true a unique x-ms-client-request-id value is generated and included in each request. Default is true. */
    private boolean generateClientRequestId;

    /**
     * Gets Whether a unique x-ms-client-request-id should be generated. When set to true a unique x-ms-client-request-id value is generated and included in each request. Default is true.
     *
     * @return the generateClientRequestId value.
     */
    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    /**
     * Sets Whether a unique x-ms-client-request-id should be generated. When set to true a unique x-ms-client-request-id value is generated and included in each request. Default is true.
     *
     * @param generateClientRequestId the generateClientRequestId value.
     * @return the service client itself
     */
    public NetworkManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    /**
     * The ApplicationGatewaysInner object to access its operations.
     */
    private ApplicationGatewaysInner applicationGateways;

    /**
     * Gets the ApplicationGatewaysInner object to access its operations.
     * @return the ApplicationGatewaysInner object.
     */
    public ApplicationGatewaysInner applicationGateways() {
        return this.applicationGateways;
    }

    /**
     * The ApplicationSecurityGroupsInner object to access its operations.
     */
    private ApplicationSecurityGroupsInner applicationSecurityGroups;

    /**
     * Gets the ApplicationSecurityGroupsInner object to access its operations.
     * @return the ApplicationSecurityGroupsInner object.
     */
    public ApplicationSecurityGroupsInner applicationSecurityGroups() {
        return this.applicationSecurityGroups;
    }

    /**
     * The AvailableDelegationsInner object to access its operations.
     */
    private AvailableDelegationsInner availableDelegations;

    /**
     * Gets the AvailableDelegationsInner object to access its operations.
     * @return the AvailableDelegationsInner object.
     */
    public AvailableDelegationsInner availableDelegations() {
        return this.availableDelegations;
    }

    /**
     * The AvailableResourceGroupDelegationsInner object to access its operations.
     */
    private AvailableResourceGroupDelegationsInner availableResourceGroupDelegations;

    /**
     * Gets the AvailableResourceGroupDelegationsInner object to access its operations.
     * @return the AvailableResourceGroupDelegationsInner object.
     */
    public AvailableResourceGroupDelegationsInner availableResourceGroupDelegations() {
        return this.availableResourceGroupDelegations;
    }

    /**
     * The AzureFirewallsInner object to access its operations.
     */
    private AzureFirewallsInner azureFirewalls;

    /**
     * Gets the AzureFirewallsInner object to access its operations.
     * @return the AzureFirewallsInner object.
     */
    public AzureFirewallsInner azureFirewalls() {
        return this.azureFirewalls;
    }

    /**
     * The AzureFirewallFqdnTagsInner object to access its operations.
     */
    private AzureFirewallFqdnTagsInner azureFirewallFqdnTags;

    /**
     * Gets the AzureFirewallFqdnTagsInner object to access its operations.
     * @return the AzureFirewallFqdnTagsInner object.
     */
    public AzureFirewallFqdnTagsInner azureFirewallFqdnTags() {
        return this.azureFirewallFqdnTags;
    }

    /**
     * The BastionHostsInner object to access its operations.
     */
    private BastionHostsInner bastionHosts;

    /**
     * Gets the BastionHostsInner object to access its operations.
     * @return the BastionHostsInner object.
     */
    public BastionHostsInner bastionHosts() {
        return this.bastionHosts;
    }

    /**
     * The DdosCustomPoliciesInner object to access its operations.
     */
    private DdosCustomPoliciesInner ddosCustomPolicies;

    /**
     * Gets the DdosCustomPoliciesInner object to access its operations.
     * @return the DdosCustomPoliciesInner object.
     */
    public DdosCustomPoliciesInner ddosCustomPolicies() {
        return this.ddosCustomPolicies;
    }

    /**
     * The DdosProtectionPlansInner object to access its operations.
     */
    private DdosProtectionPlansInner ddosProtectionPlans;

    /**
     * Gets the DdosProtectionPlansInner object to access its operations.
     * @return the DdosProtectionPlansInner object.
     */
    public DdosProtectionPlansInner ddosProtectionPlans() {
        return this.ddosProtectionPlans;
    }

    /**
     * The AvailableEndpointServicesInner object to access its operations.
     */
    private AvailableEndpointServicesInner availableEndpointServices;

    /**
     * Gets the AvailableEndpointServicesInner object to access its operations.
     * @return the AvailableEndpointServicesInner object.
     */
    public AvailableEndpointServicesInner availableEndpointServices() {
        return this.availableEndpointServices;
    }

    /**
     * The ExpressRouteCircuitAuthorizationsInner object to access its operations.
     */
    private ExpressRouteCircuitAuthorizationsInner expressRouteCircuitAuthorizations;

    /**
     * Gets the ExpressRouteCircuitAuthorizationsInner object to access its operations.
     * @return the ExpressRouteCircuitAuthorizationsInner object.
     */
    public ExpressRouteCircuitAuthorizationsInner expressRouteCircuitAuthorizations() {
        return this.expressRouteCircuitAuthorizations;
    }

    /**
     * The ExpressRouteCircuitPeeringsInner object to access its operations.
     */
    private ExpressRouteCircuitPeeringsInner expressRouteCircuitPeerings;

    /**
     * Gets the ExpressRouteCircuitPeeringsInner object to access its operations.
     * @return the ExpressRouteCircuitPeeringsInner object.
     */
    public ExpressRouteCircuitPeeringsInner expressRouteCircuitPeerings() {
        return this.expressRouteCircuitPeerings;
    }

    /**
     * The ExpressRouteCircuitConnectionsInner object to access its operations.
     */
    private ExpressRouteCircuitConnectionsInner expressRouteCircuitConnections;

    /**
     * Gets the ExpressRouteCircuitConnectionsInner object to access its operations.
     * @return the ExpressRouteCircuitConnectionsInner object.
     */
    public ExpressRouteCircuitConnectionsInner expressRouteCircuitConnections() {
        return this.expressRouteCircuitConnections;
    }

    /**
     * The PeerExpressRouteCircuitConnectionsInner object to access its operations.
     */
    private PeerExpressRouteCircuitConnectionsInner peerExpressRouteCircuitConnections;

    /**
     * Gets the PeerExpressRouteCircuitConnectionsInner object to access its operations.
     * @return the PeerExpressRouteCircuitConnectionsInner object.
     */
    public PeerExpressRouteCircuitConnectionsInner peerExpressRouteCircuitConnections() {
        return this.peerExpressRouteCircuitConnections;
    }

    /**
     * The ExpressRouteCircuitsInner object to access its operations.
     */
    private ExpressRouteCircuitsInner expressRouteCircuits;

    /**
     * Gets the ExpressRouteCircuitsInner object to access its operations.
     * @return the ExpressRouteCircuitsInner object.
     */
    public ExpressRouteCircuitsInner expressRouteCircuits() {
        return this.expressRouteCircuits;
    }

    /**
     * The ExpressRouteServiceProvidersInner object to access its operations.
     */
    private ExpressRouteServiceProvidersInner expressRouteServiceProviders;

    /**
     * Gets the ExpressRouteServiceProvidersInner object to access its operations.
     * @return the ExpressRouteServiceProvidersInner object.
     */
    public ExpressRouteServiceProvidersInner expressRouteServiceProviders() {
        return this.expressRouteServiceProviders;
    }

    /**
     * The ExpressRouteCrossConnectionsInner object to access its operations.
     */
    private ExpressRouteCrossConnectionsInner expressRouteCrossConnections;

    /**
     * Gets the ExpressRouteCrossConnectionsInner object to access its operations.
     * @return the ExpressRouteCrossConnectionsInner object.
     */
    public ExpressRouteCrossConnectionsInner expressRouteCrossConnections() {
        return this.expressRouteCrossConnections;
    }

    /**
     * The ExpressRouteCrossConnectionPeeringsInner object to access its operations.
     */
    private ExpressRouteCrossConnectionPeeringsInner expressRouteCrossConnectionPeerings;

    /**
     * Gets the ExpressRouteCrossConnectionPeeringsInner object to access its operations.
     * @return the ExpressRouteCrossConnectionPeeringsInner object.
     */
    public ExpressRouteCrossConnectionPeeringsInner expressRouteCrossConnectionPeerings() {
        return this.expressRouteCrossConnectionPeerings;
    }

    /**
     * The ExpressRouteGatewaysInner object to access its operations.
     */
    private ExpressRouteGatewaysInner expressRouteGateways;

    /**
     * Gets the ExpressRouteGatewaysInner object to access its operations.
     * @return the ExpressRouteGatewaysInner object.
     */
    public ExpressRouteGatewaysInner expressRouteGateways() {
        return this.expressRouteGateways;
    }

    /**
     * The ExpressRouteConnectionsInner object to access its operations.
     */
    private ExpressRouteConnectionsInner expressRouteConnections;

    /**
     * Gets the ExpressRouteConnectionsInner object to access its operations.
     * @return the ExpressRouteConnectionsInner object.
     */
    public ExpressRouteConnectionsInner expressRouteConnections() {
        return this.expressRouteConnections;
    }

    /**
     * The ExpressRoutePortsLocationsInner object to access its operations.
     */
    private ExpressRoutePortsLocationsInner expressRoutePortsLocations;

    /**
     * Gets the ExpressRoutePortsLocationsInner object to access its operations.
     * @return the ExpressRoutePortsLocationsInner object.
     */
    public ExpressRoutePortsLocationsInner expressRoutePortsLocations() {
        return this.expressRoutePortsLocations;
    }

    /**
     * The ExpressRoutePortsInner object to access its operations.
     */
    private ExpressRoutePortsInner expressRoutePorts;

    /**
     * Gets the ExpressRoutePortsInner object to access its operations.
     * @return the ExpressRoutePortsInner object.
     */
    public ExpressRoutePortsInner expressRoutePorts() {
        return this.expressRoutePorts;
    }

    /**
     * The ExpressRouteLinksInner object to access its operations.
     */
    private ExpressRouteLinksInner expressRouteLinks;

    /**
     * Gets the ExpressRouteLinksInner object to access its operations.
     * @return the ExpressRouteLinksInner object.
     */
    public ExpressRouteLinksInner expressRouteLinks() {
        return this.expressRouteLinks;
    }

    /**
     * The LoadBalancersInner object to access its operations.
     */
    private LoadBalancersInner loadBalancers;

    /**
     * Gets the LoadBalancersInner object to access its operations.
     * @return the LoadBalancersInner object.
     */
    public LoadBalancersInner loadBalancers() {
        return this.loadBalancers;
    }

    /**
     * The LoadBalancerBackendAddressPoolsInner object to access its operations.
     */
    private LoadBalancerBackendAddressPoolsInner loadBalancerBackendAddressPools;

    /**
     * Gets the LoadBalancerBackendAddressPoolsInner object to access its operations.
     * @return the LoadBalancerBackendAddressPoolsInner object.
     */
    public LoadBalancerBackendAddressPoolsInner loadBalancerBackendAddressPools() {
        return this.loadBalancerBackendAddressPools;
    }

    /**
     * The LoadBalancerFrontendIPConfigurationsInner object to access its operations.
     */
    private LoadBalancerFrontendIPConfigurationsInner loadBalancerFrontendIPConfigurations;

    /**
     * Gets the LoadBalancerFrontendIPConfigurationsInner object to access its operations.
     * @return the LoadBalancerFrontendIPConfigurationsInner object.
     */
    public LoadBalancerFrontendIPConfigurationsInner loadBalancerFrontendIPConfigurations() {
        return this.loadBalancerFrontendIPConfigurations;
    }

    /**
     * The InboundNatRulesInner object to access its operations.
     */
    private InboundNatRulesInner inboundNatRules;

    /**
     * Gets the InboundNatRulesInner object to access its operations.
     * @return the InboundNatRulesInner object.
     */
    public InboundNatRulesInner inboundNatRules() {
        return this.inboundNatRules;
    }

    /**
     * The LoadBalancerLoadBalancingRulesInner object to access its operations.
     */
    private LoadBalancerLoadBalancingRulesInner loadBalancerLoadBalancingRules;

    /**
     * Gets the LoadBalancerLoadBalancingRulesInner object to access its operations.
     * @return the LoadBalancerLoadBalancingRulesInner object.
     */
    public LoadBalancerLoadBalancingRulesInner loadBalancerLoadBalancingRules() {
        return this.loadBalancerLoadBalancingRules;
    }

    /**
     * The LoadBalancerOutboundRulesInner object to access its operations.
     */
    private LoadBalancerOutboundRulesInner loadBalancerOutboundRules;

    /**
     * Gets the LoadBalancerOutboundRulesInner object to access its operations.
     * @return the LoadBalancerOutboundRulesInner object.
     */
    public LoadBalancerOutboundRulesInner loadBalancerOutboundRules() {
        return this.loadBalancerOutboundRules;
    }

    /**
     * The LoadBalancerNetworkInterfacesInner object to access its operations.
     */
    private LoadBalancerNetworkInterfacesInner loadBalancerNetworkInterfaces;

    /**
     * Gets the LoadBalancerNetworkInterfacesInner object to access its operations.
     * @return the LoadBalancerNetworkInterfacesInner object.
     */
    public LoadBalancerNetworkInterfacesInner loadBalancerNetworkInterfaces() {
        return this.loadBalancerNetworkInterfaces;
    }

    /**
     * The LoadBalancerProbesInner object to access its operations.
     */
    private LoadBalancerProbesInner loadBalancerProbes;

    /**
     * Gets the LoadBalancerProbesInner object to access its operations.
     * @return the LoadBalancerProbesInner object.
     */
    public LoadBalancerProbesInner loadBalancerProbes() {
        return this.loadBalancerProbes;
    }

    /**
     * The NatGatewaysInner object to access its operations.
     */
    private NatGatewaysInner natGateways;

    /**
     * Gets the NatGatewaysInner object to access its operations.
     * @return the NatGatewaysInner object.
     */
    public NatGatewaysInner natGateways() {
        return this.natGateways;
    }

    /**
     * The NetworkInterfacesInner object to access its operations.
     */
    private NetworkInterfacesInner networkInterfaces;

    /**
     * Gets the NetworkInterfacesInner object to access its operations.
     * @return the NetworkInterfacesInner object.
     */
    public NetworkInterfacesInner networkInterfaces() {
        return this.networkInterfaces;
    }

    /**
     * The NetworkInterfaceIPConfigurationsInner object to access its operations.
     */
    private NetworkInterfaceIPConfigurationsInner networkInterfaceIPConfigurations;

    /**
     * Gets the NetworkInterfaceIPConfigurationsInner object to access its operations.
     * @return the NetworkInterfaceIPConfigurationsInner object.
     */
    public NetworkInterfaceIPConfigurationsInner networkInterfaceIPConfigurations() {
        return this.networkInterfaceIPConfigurations;
    }

    /**
     * The NetworkInterfaceLoadBalancersInner object to access its operations.
     */
    private NetworkInterfaceLoadBalancersInner networkInterfaceLoadBalancers;

    /**
     * Gets the NetworkInterfaceLoadBalancersInner object to access its operations.
     * @return the NetworkInterfaceLoadBalancersInner object.
     */
    public NetworkInterfaceLoadBalancersInner networkInterfaceLoadBalancers() {
        return this.networkInterfaceLoadBalancers;
    }

    /**
     * The NetworkInterfaceTapConfigurationsInner object to access its operations.
     */
    private NetworkInterfaceTapConfigurationsInner networkInterfaceTapConfigurations;

    /**
     * Gets the NetworkInterfaceTapConfigurationsInner object to access its operations.
     * @return the NetworkInterfaceTapConfigurationsInner object.
     */
    public NetworkInterfaceTapConfigurationsInner networkInterfaceTapConfigurations() {
        return this.networkInterfaceTapConfigurations;
    }

    /**
     * The NetworkProfilesInner object to access its operations.
     */
    private NetworkProfilesInner networkProfiles;

    /**
     * Gets the NetworkProfilesInner object to access its operations.
     * @return the NetworkProfilesInner object.
     */
    public NetworkProfilesInner networkProfiles() {
        return this.networkProfiles;
    }

    /**
     * The NetworkSecurityGroupsInner object to access its operations.
     */
    private NetworkSecurityGroupsInner networkSecurityGroups;

    /**
     * Gets the NetworkSecurityGroupsInner object to access its operations.
     * @return the NetworkSecurityGroupsInner object.
     */
    public NetworkSecurityGroupsInner networkSecurityGroups() {
        return this.networkSecurityGroups;
    }

    /**
     * The SecurityRulesInner object to access its operations.
     */
    private SecurityRulesInner securityRules;

    /**
     * Gets the SecurityRulesInner object to access its operations.
     * @return the SecurityRulesInner object.
     */
    public SecurityRulesInner securityRules() {
        return this.securityRules;
    }

    /**
     * The DefaultSecurityRulesInner object to access its operations.
     */
    private DefaultSecurityRulesInner defaultSecurityRules;

    /**
     * Gets the DefaultSecurityRulesInner object to access its operations.
     * @return the DefaultSecurityRulesInner object.
     */
    public DefaultSecurityRulesInner defaultSecurityRules() {
        return this.defaultSecurityRules;
    }

    /**
     * The NetworkWatchersInner object to access its operations.
     */
    private NetworkWatchersInner networkWatchers;

    /**
     * Gets the NetworkWatchersInner object to access its operations.
     * @return the NetworkWatchersInner object.
     */
    public NetworkWatchersInner networkWatchers() {
        return this.networkWatchers;
    }

    /**
     * The PacketCapturesInner object to access its operations.
     */
    private PacketCapturesInner packetCaptures;

    /**
     * Gets the PacketCapturesInner object to access its operations.
     * @return the PacketCapturesInner object.
     */
    public PacketCapturesInner packetCaptures() {
        return this.packetCaptures;
    }

    /**
     * The ConnectionMonitorsInner object to access its operations.
     */
    private ConnectionMonitorsInner connectionMonitors;

    /**
     * Gets the ConnectionMonitorsInner object to access its operations.
     * @return the ConnectionMonitorsInner object.
     */
    public ConnectionMonitorsInner connectionMonitors() {
        return this.connectionMonitors;
    }

    /**
     * The OperationsInner object to access its operations.
     */
    private OperationsInner operations;

    /**
     * Gets the OperationsInner object to access its operations.
     * @return the OperationsInner object.
     */
    public OperationsInner operations() {
        return this.operations;
    }

    /**
     * The PrivateEndpointsInner object to access its operations.
     */
    private PrivateEndpointsInner privateEndpoints;

    /**
     * Gets the PrivateEndpointsInner object to access its operations.
     * @return the PrivateEndpointsInner object.
     */
    public PrivateEndpointsInner privateEndpoints() {
        return this.privateEndpoints;
    }

    /**
     * The AvailablePrivateEndpointTypesInner object to access its operations.
     */
    private AvailablePrivateEndpointTypesInner availablePrivateEndpointTypes;

    /**
     * Gets the AvailablePrivateEndpointTypesInner object to access its operations.
     * @return the AvailablePrivateEndpointTypesInner object.
     */
    public AvailablePrivateEndpointTypesInner availablePrivateEndpointTypes() {
        return this.availablePrivateEndpointTypes;
    }

    /**
     * The PrivateLinkServicesInner object to access its operations.
     */
    private PrivateLinkServicesInner privateLinkServices;

    /**
     * Gets the PrivateLinkServicesInner object to access its operations.
     * @return the PrivateLinkServicesInner object.
     */
    public PrivateLinkServicesInner privateLinkServices() {
        return this.privateLinkServices;
    }

    /**
     * The PublicIPAddressesInner object to access its operations.
     */
    private PublicIPAddressesInner publicIPAddresses;

    /**
     * Gets the PublicIPAddressesInner object to access its operations.
     * @return the PublicIPAddressesInner object.
     */
    public PublicIPAddressesInner publicIPAddresses() {
        return this.publicIPAddresses;
    }

    /**
     * The PublicIPPrefixesInner object to access its operations.
     */
    private PublicIPPrefixesInner publicIPPrefixes;

    /**
     * Gets the PublicIPPrefixesInner object to access its operations.
     * @return the PublicIPPrefixesInner object.
     */
    public PublicIPPrefixesInner publicIPPrefixes() {
        return this.publicIPPrefixes;
    }

    /**
     * The RouteFiltersInner object to access its operations.
     */
    private RouteFiltersInner routeFilters;

    /**
     * Gets the RouteFiltersInner object to access its operations.
     * @return the RouteFiltersInner object.
     */
    public RouteFiltersInner routeFilters() {
        return this.routeFilters;
    }

    /**
     * The RouteFilterRulesInner object to access its operations.
     */
    private RouteFilterRulesInner routeFilterRules;

    /**
     * Gets the RouteFilterRulesInner object to access its operations.
     * @return the RouteFilterRulesInner object.
     */
    public RouteFilterRulesInner routeFilterRules() {
        return this.routeFilterRules;
    }

    /**
     * The RouteTablesInner object to access its operations.
     */
    private RouteTablesInner routeTables;

    /**
     * Gets the RouteTablesInner object to access its operations.
     * @return the RouteTablesInner object.
     */
    public RouteTablesInner routeTables() {
        return this.routeTables;
    }

    /**
     * The RoutesInner object to access its operations.
     */
    private RoutesInner routes;

    /**
     * Gets the RoutesInner object to access its operations.
     * @return the RoutesInner object.
     */
    public RoutesInner routes() {
        return this.routes;
    }

    /**
     * The BgpServiceCommunitiesInner object to access its operations.
     */
    private BgpServiceCommunitiesInner bgpServiceCommunities;

    /**
     * Gets the BgpServiceCommunitiesInner object to access its operations.
     * @return the BgpServiceCommunitiesInner object.
     */
    public BgpServiceCommunitiesInner bgpServiceCommunities() {
        return this.bgpServiceCommunities;
    }

    /**
     * The ServiceEndpointPoliciesInner object to access its operations.
     */
    private ServiceEndpointPoliciesInner serviceEndpointPolicies;

    /**
     * Gets the ServiceEndpointPoliciesInner object to access its operations.
     * @return the ServiceEndpointPoliciesInner object.
     */
    public ServiceEndpointPoliciesInner serviceEndpointPolicies() {
        return this.serviceEndpointPolicies;
    }

    /**
     * The ServiceEndpointPolicyDefinitionsInner object to access its operations.
     */
    private ServiceEndpointPolicyDefinitionsInner serviceEndpointPolicyDefinitions;

    /**
     * Gets the ServiceEndpointPolicyDefinitionsInner object to access its operations.
     * @return the ServiceEndpointPolicyDefinitionsInner object.
     */
    public ServiceEndpointPolicyDefinitionsInner serviceEndpointPolicyDefinitions() {
        return this.serviceEndpointPolicyDefinitions;
    }

    /**
     * The ServiceTagsInner object to access its operations.
     */
    private ServiceTagsInner serviceTags;

    /**
     * Gets the ServiceTagsInner object to access its operations.
     * @return the ServiceTagsInner object.
     */
    public ServiceTagsInner serviceTags() {
        return this.serviceTags;
    }

    /**
     * The UsagesInner object to access its operations.
     */
    private UsagesInner usages;

    /**
     * Gets the UsagesInner object to access its operations.
     * @return the UsagesInner object.
     */
    public UsagesInner usages() {
        return this.usages;
    }

    /**
     * The VirtualNetworksInner object to access its operations.
     */
    private VirtualNetworksInner virtualNetworks;

    /**
     * Gets the VirtualNetworksInner object to access its operations.
     * @return the VirtualNetworksInner object.
     */
    public VirtualNetworksInner virtualNetworks() {
        return this.virtualNetworks;
    }

    /**
     * The SubnetsInner object to access its operations.
     */
    private SubnetsInner subnets;

    /**
     * Gets the SubnetsInner object to access its operations.
     * @return the SubnetsInner object.
     */
    public SubnetsInner subnets() {
        return this.subnets;
    }

    /**
     * The ResourceNavigationLinksInner object to access its operations.
     */
    private ResourceNavigationLinksInner resourceNavigationLinks;

    /**
     * Gets the ResourceNavigationLinksInner object to access its operations.
     * @return the ResourceNavigationLinksInner object.
     */
    public ResourceNavigationLinksInner resourceNavigationLinks() {
        return this.resourceNavigationLinks;
    }

    /**
     * The ServiceAssociationLinksInner object to access its operations.
     */
    private ServiceAssociationLinksInner serviceAssociationLinks;

    /**
     * Gets the ServiceAssociationLinksInner object to access its operations.
     * @return the ServiceAssociationLinksInner object.
     */
    public ServiceAssociationLinksInner serviceAssociationLinks() {
        return this.serviceAssociationLinks;
    }

    /**
     * The VirtualNetworkPeeringsInner object to access its operations.
     */
    private VirtualNetworkPeeringsInner virtualNetworkPeerings;

    /**
     * Gets the VirtualNetworkPeeringsInner object to access its operations.
     * @return the VirtualNetworkPeeringsInner object.
     */
    public VirtualNetworkPeeringsInner virtualNetworkPeerings() {
        return this.virtualNetworkPeerings;
    }

    /**
     * The VirtualNetworkGatewaysInner object to access its operations.
     */
    private VirtualNetworkGatewaysInner virtualNetworkGateways;

    /**
     * Gets the VirtualNetworkGatewaysInner object to access its operations.
     * @return the VirtualNetworkGatewaysInner object.
     */
    public VirtualNetworkGatewaysInner virtualNetworkGateways() {
        return this.virtualNetworkGateways;
    }

    /**
     * The VirtualNetworkGatewayConnectionsInner object to access its operations.
     */
    private VirtualNetworkGatewayConnectionsInner virtualNetworkGatewayConnections;

    /**
     * Gets the VirtualNetworkGatewayConnectionsInner object to access its operations.
     * @return the VirtualNetworkGatewayConnectionsInner object.
     */
    public VirtualNetworkGatewayConnectionsInner virtualNetworkGatewayConnections() {
        return this.virtualNetworkGatewayConnections;
    }

    /**
     * The LocalNetworkGatewaysInner object to access its operations.
     */
    private LocalNetworkGatewaysInner localNetworkGateways;

    /**
     * Gets the LocalNetworkGatewaysInner object to access its operations.
     * @return the LocalNetworkGatewaysInner object.
     */
    public LocalNetworkGatewaysInner localNetworkGateways() {
        return this.localNetworkGateways;
    }

    /**
     * The VirtualNetworkTapsInner object to access its operations.
     */
    private VirtualNetworkTapsInner virtualNetworkTaps;

    /**
     * Gets the VirtualNetworkTapsInner object to access its operations.
     * @return the VirtualNetworkTapsInner object.
     */
    public VirtualNetworkTapsInner virtualNetworkTaps() {
        return this.virtualNetworkTaps;
    }

    /**
     * The VirtualWANsInner object to access its operations.
     */
    private VirtualWANsInner virtualWans;

    /**
     * Gets the VirtualWANsInner object to access its operations.
     * @return the VirtualWANsInner object.
     */
    public VirtualWANsInner virtualWans() {
        return this.virtualWans;
    }

    /**
     * The VpnSitesInner object to access its operations.
     */
    private VpnSitesInner vpnSites;

    /**
     * Gets the VpnSitesInner object to access its operations.
     * @return the VpnSitesInner object.
     */
    public VpnSitesInner vpnSites() {
        return this.vpnSites;
    }

    /**
     * The VpnSiteLinksInner object to access its operations.
     */
    private VpnSiteLinksInner vpnSiteLinks;

    /**
     * Gets the VpnSiteLinksInner object to access its operations.
     * @return the VpnSiteLinksInner object.
     */
    public VpnSiteLinksInner vpnSiteLinks() {
        return this.vpnSiteLinks;
    }

    /**
     * The VpnSitesConfigurationsInner object to access its operations.
     */
    private VpnSitesConfigurationsInner vpnSitesConfigurations;

    /**
     * Gets the VpnSitesConfigurationsInner object to access its operations.
     * @return the VpnSitesConfigurationsInner object.
     */
    public VpnSitesConfigurationsInner vpnSitesConfigurations() {
        return this.vpnSitesConfigurations;
    }

    /**
     * The VirtualHubsInner object to access its operations.
     */
    private VirtualHubsInner virtualHubs;

    /**
     * Gets the VirtualHubsInner object to access its operations.
     * @return the VirtualHubsInner object.
     */
    public VirtualHubsInner virtualHubs() {
        return this.virtualHubs;
    }

    /**
     * The HubVirtualNetworkConnectionsInner object to access its operations.
     */
    private HubVirtualNetworkConnectionsInner hubVirtualNetworkConnections;

    /**
     * Gets the HubVirtualNetworkConnectionsInner object to access its operations.
     * @return the HubVirtualNetworkConnectionsInner object.
     */
    public HubVirtualNetworkConnectionsInner hubVirtualNetworkConnections() {
        return this.hubVirtualNetworkConnections;
    }

    /**
     * The VpnGatewaysInner object to access its operations.
     */
    private VpnGatewaysInner vpnGateways;

    /**
     * Gets the VpnGatewaysInner object to access its operations.
     * @return the VpnGatewaysInner object.
     */
    public VpnGatewaysInner vpnGateways() {
        return this.vpnGateways;
    }

    /**
     * The VpnConnectionsInner object to access its operations.
     */
    private VpnConnectionsInner vpnConnections;

    /**
     * Gets the VpnConnectionsInner object to access its operations.
     * @return the VpnConnectionsInner object.
     */
    public VpnConnectionsInner vpnConnections() {
        return this.vpnConnections;
    }

    /**
     * The VpnSiteLinkConnectionsInner object to access its operations.
     */
    private VpnSiteLinkConnectionsInner vpnSiteLinkConnections;

    /**
     * Gets the VpnSiteLinkConnectionsInner object to access its operations.
     * @return the VpnSiteLinkConnectionsInner object.
     */
    public VpnSiteLinkConnectionsInner vpnSiteLinkConnections() {
        return this.vpnSiteLinkConnections;
    }

    /**
     * The VpnLinkConnectionsInner object to access its operations.
     */
    private VpnLinkConnectionsInner vpnLinkConnections;

    /**
     * Gets the VpnLinkConnectionsInner object to access its operations.
     * @return the VpnLinkConnectionsInner object.
     */
    public VpnLinkConnectionsInner vpnLinkConnections() {
        return this.vpnLinkConnections;
    }

    /**
     * The P2sVpnServerConfigurationsInner object to access its operations.
     */
    private P2sVpnServerConfigurationsInner p2sVpnServerConfigurations;

    /**
     * Gets the P2sVpnServerConfigurationsInner object to access its operations.
     * @return the P2sVpnServerConfigurationsInner object.
     */
    public P2sVpnServerConfigurationsInner p2sVpnServerConfigurations() {
        return this.p2sVpnServerConfigurations;
    }

    /**
     * The P2sVpnGatewaysInner object to access its operations.
     */
    private P2sVpnGatewaysInner p2sVpnGateways;

    /**
     * Gets the P2sVpnGatewaysInner object to access its operations.
     * @return the P2sVpnGatewaysInner object.
     */
    public P2sVpnGatewaysInner p2sVpnGateways() {
        return this.p2sVpnGateways;
    }

    /**
     * The WebApplicationFirewallPoliciesInner object to access its operations.
     */
    private WebApplicationFirewallPoliciesInner webApplicationFirewallPolicies;

    /**
     * Gets the WebApplicationFirewallPoliciesInner object to access its operations.
     * @return the WebApplicationFirewallPoliciesInner object.
     */
    public WebApplicationFirewallPoliciesInner webApplicationFirewallPolicies() {
        return this.webApplicationFirewallPolicies;
    }

    /**
     * Initializes an instance of NetworkManagementClient client.
     *
     * @param credentials the management credentials for Azure
     */
    public NetworkManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    /**
     * Initializes an instance of NetworkManagementClient client.
     *
     * @param baseUrl the base URL of the host
     * @param credentials the management credentials for Azure
     */
    public NetworkManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        initialize();
    }

    /**
     * Initializes an instance of NetworkManagementClient client.
     *
     * @param restClient the REST client to connect to Azure.
     */
    public NetworkManagementClientImpl(RestClient restClient) {
        super(restClient);
        initialize();
    }

    protected void initialize() {
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.applicationGateways = new ApplicationGatewaysInner(restClient().retrofit(), this);
        this.applicationSecurityGroups = new ApplicationSecurityGroupsInner(restClient().retrofit(), this);
        this.availableDelegations = new AvailableDelegationsInner(restClient().retrofit(), this);
        this.availableResourceGroupDelegations = new AvailableResourceGroupDelegationsInner(restClient().retrofit(), this);
        this.azureFirewalls = new AzureFirewallsInner(restClient().retrofit(), this);
        this.azureFirewallFqdnTags = new AzureFirewallFqdnTagsInner(restClient().retrofit(), this);
        this.bastionHosts = new BastionHostsInner(restClient().retrofit(), this);
        this.ddosCustomPolicies = new DdosCustomPoliciesInner(restClient().retrofit(), this);
        this.ddosProtectionPlans = new DdosProtectionPlansInner(restClient().retrofit(), this);
        this.availableEndpointServices = new AvailableEndpointServicesInner(restClient().retrofit(), this);
        this.expressRouteCircuitAuthorizations = new ExpressRouteCircuitAuthorizationsInner(restClient().retrofit(), this);
        this.expressRouteCircuitPeerings = new ExpressRouteCircuitPeeringsInner(restClient().retrofit(), this);
        this.expressRouteCircuitConnections = new ExpressRouteCircuitConnectionsInner(restClient().retrofit(), this);
        this.peerExpressRouteCircuitConnections = new PeerExpressRouteCircuitConnectionsInner(restClient().retrofit(), this);
        this.expressRouteCircuits = new ExpressRouteCircuitsInner(restClient().retrofit(), this);
        this.expressRouteServiceProviders = new ExpressRouteServiceProvidersInner(restClient().retrofit(), this);
        this.expressRouteCrossConnections = new ExpressRouteCrossConnectionsInner(restClient().retrofit(), this);
        this.expressRouteCrossConnectionPeerings = new ExpressRouteCrossConnectionPeeringsInner(restClient().retrofit(), this);
        this.expressRouteGateways = new ExpressRouteGatewaysInner(restClient().retrofit(), this);
        this.expressRouteConnections = new ExpressRouteConnectionsInner(restClient().retrofit(), this);
        this.expressRoutePortsLocations = new ExpressRoutePortsLocationsInner(restClient().retrofit(), this);
        this.expressRoutePorts = new ExpressRoutePortsInner(restClient().retrofit(), this);
        this.expressRouteLinks = new ExpressRouteLinksInner(restClient().retrofit(), this);
        this.loadBalancers = new LoadBalancersInner(restClient().retrofit(), this);
        this.loadBalancerBackendAddressPools = new LoadBalancerBackendAddressPoolsInner(restClient().retrofit(), this);
        this.loadBalancerFrontendIPConfigurations = new LoadBalancerFrontendIPConfigurationsInner(restClient().retrofit(), this);
        this.inboundNatRules = new InboundNatRulesInner(restClient().retrofit(), this);
        this.loadBalancerLoadBalancingRules = new LoadBalancerLoadBalancingRulesInner(restClient().retrofit(), this);
        this.loadBalancerOutboundRules = new LoadBalancerOutboundRulesInner(restClient().retrofit(), this);
        this.loadBalancerNetworkInterfaces = new LoadBalancerNetworkInterfacesInner(restClient().retrofit(), this);
        this.loadBalancerProbes = new LoadBalancerProbesInner(restClient().retrofit(), this);
        this.natGateways = new NatGatewaysInner(restClient().retrofit(), this);
        this.networkInterfaces = new NetworkInterfacesInner(restClient().retrofit(), this);
        this.networkInterfaceIPConfigurations = new NetworkInterfaceIPConfigurationsInner(restClient().retrofit(), this);
        this.networkInterfaceLoadBalancers = new NetworkInterfaceLoadBalancersInner(restClient().retrofit(), this);
        this.networkInterfaceTapConfigurations = new NetworkInterfaceTapConfigurationsInner(restClient().retrofit(), this);
        this.networkProfiles = new NetworkProfilesInner(restClient().retrofit(), this);
        this.networkSecurityGroups = new NetworkSecurityGroupsInner(restClient().retrofit(), this);
        this.securityRules = new SecurityRulesInner(restClient().retrofit(), this);
        this.defaultSecurityRules = new DefaultSecurityRulesInner(restClient().retrofit(), this);
        this.networkWatchers = new NetworkWatchersInner(restClient().retrofit(), this);
        this.packetCaptures = new PacketCapturesInner(restClient().retrofit(), this);
        this.connectionMonitors = new ConnectionMonitorsInner(restClient().retrofit(), this);
        this.operations = new OperationsInner(restClient().retrofit(), this);
        this.privateEndpoints = new PrivateEndpointsInner(restClient().retrofit(), this);
        this.availablePrivateEndpointTypes = new AvailablePrivateEndpointTypesInner(restClient().retrofit(), this);
        this.privateLinkServices = new PrivateLinkServicesInner(restClient().retrofit(), this);
        this.publicIPAddresses = new PublicIPAddressesInner(restClient().retrofit(), this);
        this.publicIPPrefixes = new PublicIPPrefixesInner(restClient().retrofit(), this);
        this.routeFilters = new RouteFiltersInner(restClient().retrofit(), this);
        this.routeFilterRules = new RouteFilterRulesInner(restClient().retrofit(), this);
        this.routeTables = new RouteTablesInner(restClient().retrofit(), this);
        this.routes = new RoutesInner(restClient().retrofit(), this);
        this.bgpServiceCommunities = new BgpServiceCommunitiesInner(restClient().retrofit(), this);
        this.serviceEndpointPolicies = new ServiceEndpointPoliciesInner(restClient().retrofit(), this);
        this.serviceEndpointPolicyDefinitions = new ServiceEndpointPolicyDefinitionsInner(restClient().retrofit(), this);
        this.serviceTags = new ServiceTagsInner(restClient().retrofit(), this);
        this.usages = new UsagesInner(restClient().retrofit(), this);
        this.virtualNetworks = new VirtualNetworksInner(restClient().retrofit(), this);
        this.subnets = new SubnetsInner(restClient().retrofit(), this);
        this.resourceNavigationLinks = new ResourceNavigationLinksInner(restClient().retrofit(), this);
        this.serviceAssociationLinks = new ServiceAssociationLinksInner(restClient().retrofit(), this);
        this.virtualNetworkPeerings = new VirtualNetworkPeeringsInner(restClient().retrofit(), this);
        this.virtualNetworkGateways = new VirtualNetworkGatewaysInner(restClient().retrofit(), this);
        this.virtualNetworkGatewayConnections = new VirtualNetworkGatewayConnectionsInner(restClient().retrofit(), this);
        this.localNetworkGateways = new LocalNetworkGatewaysInner(restClient().retrofit(), this);
        this.virtualNetworkTaps = new VirtualNetworkTapsInner(restClient().retrofit(), this);
        this.virtualWans = new VirtualWANsInner(restClient().retrofit(), this);
        this.vpnSites = new VpnSitesInner(restClient().retrofit(), this);
        this.vpnSiteLinks = new VpnSiteLinksInner(restClient().retrofit(), this);
        this.vpnSitesConfigurations = new VpnSitesConfigurationsInner(restClient().retrofit(), this);
        this.virtualHubs = new VirtualHubsInner(restClient().retrofit(), this);
        this.hubVirtualNetworkConnections = new HubVirtualNetworkConnectionsInner(restClient().retrofit(), this);
        this.vpnGateways = new VpnGatewaysInner(restClient().retrofit(), this);
        this.vpnConnections = new VpnConnectionsInner(restClient().retrofit(), this);
        this.vpnSiteLinkConnections = new VpnSiteLinkConnectionsInner(restClient().retrofit(), this);
        this.vpnLinkConnections = new VpnLinkConnectionsInner(restClient().retrofit(), this);
        this.p2sVpnServerConfigurations = new P2sVpnServerConfigurationsInner(restClient().retrofit(), this);
        this.p2sVpnGateways = new P2sVpnGatewaysInner(restClient().retrofit(), this);
        this.webApplicationFirewallPolicies = new WebApplicationFirewallPoliciesInner(restClient().retrofit(), this);
        this.azureClient = new AzureClient(this);
        initializeService();
    }

    /**
     * Gets the User-Agent header for the client.
     *
     * @return the user agent string.
     */
    @Override
    public String userAgent() {
        return String.format("%s (%s)", super.userAgent(), "NetworkManagementClient");
    }

    private void initializeService() {
        service = restClient().retrofit().create(NetworkManagementClientService.class);
    }

    /**
     * The interface defining all the services for NetworkManagementClient to be
     * used by Retrofit to perform actually REST calls.
     */
    interface NetworkManagementClientService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient checkDnsNameAvailability" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Network/locations/{location}/CheckDnsNameAvailability")
        Observable<Response<ResponseBody>> checkDnsNameAvailability(@Path("location") String location, @Path("subscriptionId") String subscriptionId, @Query("domainNameLabel") String domainNameLabel, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient supportedSecurityProviders" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWANName}/supportedSecurityProviders")
        Observable<Response<ResponseBody>> supportedSecurityProviders(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("virtualWANName") String virtualWANName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Checks whether a domain name in the cloudapp.azure.com zone is available for use.
     *
     * @param location The location of the domain name.
     * @param domainNameLabel The domain name to be verified. It must conform to the following regular expression: ^[a-z][a-z0-9-]{1,61}[a-z0-9]$.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DnsNameAvailabilityResultInner object if successful.
     */
    public DnsNameAvailabilityResultInner checkDnsNameAvailability(String location, String domainNameLabel) {
        return checkDnsNameAvailabilityWithServiceResponseAsync(location, domainNameLabel).toBlocking().single().body();
    }

    /**
     * Checks whether a domain name in the cloudapp.azure.com zone is available for use.
     *
     * @param location The location of the domain name.
     * @param domainNameLabel The domain name to be verified. It must conform to the following regular expression: ^[a-z][a-z0-9-]{1,61}[a-z0-9]$.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DnsNameAvailabilityResultInner> checkDnsNameAvailabilityAsync(String location, String domainNameLabel, final ServiceCallback<DnsNameAvailabilityResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(checkDnsNameAvailabilityWithServiceResponseAsync(location, domainNameLabel), serviceCallback);
    }

    /**
     * Checks whether a domain name in the cloudapp.azure.com zone is available for use.
     *
     * @param location The location of the domain name.
     * @param domainNameLabel The domain name to be verified. It must conform to the following regular expression: ^[a-z][a-z0-9-]{1,61}[a-z0-9]$.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DnsNameAvailabilityResultInner object
     */
    public Observable<DnsNameAvailabilityResultInner> checkDnsNameAvailabilityAsync(String location, String domainNameLabel) {
        return checkDnsNameAvailabilityWithServiceResponseAsync(location, domainNameLabel).map(new Func1<ServiceResponse<DnsNameAvailabilityResultInner>, DnsNameAvailabilityResultInner>() {
            @Override
            public DnsNameAvailabilityResultInner call(ServiceResponse<DnsNameAvailabilityResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Checks whether a domain name in the cloudapp.azure.com zone is available for use.
     *
     * @param location The location of the domain name.
     * @param domainNameLabel The domain name to be verified. It must conform to the following regular expression: ^[a-z][a-z0-9-]{1,61}[a-z0-9]$.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DnsNameAvailabilityResultInner object
     */
    public Observable<ServiceResponse<DnsNameAvailabilityResultInner>> checkDnsNameAvailabilityWithServiceResponseAsync(String location, String domainNameLabel) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (domainNameLabel == null) {
            throw new IllegalArgumentException("Parameter domainNameLabel is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        return service.checkDnsNameAvailability(location, this.subscriptionId(), domainNameLabel, apiVersion, this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DnsNameAvailabilityResultInner>>>() {
                @Override
                public Observable<ServiceResponse<DnsNameAvailabilityResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DnsNameAvailabilityResultInner> clientResponse = checkDnsNameAvailabilityDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DnsNameAvailabilityResultInner> checkDnsNameAvailabilityDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<DnsNameAvailabilityResultInner, CloudException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<DnsNameAvailabilityResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gives the supported security providers for the virtual wan.
     *
     * @param resourceGroupName The resource group name.
     * @param virtualWANName The name of the VirtualWAN for which supported security providers are needed.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualWanSecurityProvidersInner object if successful.
     */
    public VirtualWanSecurityProvidersInner supportedSecurityProviders(String resourceGroupName, String virtualWANName) {
        return supportedSecurityProvidersWithServiceResponseAsync(resourceGroupName, virtualWANName).toBlocking().single().body();
    }

    /**
     * Gives the supported security providers for the virtual wan.
     *
     * @param resourceGroupName The resource group name.
     * @param virtualWANName The name of the VirtualWAN for which supported security providers are needed.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualWanSecurityProvidersInner> supportedSecurityProvidersAsync(String resourceGroupName, String virtualWANName, final ServiceCallback<VirtualWanSecurityProvidersInner> serviceCallback) {
        return ServiceFuture.fromResponse(supportedSecurityProvidersWithServiceResponseAsync(resourceGroupName, virtualWANName), serviceCallback);
    }

    /**
     * Gives the supported security providers for the virtual wan.
     *
     * @param resourceGroupName The resource group name.
     * @param virtualWANName The name of the VirtualWAN for which supported security providers are needed.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualWanSecurityProvidersInner object
     */
    public Observable<VirtualWanSecurityProvidersInner> supportedSecurityProvidersAsync(String resourceGroupName, String virtualWANName) {
        return supportedSecurityProvidersWithServiceResponseAsync(resourceGroupName, virtualWANName).map(new Func1<ServiceResponse<VirtualWanSecurityProvidersInner>, VirtualWanSecurityProvidersInner>() {
            @Override
            public VirtualWanSecurityProvidersInner call(ServiceResponse<VirtualWanSecurityProvidersInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gives the supported security providers for the virtual wan.
     *
     * @param resourceGroupName The resource group name.
     * @param virtualWANName The name of the VirtualWAN for which supported security providers are needed.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualWanSecurityProvidersInner object
     */
    public Observable<ServiceResponse<VirtualWanSecurityProvidersInner>> supportedSecurityProvidersWithServiceResponseAsync(String resourceGroupName, String virtualWANName) {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        return service.supportedSecurityProviders(this.subscriptionId(), resourceGroupName, virtualWANName, apiVersion, this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualWanSecurityProvidersInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualWanSecurityProvidersInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualWanSecurityProvidersInner> clientResponse = supportedSecurityProvidersDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VirtualWanSecurityProvidersInner> supportedSecurityProvidersDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<VirtualWanSecurityProvidersInner, ErrorException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<VirtualWanSecurityProvidersInner>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

}
