/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.SubResource;

/**
 * Authentication certificates of an application gateway.
 */
@JsonFlatten
public class ApplicationGatewayAuthenticationCertificateInner extends SubResource {
    /**
     * Certificate public data.
     */
    @JsonProperty(value = "properties.data")
    private String data;

    /**
     * Provisioning state of the authentication certificate resource. Possible
     * values are: 'Updating', 'Deleting', and 'Failed'.
     */
    @JsonProperty(value = "properties.provisioningState")
    private String provisioningState;

    /**
     * Name of the authentication certificate that is unique within an
     * Application Gateway.
     */
    @JsonProperty(value = "name")
    private String name;

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    @JsonProperty(value = "etag")
    private String etag;

    /**
     * Type of the resource.
     */
    @JsonProperty(value = "type")
    private String type;

    /**
     * Get certificate public data.
     *
     * @return the data value
     */
    public String data() {
        return this.data;
    }

    /**
     * Set certificate public data.
     *
     * @param data the data value to set
     * @return the ApplicationGatewayAuthenticationCertificateInner object itself.
     */
    public ApplicationGatewayAuthenticationCertificateInner withData(String data) {
        this.data = data;
        return this;
    }

    /**
     * Get provisioning state of the authentication certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
     *
     * @return the provisioningState value
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set provisioning state of the authentication certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
     *
     * @param provisioningState the provisioningState value to set
     * @return the ApplicationGatewayAuthenticationCertificateInner object itself.
     */
    public ApplicationGatewayAuthenticationCertificateInner withProvisioningState(String provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Get name of the authentication certificate that is unique within an Application Gateway.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set name of the authentication certificate that is unique within an Application Gateway.
     *
     * @param name the name value to set
     * @return the ApplicationGatewayAuthenticationCertificateInner object itself.
     */
    public ApplicationGatewayAuthenticationCertificateInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get a unique read-only string that changes whenever the resource is updated.
     *
     * @return the etag value
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Set a unique read-only string that changes whenever the resource is updated.
     *
     * @param etag the etag value to set
     * @return the ApplicationGatewayAuthenticationCertificateInner object itself.
     */
    public ApplicationGatewayAuthenticationCertificateInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    /**
     * Get type of the resource.
     *
     * @return the type value
     */
    public String type() {
        return this.type;
    }

    /**
     * Set type of the resource.
     *
     * @param type the type value to set
     * @return the ApplicationGatewayAuthenticationCertificateInner object itself.
     */
    public ApplicationGatewayAuthenticationCertificateInner withType(String type) {
        this.type = type;
        return this;
    }

}
