/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.PatchRouteFilterInner;
import com.microsoft.azure.management.network.implementation.RouteFilterInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class RouteFiltersInner
implements InnerSupportsGet<RouteFilterInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<RouteFilterInner> {
    private RouteFiltersService service;
    private NetworkManagementClientImpl client;

    public RouteFiltersInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (RouteFiltersService)retrofit.create(RouteFiltersService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String routeFilterName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, routeFilterName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String routeFilterName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, routeFilterName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String routeFilterName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, routeFilterName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String routeFilterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (routeFilterName == null) {
            throw new IllegalArgumentException("Parameter routeFilterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-12-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, routeFilterName, this.client.subscriptionId(), "2016-12-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String routeFilterName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, routeFilterName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String routeFilterName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, routeFilterName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String routeFilterName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, routeFilterName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String routeFilterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (routeFilterName == null) {
            throw new IllegalArgumentException("Parameter routeFilterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-12-01";
        return this.service.beginDelete(resourceGroupName, routeFilterName, this.client.subscriptionId(), "2016-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RouteFiltersInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RouteFilterInner getByResourceGroup(String resourceGroupName, String routeFilterName) {
        return (RouteFilterInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, routeFilterName).toBlocking().single()).body());
    }

    public ServiceFuture<RouteFilterInner> getByResourceGroupAsync(String resourceGroupName, String routeFilterName, ServiceCallback<RouteFilterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, routeFilterName), serviceCallback);
    }

    public Observable<RouteFilterInner> getByResourceGroupAsync(String resourceGroupName, String routeFilterName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, routeFilterName).map((Func1)new Func1<ServiceResponse<RouteFilterInner>, RouteFilterInner>(){

            public RouteFilterInner call(ServiceResponse<RouteFilterInner> response) {
                return (RouteFilterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RouteFilterInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String routeFilterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (routeFilterName == null) {
            throw new IllegalArgumentException("Parameter routeFilterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-12-01";
        String expand = null;
        return this.service.getByResourceGroup(resourceGroupName, routeFilterName, this.client.subscriptionId(), "2016-12-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RouteFilterInner>>>(){

            public Observable<ServiceResponse<RouteFilterInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RouteFiltersInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public RouteFilterInner getByResourceGroup(String resourceGroupName, String routeFilterName, String expand) {
        return (RouteFilterInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, routeFilterName, expand).toBlocking().single()).body());
    }

    public ServiceFuture<RouteFilterInner> getByResourceGroupAsync(String resourceGroupName, String routeFilterName, String expand, ServiceCallback<RouteFilterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, routeFilterName, expand), serviceCallback);
    }

    public Observable<RouteFilterInner> getByResourceGroupAsync(String resourceGroupName, String routeFilterName, String expand) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, routeFilterName, expand).map((Func1)new Func1<ServiceResponse<RouteFilterInner>, RouteFilterInner>(){

            public RouteFilterInner call(ServiceResponse<RouteFilterInner> response) {
                return (RouteFilterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RouteFilterInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String routeFilterName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (routeFilterName == null) {
            throw new IllegalArgumentException("Parameter routeFilterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-12-01";
        return this.service.getByResourceGroup(resourceGroupName, routeFilterName, this.client.subscriptionId(), "2016-12-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RouteFilterInner>>>(){

            public Observable<ServiceResponse<RouteFilterInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RouteFiltersInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RouteFilterInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RouteFilterInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RouteFilterInner createOrUpdate(String resourceGroupName, String routeFilterName, RouteFilterInner routeFilterParameters) {
        return (RouteFilterInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, routeFilterName, routeFilterParameters).toBlocking().last()).body());
    }

    public ServiceFuture<RouteFilterInner> createOrUpdateAsync(String resourceGroupName, String routeFilterName, RouteFilterInner routeFilterParameters, ServiceCallback<RouteFilterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, routeFilterName, routeFilterParameters), serviceCallback);
    }

    public Observable<RouteFilterInner> createOrUpdateAsync(String resourceGroupName, String routeFilterName, RouteFilterInner routeFilterParameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, routeFilterName, routeFilterParameters).map((Func1)new Func1<ServiceResponse<RouteFilterInner>, RouteFilterInner>(){

            public RouteFilterInner call(ServiceResponse<RouteFilterInner> response) {
                return (RouteFilterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RouteFilterInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String routeFilterName, RouteFilterInner routeFilterParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (routeFilterName == null) {
            throw new IllegalArgumentException("Parameter routeFilterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (routeFilterParameters == null) {
            throw new IllegalArgumentException("Parameter routeFilterParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)routeFilterParameters));
        String apiVersion = "2016-12-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, routeFilterName, this.client.subscriptionId(), routeFilterParameters, "2016-12-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<RouteFilterInner>(){}.getType());
    }

    public RouteFilterInner beginCreateOrUpdate(String resourceGroupName, String routeFilterName, RouteFilterInner routeFilterParameters) {
        return (RouteFilterInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, routeFilterName, routeFilterParameters).toBlocking().single()).body());
    }

    public ServiceFuture<RouteFilterInner> beginCreateOrUpdateAsync(String resourceGroupName, String routeFilterName, RouteFilterInner routeFilterParameters, ServiceCallback<RouteFilterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, routeFilterName, routeFilterParameters), serviceCallback);
    }

    public Observable<RouteFilterInner> beginCreateOrUpdateAsync(String resourceGroupName, String routeFilterName, RouteFilterInner routeFilterParameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, routeFilterName, routeFilterParameters).map((Func1)new Func1<ServiceResponse<RouteFilterInner>, RouteFilterInner>(){

            public RouteFilterInner call(ServiceResponse<RouteFilterInner> response) {
                return (RouteFilterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RouteFilterInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String routeFilterName, RouteFilterInner routeFilterParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (routeFilterName == null) {
            throw new IllegalArgumentException("Parameter routeFilterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (routeFilterParameters == null) {
            throw new IllegalArgumentException("Parameter routeFilterParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)routeFilterParameters));
        String apiVersion = "2016-12-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, routeFilterName, this.client.subscriptionId(), routeFilterParameters, "2016-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RouteFilterInner>>>(){

            public Observable<ServiceResponse<RouteFilterInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RouteFiltersInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RouteFilterInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RouteFilterInner>(){}.getType()).register(201, new TypeToken<RouteFilterInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RouteFilterInner update(String resourceGroupName, String routeFilterName, PatchRouteFilterInner routeFilterParameters) {
        return (RouteFilterInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, routeFilterName, routeFilterParameters).toBlocking().last()).body());
    }

    public ServiceFuture<RouteFilterInner> updateAsync(String resourceGroupName, String routeFilterName, PatchRouteFilterInner routeFilterParameters, ServiceCallback<RouteFilterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, routeFilterName, routeFilterParameters), serviceCallback);
    }

    public Observable<RouteFilterInner> updateAsync(String resourceGroupName, String routeFilterName, PatchRouteFilterInner routeFilterParameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, routeFilterName, routeFilterParameters).map((Func1)new Func1<ServiceResponse<RouteFilterInner>, RouteFilterInner>(){

            public RouteFilterInner call(ServiceResponse<RouteFilterInner> response) {
                return (RouteFilterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RouteFilterInner>> updateWithServiceResponseAsync(String resourceGroupName, String routeFilterName, PatchRouteFilterInner routeFilterParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (routeFilterName == null) {
            throw new IllegalArgumentException("Parameter routeFilterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (routeFilterParameters == null) {
            throw new IllegalArgumentException("Parameter routeFilterParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)routeFilterParameters));
        String apiVersion = "2016-12-01";
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, routeFilterName, this.client.subscriptionId(), routeFilterParameters, "2016-12-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<RouteFilterInner>(){}.getType());
    }

    public RouteFilterInner beginUpdate(String resourceGroupName, String routeFilterName, PatchRouteFilterInner routeFilterParameters) {
        return (RouteFilterInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, routeFilterName, routeFilterParameters).toBlocking().single()).body());
    }

    public ServiceFuture<RouteFilterInner> beginUpdateAsync(String resourceGroupName, String routeFilterName, PatchRouteFilterInner routeFilterParameters, ServiceCallback<RouteFilterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, routeFilterName, routeFilterParameters), serviceCallback);
    }

    public Observable<RouteFilterInner> beginUpdateAsync(String resourceGroupName, String routeFilterName, PatchRouteFilterInner routeFilterParameters) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, routeFilterName, routeFilterParameters).map((Func1)new Func1<ServiceResponse<RouteFilterInner>, RouteFilterInner>(){

            public RouteFilterInner call(ServiceResponse<RouteFilterInner> response) {
                return (RouteFilterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RouteFilterInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String routeFilterName, PatchRouteFilterInner routeFilterParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (routeFilterName == null) {
            throw new IllegalArgumentException("Parameter routeFilterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (routeFilterParameters == null) {
            throw new IllegalArgumentException("Parameter routeFilterParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)routeFilterParameters));
        String apiVersion = "2016-12-01";
        return this.service.beginUpdate(resourceGroupName, routeFilterName, this.client.subscriptionId(), routeFilterParameters, "2016-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RouteFilterInner>>>(){

            public Observable<ServiceResponse<RouteFilterInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RouteFiltersInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RouteFilterInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RouteFilterInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RouteFilterInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<RouteFilterInner>((Page)response.body()){

            public Page<RouteFilterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RouteFiltersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RouteFilterInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<RouteFilterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<RouteFilterInner>>>>(){

            public Observable<ServiceResponse<Page<RouteFilterInner>>> call(String nextPageLink) {
                return RouteFiltersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RouteFilterInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<RouteFilterInner>>, Page<RouteFilterInner>>(){

            public Page<RouteFilterInner> call(ServiceResponse<Page<RouteFilterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RouteFilterInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<RouteFilterInner>>, Observable<ServiceResponse<Page<RouteFilterInner>>>>(){

            public Observable<ServiceResponse<Page<RouteFilterInner>>> call(ServiceResponse<Page<RouteFilterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RouteFiltersInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RouteFilterInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-12-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2016-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RouteFilterInner>>>>(){

            public Observable<ServiceResponse<Page<RouteFilterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RouteFiltersInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RouteFilterInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RouteFilterInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RouteFilterInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<RouteFilterInner>((Page)response.body()){

            public Page<RouteFilterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RouteFiltersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RouteFilterInner>> listAsync(ListOperationCallback<RouteFilterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<RouteFilterInner>>>>(){

            public Observable<ServiceResponse<Page<RouteFilterInner>>> call(String nextPageLink) {
                return RouteFiltersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RouteFilterInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<RouteFilterInner>>, Page<RouteFilterInner>>(){

            public Page<RouteFilterInner> call(ServiceResponse<Page<RouteFilterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RouteFilterInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<RouteFilterInner>>, Observable<ServiceResponse<Page<RouteFilterInner>>>>(){

            public Observable<ServiceResponse<Page<RouteFilterInner>>> call(ServiceResponse<Page<RouteFilterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RouteFiltersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RouteFilterInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-12-01";
        return this.service.list(this.client.subscriptionId(), "2016-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RouteFilterInner>>>>(){

            public Observable<ServiceResponse<Page<RouteFilterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RouteFiltersInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RouteFilterInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RouteFilterInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RouteFilterInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RouteFilterInner>((Page)response.body()){

            public Page<RouteFilterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RouteFiltersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RouteFilterInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<RouteFilterInner>> serviceFuture, ListOperationCallback<RouteFilterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RouteFilterInner>>>>(){

            public Observable<ServiceResponse<Page<RouteFilterInner>>> call(String nextPageLink) {
                return RouteFiltersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RouteFilterInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RouteFilterInner>>, Page<RouteFilterInner>>(){

            public Page<RouteFilterInner> call(ServiceResponse<Page<RouteFilterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RouteFilterInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RouteFilterInner>>, Observable<ServiceResponse<Page<RouteFilterInner>>>>(){

            public Observable<ServiceResponse<Page<RouteFilterInner>>> call(ServiceResponse<Page<RouteFilterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RouteFiltersInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RouteFilterInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RouteFilterInner>>>>(){

            public Observable<ServiceResponse<Page<RouteFilterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RouteFiltersInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RouteFilterInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RouteFilterInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RouteFilterInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RouteFilterInner>((Page)response.body()){

            public Page<RouteFilterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RouteFiltersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RouteFilterInner>> listNextAsync(String nextPageLink, ServiceFuture<List<RouteFilterInner>> serviceFuture, ListOperationCallback<RouteFilterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RouteFilterInner>>>>(){

            public Observable<ServiceResponse<Page<RouteFilterInner>>> call(String nextPageLink) {
                return RouteFiltersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RouteFilterInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RouteFilterInner>>, Page<RouteFilterInner>>(){

            public Page<RouteFilterInner> call(ServiceResponse<Page<RouteFilterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RouteFilterInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RouteFilterInner>>, Observable<ServiceResponse<Page<RouteFilterInner>>>>(){

            public Observable<ServiceResponse<Page<RouteFilterInner>>> call(ServiceResponse<Page<RouteFilterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RouteFiltersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RouteFilterInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RouteFilterInner>>>>(){

            public Observable<ServiceResponse<Page<RouteFilterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RouteFiltersInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RouteFilterInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RouteFilterInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface RouteFiltersService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.RouteFilters delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="routeFilterName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.RouteFilters beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="routeFilterName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.RouteFilters getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="routeFilterName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Query(value="$expand") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.RouteFilters createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="routeFilterName") String var2, @Path(value="subscriptionId") String var3, @Body RouteFilterInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.RouteFilters beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="routeFilterName") String var2, @Path(value="subscriptionId") String var3, @Body RouteFilterInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.RouteFilters update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="routeFilterName") String var2, @Path(value="subscriptionId") String var3, @Body PatchRouteFilterInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.RouteFilters beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="routeFilterName") String var2, @Path(value="subscriptionId") String var3, @Body PatchRouteFilterInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.RouteFilters listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.RouteFilters list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/routeFilters")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.RouteFilters listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.RouteFilters listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

