/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.network.ApplicationGatewayBackend;
import com.microsoft.azure.management.network.ApplicationGatewayBackendHttpConfiguration;
import com.microsoft.azure.management.network.ApplicationGatewayFrontend;
import com.microsoft.azure.management.network.ApplicationGatewayIPConfiguration;
import com.microsoft.azure.management.network.ApplicationGatewayListener;
import com.microsoft.azure.management.network.ApplicationGatewayOperationalState;
import com.microsoft.azure.management.network.ApplicationGatewayProbe;
import com.microsoft.azure.management.network.ApplicationGatewayRequestRoutingRule;
import com.microsoft.azure.management.network.ApplicationGatewaySku;
import com.microsoft.azure.management.network.ApplicationGatewaySkuName;
import com.microsoft.azure.management.network.ApplicationGatewaySslCertificate;
import com.microsoft.azure.management.network.ApplicationGatewaySslProtocol;
import com.microsoft.azure.management.network.ApplicationGatewayTier;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.Subnet;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayInner;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.model.HasPrivateIPAddress;
import com.microsoft.azure.management.network.model.HasPublicIPAddress;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasSubnet;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.Collection;
import java.util.Map;
import rx.Completable;

@Fluent
public interface ApplicationGateway
extends GroupableResource<NetworkManager, ApplicationGatewayInner>,
Refreshable<ApplicationGateway>,
Updatable<Update>,
HasSubnet,
HasPrivateIPAddress {
    @Method
    public void start();

    @Method
    public void stop();

    @Method
    public Completable startAsync();

    @Method
    public Completable stopAsync();

    @Beta(value=Beta.SinceVersion.V1_1_0)
    public Collection<ApplicationGatewaySslProtocol> disabledSslProtocols();

    public boolean isPrivate();

    public boolean isPublic();

    public ApplicationGatewayFrontend defaultPublicFrontend();

    public ApplicationGatewayFrontend defaultPrivateFrontend();

    public ApplicationGatewaySku sku();

    public int instanceCount();

    public ApplicationGatewaySkuName size();

    public ApplicationGatewayTier tier();

    public ApplicationGatewayOperationalState operationalState();

    public Map<String, ApplicationGatewayIPConfiguration> ipConfigurations();

    public Map<String, ApplicationGatewayBackend> backends();

    public Map<String, ApplicationGatewayProbe> probes();

    public ApplicationGatewayIPConfiguration defaultIPConfiguration();

    public Map<String, ApplicationGatewayFrontend> frontends();

    public Map<String, ApplicationGatewayFrontend> publicFrontends();

    public Map<String, ApplicationGatewayFrontend> privateFrontends();

    public Map<String, Integer> frontendPorts();

    public Map<String, ApplicationGatewayBackendHttpConfiguration> backendHttpConfigurations();

    public Map<String, ApplicationGatewaySslCertificate> sslCertificates();

    public Map<String, ApplicationGatewayListener> listeners();

    public Map<String, ApplicationGatewayRequestRoutingRule> requestRoutingRules();

    public String frontendPortNameFromNumber(int var1);

    public ApplicationGatewayListener listenerByPortNumber(int var1);

    public static interface Update
    extends Appliable<ApplicationGateway>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithSize,
    UpdateStages.WithInstanceCount,
    UpdateStages.WithBackend,
    UpdateStages.WithBackendHttpConfig,
    UpdateStages.WithIPConfig,
    UpdateStages.WithFrontend,
    UpdateStages.WithPublicIPAddress,
    UpdateStages.WithFrontendPort,
    UpdateStages.WithSslCert,
    UpdateStages.WithListener,
    UpdateStages.WithRequestRoutingRule,
    UpdateStages.WithExistingSubnet,
    UpdateStages.WithProbe,
    UpdateStages.WithDisabledSslProtocol {
    }

    public static interface UpdateStages {

        public static interface WithDisabledSslProtocol {
            @Beta(value=Beta.SinceVersion.V1_1_0)
            public Update withDisabledSslProtocol(ApplicationGatewaySslProtocol var1);

            @Beta(value=Beta.SinceVersion.V1_1_0)
            public Update withDisabledSslProtocols(ApplicationGatewaySslProtocol ... var1);

            @Beta(value=Beta.SinceVersion.V1_1_0)
            public Update withoutDisabledSslProtocol(ApplicationGatewaySslProtocol var1);

            @Beta(value=Beta.SinceVersion.V1_1_0)
            public Update withoutDisabledSslProtocols(ApplicationGatewaySslProtocol ... var1);

            @Beta(value=Beta.SinceVersion.V1_1_0)
            @Method
            public Update withoutAnyDisabledSslProtocols();
        }

        public static interface WithRequestRoutingRule {
            public ApplicationGatewayRequestRoutingRule.UpdateDefinitionStages.Blank<Update> defineRequestRoutingRule(String var1);

            public Update withoutRequestRoutingRule(String var1);

            public ApplicationGatewayRequestRoutingRule.Update updateRequestRoutingRule(String var1);
        }

        public static interface WithBackendHttpConfig {
            public ApplicationGatewayBackendHttpConfiguration.UpdateDefinitionStages.Blank<Update> defineBackendHttpConfiguration(String var1);

            public Update withoutBackendHttpConfiguration(String var1);

            public ApplicationGatewayBackendHttpConfiguration.Update updateBackendHttpConfiguration(String var1);
        }

        public static interface WithListener {
            public ApplicationGatewayListener.UpdateDefinitionStages.Blank<Update> defineListener(String var1);

            public Update withoutListener(String var1);

            public ApplicationGatewayListener.Update updateListener(String var1);
        }

        public static interface WithSslCert {
            public ApplicationGatewaySslCertificate.UpdateDefinitionStages.Blank<Update> defineSslCertificate(String var1);

            public Update withoutCertificate(String var1);
        }

        public static interface WithInstanceCount {
            public Update withInstanceCount(int var1);
        }

        public static interface WithSize {
            public Update withSize(ApplicationGatewaySkuName var1);
        }

        public static interface WithProbe {
            public ApplicationGatewayProbe.UpdateDefinitionStages.Blank<Update> defineProbe(String var1);

            public ApplicationGatewayProbe.Update updateProbe(String var1);

            public Update withoutProbe(String var1);
        }

        public static interface WithBackend {
            public ApplicationGatewayBackend.UpdateDefinitionStages.Blank<Update> defineBackend(String var1);

            public Update withoutBackendFqdn(String var1);

            public Update withoutBackendIPAddress(String var1);

            public Update withoutBackend(String var1);

            public ApplicationGatewayBackend.Update updateBackend(String var1);
        }

        public static interface WithFrontend {
            public Update withoutFrontend(String var1);

            public ApplicationGatewayFrontend.Update updateFrontend(String var1);

            @Method
            public Update withoutPublicFrontend();

            @Method
            public Update withoutPrivateFrontend();

            @Method
            public ApplicationGatewayFrontend.Update updatePublicFrontend();

            @Method
            public ApplicationGatewayFrontend.UpdateDefinitionStages.Blank<Update> definePublicFrontend();

            @Method
            public ApplicationGatewayFrontend.UpdateDefinitionStages.Blank<Update> definePrivateFrontend();
        }

        public static interface WithPublicIPAddress
        extends HasPublicIPAddress.UpdateStages.WithPublicIPAddressNoDnsLabel<Update> {
        }

        public static interface WithFrontendPort {
            public Update withFrontendPort(int var1);

            public Update withFrontendPort(int var1, String var2);

            public Update withoutFrontendPort(String var1);

            public Update withoutFrontendPort(int var1);
        }

        public static interface WithIPConfig {
            public Update withoutIPConfiguration(String var1);

            public ApplicationGatewayIPConfiguration.Update updateIPConfiguration(String var1);

            @Method
            public ApplicationGatewayIPConfiguration.Update updateDefaultIPConfiguration();

            @Method
            public ApplicationGatewayIPConfiguration.UpdateDefinitionStages.Blank<Update> defineDefaultIPConfiguration();
        }

        public static interface WithExistingSubnet
        extends HasSubnet.UpdateStages.WithSubnet<Update> {
            public Update withExistingSubnet(Subnet var1);

            public Update withExistingSubnet(Network var1, String var2);
        }

        public static interface WithPrivateFrontend {
            @Method
            public Update withPrivateFrontend();

            @Method
            public Update withoutPrivateFrontend();
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<ApplicationGateway>,
        Resource.DefinitionWithTags<WithCreate>,
        WithSize,
        WithInstanceCount,
        WithSslCert,
        WithFrontendPort,
        WithListener,
        WithBackendHttpConfig,
        WithBackend,
        WithExistingSubnet,
        WithPrivateIPAddress,
        WithPrivateFrontend,
        WithPublicFrontend,
        WithPublicIPAddress,
        WithProbe,
        WithDisabledSslProtocol {
        }

        public static interface WithDisabledSslProtocol {
            @Beta(value=Beta.SinceVersion.V1_1_0)
            public WithCreate withDisabledSslProtocol(ApplicationGatewaySslProtocol var1);

            @Beta(value=Beta.SinceVersion.V1_1_0)
            public WithCreate withDisabledSslProtocols(ApplicationGatewaySslProtocol ... var1);
        }

        public static interface WithPrivateIPAddress
        extends HasPrivateIPAddress.DefinitionStages.WithPrivateIPAddress<WithCreate> {
        }

        public static interface WithExistingSubnet
        extends HasSubnet.DefinitionStages.WithSubnet<WithCreate> {
            public WithCreate withExistingSubnet(Subnet var1);

            public WithCreate withExistingSubnet(Network var1, String var2);
        }

        public static interface WithInstanceCount {
            public WithCreate withInstanceCount(int var1);
        }

        public static interface WithSize {
            public WithCreate withSize(ApplicationGatewaySkuName var1);
        }

        public static interface WithRequestRoutingRuleOrCreate
        extends WithRequestRoutingRule,
        WithCreate {
        }

        public static interface WithRequestRoutingRule {
            public ApplicationGatewayRequestRoutingRule.DefinitionStages.Blank<WithRequestRoutingRuleOrCreate> defineRequestRoutingRule(String var1);
        }

        public static interface WithBackendHttpConfig {
            public ApplicationGatewayBackendHttpConfiguration.DefinitionStages.Blank<WithCreate> defineBackendHttpConfiguration(String var1);
        }

        public static interface WithBackend {
            public ApplicationGatewayBackend.DefinitionStages.Blank<WithCreate> defineBackend(String var1);
        }

        public static interface WithSslCert {
            public ApplicationGatewaySslCertificate.DefinitionStages.Blank<WithCreate> defineSslCertificate(String var1);
        }

        public static interface WithFrontendPort {
            public WithCreate withFrontendPort(int var1);

            public WithCreate withFrontendPort(int var1, String var2);
        }

        public static interface WithProbe {
            public ApplicationGatewayProbe.DefinitionStages.Blank<WithCreate> defineProbe(String var1);
        }

        public static interface WithListener {
            public ApplicationGatewayListener.DefinitionStages.Blank<WithCreate> defineListener(String var1);
        }

        public static interface WithPrivateFrontend {
            @Method
            public WithCreate withPrivateFrontend();

            @Method
            public WithCreate withoutPrivateFrontend();
        }

        public static interface WithPublicFrontend
        extends WithPublicIPAddress {
            @Method
            public WithCreate withoutPublicFrontend();
        }

        public static interface WithPublicIPAddress
        extends HasPublicIPAddress.DefinitionStages.WithPublicIPAddressNoDnsLabel<WithCreate> {
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithRequestRoutingRule> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithCreate,
    DefinitionStages.WithRequestRoutingRule,
    DefinitionStages.WithRequestRoutingRuleOrCreate {
    }
}

