/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import java.util.List;
import com.microsoft.azure.management.network.BGPCommunity;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.Resource;

/**
 * Service Community Properties.
 */
@JsonFlatten
public class BgpServiceCommunityInner extends Resource {
    /**
     * Get a list of bgp communities.
     */
    @JsonProperty(value = "properties.communities")
    private List<BGPCommunity> communities;

    /**
     * Get the communities value.
     *
     * @return the communities value
     */
    public List<BGPCommunity> communities() {
        return this.communities;
    }

    /**
     * Set the communities value.
     *
     * @param communities the communities value to set
     * @return the BgpServiceCommunityInner object itself.
     */
    public BgpServiceCommunityInner withCommunities(List<BGPCommunity> communities) {
        this.communities = communities;
        return this;
    }

}
