/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for Protocol.
 */
public final class Protocol {
    /** Static value TCP for Protocol. */
    public static final Protocol TCP = new Protocol("TCP");

    /** Static value UDP for Protocol. */
    public static final Protocol UDP = new Protocol("UDP");

    private String value;

    /**
     * Creates a custom value for Protocol.
     * @param value the custom value
     */
    public Protocol(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Protocol)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Protocol rhs = (Protocol) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
