/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for ExpressRouteCircuitSkuTier.
 */
public final class ExpressRouteCircuitSkuTier {
    /** Static value Standard for ExpressRouteCircuitSkuTier. */
    public static final ExpressRouteCircuitSkuTier STANDARD = new ExpressRouteCircuitSkuTier("Standard");

    /** Static value Premium for ExpressRouteCircuitSkuTier. */
    public static final ExpressRouteCircuitSkuTier PREMIUM = new ExpressRouteCircuitSkuTier("Premium");

    private String value;

    /**
     * Creates a custom value for ExpressRouteCircuitSkuTier.
     * @param value the custom value
     */
    public ExpressRouteCircuitSkuTier(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ExpressRouteCircuitSkuTier)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ExpressRouteCircuitSkuTier rhs = (ExpressRouteCircuitSkuTier) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
