/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for EffectiveRouteSource.
 */
public final class EffectiveRouteSource {
    /** Static value Unknown for EffectiveRouteSource. */
    public static final EffectiveRouteSource UNKNOWN = new EffectiveRouteSource("Unknown");

    /** Static value User for EffectiveRouteSource. */
    public static final EffectiveRouteSource USER = new EffectiveRouteSource("User");

    /** Static value VirtualNetworkGateway for EffectiveRouteSource. */
    public static final EffectiveRouteSource VIRTUAL_NETWORK_GATEWAY = new EffectiveRouteSource("VirtualNetworkGateway");

    /** Static value Default for EffectiveRouteSource. */
    public static final EffectiveRouteSource DEFAULT = new EffectiveRouteSource("Default");

    private String value;

    /**
     * Creates a custom value for EffectiveRouteSource.
     * @param value the custom value
     */
    public EffectiveRouteSource(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof EffectiveRouteSource)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        EffectiveRouteSource rhs = (EffectiveRouteSource) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
