/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for BgpPeerState.
 */
public final class BgpPeerState {
    /** Static value Unknown for BgpPeerState. */
    public static final BgpPeerState UNKNOWN = new BgpPeerState("Unknown");

    /** Static value Stopped for BgpPeerState. */
    public static final BgpPeerState STOPPED = new BgpPeerState("Stopped");

    /** Static value Idle for BgpPeerState. */
    public static final BgpPeerState IDLE = new BgpPeerState("Idle");

    /** Static value Connecting for BgpPeerState. */
    public static final BgpPeerState CONNECTING = new BgpPeerState("Connecting");

    /** Static value Connected for BgpPeerState. */
    public static final BgpPeerState CONNECTED = new BgpPeerState("Connected");

    private String value;

    /**
     * Creates a custom value for BgpPeerState.
     * @param value the custom value
     */
    public BgpPeerState(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BgpPeerState)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        BgpPeerState rhs = (BgpPeerState) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
