/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor;

import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.LangMethodDefinition;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.monitor.AutoscaleProfile;
import com.microsoft.azure.management.monitor.implementation.AutoscaleSettingResourceInner;
import com.microsoft.azure.management.monitor.implementation.MonitorManager;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.List;
import java.util.Map;

@Fluent
public interface AutoscaleSetting
extends GroupableResource<MonitorManager, AutoscaleSettingResourceInner>,
Refreshable<AutoscaleSetting>,
Updatable<Update> {
    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public String targetResourceId();

    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public Map<String, AutoscaleProfile> profiles();

    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public boolean autoscaleEnabled();

    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public boolean adminEmailNotificationEnabled();

    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public boolean coAdminEmailNotificationEnabled();

    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public List<String> customEmailsNotification();

    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public String webhookNotification();

    public static interface Update
    extends Appliable<AutoscaleSetting>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.DefineAutoscaleSettingProfiles,
    UpdateStages.UpdateAutoscaleSettings {
    }

    public static interface UpdateStages {

        public static interface UpdateAutoscaleSettings {
            @Method
            public Update withAutoscaleEnabled();

            @Method
            public Update withAutoscaleDisabled();

            @Method
            public Update withAdminEmailNotification();

            @Method
            public Update withCoAdminEmailNotification();

            public Update withCustomEmailsNotification(String ... var1);

            public Update withWebhookNotification(String var1);

            @Method
            public Update withoutAdminEmailNotification();

            @Method
            public Update withoutCoAdminEmailNotification();

            @Method
            public Update withoutCustomEmailsNotification();

            @Method
            public Update withoutWebhookNotification();
        }

        public static interface DefineAutoscaleSettingProfiles {
            public AutoscaleProfile.UpdateDefinitionStages.Blank defineAutoscaleProfile(String var1);

            public AutoscaleProfile.Update updateAutoscaleProfile(String var1);

            public Update withoutAutoscaleProfile(String var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<AutoscaleSetting>,
        DefineAutoscaleSettingResourceProfiles,
        DefineAutoscaleSettingResourceNotifications,
        WithAutoscaleSettingResourceEnabled {
        }

        public static interface WithAutoscaleSettingResourceEnabled {
            @Method
            public WithCreate withAutoscaleDisabled();
        }

        public static interface DefineAutoscaleSettingResourceNotifications {
            @Method
            public WithCreate withAdminEmailNotification();

            @Method
            public WithCreate withCoAdminEmailNotification();

            public WithCreate withCustomEmailsNotification(String ... var1);

            public WithCreate withWebhookNotification(String var1);
        }

        public static interface DefineAutoscaleSettingResourceProfiles {
            public AutoscaleProfile.DefinitionStages.Blank defineAutoscaleProfile(String var1);
        }

        public static interface WithAutoscaleSettingResourceTargetResourceUri {
            public DefineAutoscaleSettingResourceProfiles withTargetResource(String var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithAutoscaleSettingResourceTargetResourceUri> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithCreate,
    DefinitionStages.DefineAutoscaleSettingResourceProfiles,
    DefinitionStages.WithAutoscaleSettingResourceTargetResourceUri,
    DefinitionStages.WithAutoscaleSettingResourceEnabled {
    }
}

