/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.datalake.analytics.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.datalake.analytics.StorageAccounts;
import com.microsoft.azure.management.datalake.analytics.implementation.DataLakeAnalyticsAccountManagementClientImpl;
import com.microsoft.azure.management.datalake.analytics.models.AddStorageAccountParameters;
import com.microsoft.azure.management.datalake.analytics.models.PageImpl;
import com.microsoft.azure.management.datalake.analytics.models.SasTokenInformation;
import com.microsoft.azure.management.datalake.analytics.models.StorageAccountInformation;
import com.microsoft.azure.management.datalake.analytics.models.StorageContainer;
import com.microsoft.azure.management.datalake.analytics.models.UpdateStorageAccountParameters;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class StorageAccountsImpl
implements StorageAccounts {
    private StorageAccountsService service;
    private DataLakeAnalyticsAccountManagementClientImpl client;

    public StorageAccountsImpl(Retrofit retrofit, DataLakeAnalyticsAccountManagementClientImpl client) {
        this.service = (StorageAccountsService)retrofit.create(StorageAccountsService.class);
        this.client = client;
    }

    @Override
    public PagedList<StorageAccountInformation> listByAccount(String resourceGroupName, String accountName) {
        ServiceResponse response = (ServiceResponse)this.listByAccountSinglePageAsync(resourceGroupName, accountName).toBlocking().single();
        return new PagedList<StorageAccountInformation>((Page)response.body()){

            public Page<StorageAccountInformation> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)StorageAccountsImpl.this.listByAccountNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<StorageAccountInformation>> listByAccountAsync(String resourceGroupName, String accountName, ListOperationCallback<StorageAccountInformation> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByAccountSinglePageAsync(resourceGroupName, accountName), (Func1)new Func1<String, Observable<ServiceResponse<Page<StorageAccountInformation>>>>(){

            public Observable<ServiceResponse<Page<StorageAccountInformation>>> call(String nextPageLink) {
                return StorageAccountsImpl.this.listByAccountNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<StorageAccountInformation>> listByAccountAsync(String resourceGroupName, String accountName) {
        return this.listByAccountWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Page<StorageAccountInformation>>, Page<StorageAccountInformation>>(){

            public Page<StorageAccountInformation> call(ServiceResponse<Page<StorageAccountInformation>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<StorageAccountInformation>>> listByAccountWithServiceResponseAsync(String resourceGroupName, String accountName) {
        return this.listByAccountSinglePageAsync(resourceGroupName, accountName).concatMap((Func1)new Func1<ServiceResponse<Page<StorageAccountInformation>>, Observable<ServiceResponse<Page<StorageAccountInformation>>>>(){

            public Observable<ServiceResponse<Page<StorageAccountInformation>>> call(ServiceResponse<Page<StorageAccountInformation>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(StorageAccountsImpl.this.listByAccountNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<StorageAccountInformation>>> listByAccountSinglePageAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        return this.service.listByAccount(this.client.subscriptionId(), resourceGroupName, accountName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<StorageAccountInformation>>>>(){

            public Observable<ServiceResponse<Page<StorageAccountInformation>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = StorageAccountsImpl.this.listByAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<StorageAccountInformation> listByAccount(String resourceGroupName, String accountName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        ServiceResponse response = (ServiceResponse)this.listByAccountSinglePageAsync(resourceGroupName, accountName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<StorageAccountInformation>((Page)response.body()){

            public Page<StorageAccountInformation> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)StorageAccountsImpl.this.listByAccountNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<StorageAccountInformation>> listByAccountAsync(String resourceGroupName, String accountName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, ListOperationCallback<StorageAccountInformation> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByAccountSinglePageAsync(resourceGroupName, accountName, filter, top, skip, select, orderby, count), (Func1)new Func1<String, Observable<ServiceResponse<Page<StorageAccountInformation>>>>(){

            public Observable<ServiceResponse<Page<StorageAccountInformation>>> call(String nextPageLink) {
                return StorageAccountsImpl.this.listByAccountNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<StorageAccountInformation>> listByAccountAsync(String resourceGroupName, String accountName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listByAccountWithServiceResponseAsync(resourceGroupName, accountName, filter, top, skip, select, orderby, count).map((Func1)new Func1<ServiceResponse<Page<StorageAccountInformation>>, Page<StorageAccountInformation>>(){

            public Page<StorageAccountInformation> call(ServiceResponse<Page<StorageAccountInformation>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<StorageAccountInformation>>> listByAccountWithServiceResponseAsync(String resourceGroupName, String accountName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listByAccountSinglePageAsync(resourceGroupName, accountName, filter, top, skip, select, orderby, count).concatMap((Func1)new Func1<ServiceResponse<Page<StorageAccountInformation>>, Observable<ServiceResponse<Page<StorageAccountInformation>>>>(){

            public Observable<ServiceResponse<Page<StorageAccountInformation>>> call(ServiceResponse<Page<StorageAccountInformation>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(StorageAccountsImpl.this.listByAccountNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<StorageAccountInformation>>> listByAccountSinglePageAsync(String resourceGroupName, String accountName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByAccount(this.client.subscriptionId(), resourceGroupName, accountName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<StorageAccountInformation>>>>(){

            public Observable<ServiceResponse<Page<StorageAccountInformation>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = StorageAccountsImpl.this.listByAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<StorageAccountInformation>> listByAccountDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<StorageAccountInformation>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public void add(String resourceGroupName, String accountName, String storageAccountName, String accessKey) {
        ((ServiceResponse)this.addWithServiceResponseAsync(resourceGroupName, accountName, storageAccountName, accessKey).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> addAsync(String resourceGroupName, String accountName, String storageAccountName, String accessKey, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.addWithServiceResponseAsync(resourceGroupName, accountName, storageAccountName, accessKey), serviceCallback);
    }

    @Override
    public Observable<Void> addAsync(String resourceGroupName, String accountName, String storageAccountName, String accessKey) {
        return this.addWithServiceResponseAsync(resourceGroupName, accountName, storageAccountName, accessKey).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> addWithServiceResponseAsync(String resourceGroupName, String accountName, String storageAccountName, String accessKey) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (accessKey == null) {
            throw new IllegalArgumentException("Parameter accessKey is required and cannot be null.");
        }
        Object suffix = null;
        AddStorageAccountParameters parameters = new AddStorageAccountParameters();
        parameters.withAccessKey(accessKey);
        parameters.withSuffix(null);
        return this.service.add(this.client.subscriptionId(), resourceGroupName, accountName, storageAccountName, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsImpl.this.addDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void add(String resourceGroupName, String accountName, String storageAccountName, String accessKey, String suffix) {
        ((ServiceResponse)this.addWithServiceResponseAsync(resourceGroupName, accountName, storageAccountName, accessKey, suffix).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> addAsync(String resourceGroupName, String accountName, String storageAccountName, String accessKey, String suffix, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.addWithServiceResponseAsync(resourceGroupName, accountName, storageAccountName, accessKey, suffix), serviceCallback);
    }

    @Override
    public Observable<Void> addAsync(String resourceGroupName, String accountName, String storageAccountName, String accessKey, String suffix) {
        return this.addWithServiceResponseAsync(resourceGroupName, accountName, storageAccountName, accessKey, suffix).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> addWithServiceResponseAsync(String resourceGroupName, String accountName, String storageAccountName, String accessKey, String suffix) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (accessKey == null) {
            throw new IllegalArgumentException("Parameter accessKey is required and cannot be null.");
        }
        AddStorageAccountParameters parameters = new AddStorageAccountParameters();
        parameters.withAccessKey(accessKey);
        parameters.withSuffix(suffix);
        return this.service.add(this.client.subscriptionId(), resourceGroupName, accountName, storageAccountName, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsImpl.this.addDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> addDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public StorageAccountInformation get(String resourceGroupName, String accountName, String storageAccountName) {
        return (StorageAccountInformation)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, accountName, storageAccountName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<StorageAccountInformation> getAsync(String resourceGroupName, String accountName, String storageAccountName, ServiceCallback<StorageAccountInformation> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, accountName, storageAccountName), serviceCallback);
    }

    @Override
    public Observable<StorageAccountInformation> getAsync(String resourceGroupName, String accountName, String storageAccountName) {
        return this.getWithServiceResponseAsync(resourceGroupName, accountName, storageAccountName).map((Func1)new Func1<ServiceResponse<StorageAccountInformation>, StorageAccountInformation>(){

            public StorageAccountInformation call(ServiceResponse<StorageAccountInformation> response) {
                return (StorageAccountInformation)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<StorageAccountInformation>> getWithServiceResponseAsync(String resourceGroupName, String accountName, String storageAccountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(this.client.subscriptionId(), resourceGroupName, accountName, storageAccountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageAccountInformation>>>(){

            public Observable<ServiceResponse<StorageAccountInformation>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<StorageAccountInformation> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<StorageAccountInformation>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public void update(String resourceGroupName, String accountName, String storageAccountName) {
        ((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, accountName, storageAccountName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> updateAsync(String resourceGroupName, String accountName, String storageAccountName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, accountName, storageAccountName), serviceCallback);
    }

    @Override
    public Observable<Void> updateAsync(String resourceGroupName, String accountName, String storageAccountName) {
        return this.updateWithServiceResponseAsync(resourceGroupName, accountName, storageAccountName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String storageAccountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object accessKey = null;
        Object suffix = null;
        UpdateStorageAccountParameters parameters = new UpdateStorageAccountParameters();
        parameters.withAccessKey(null);
        parameters.withSuffix(null);
        return this.service.update(this.client.subscriptionId(), resourceGroupName, accountName, storageAccountName, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsImpl.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void update(String resourceGroupName, String accountName, String storageAccountName, String accessKey, String suffix) {
        ((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, accountName, storageAccountName, accessKey, suffix).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> updateAsync(String resourceGroupName, String accountName, String storageAccountName, String accessKey, String suffix, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, accountName, storageAccountName, accessKey, suffix), serviceCallback);
    }

    @Override
    public Observable<Void> updateAsync(String resourceGroupName, String accountName, String storageAccountName, String accessKey, String suffix) {
        return this.updateWithServiceResponseAsync(resourceGroupName, accountName, storageAccountName, accessKey, suffix).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String storageAccountName, String accessKey, String suffix) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        UpdateStorageAccountParameters parameters = null;
        if (accessKey != null || suffix != null) {
            parameters = new UpdateStorageAccountParameters();
            parameters.withAccessKey(accessKey);
            parameters.withSuffix(suffix);
        }
        return this.service.update(this.client.subscriptionId(), resourceGroupName, accountName, storageAccountName, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsImpl.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String storageAccountName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, accountName, storageAccountName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String accountName, String storageAccountName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, accountName, storageAccountName), serviceCallback);
    }

    @Override
    public Observable<Void> deleteAsync(String resourceGroupName, String accountName, String storageAccountName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, accountName, storageAccountName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String accountName, String storageAccountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(this.client.subscriptionId(), resourceGroupName, accountName, storageAccountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsImpl.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<StorageContainer> listStorageContainers(String resourceGroupName, String accountName, String storageAccountName) {
        ServiceResponse response = (ServiceResponse)this.listStorageContainersSinglePageAsync(resourceGroupName, accountName, storageAccountName).toBlocking().single();
        return new PagedList<StorageContainer>((Page)response.body()){

            public Page<StorageContainer> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)StorageAccountsImpl.this.listStorageContainersNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<StorageContainer>> listStorageContainersAsync(String resourceGroupName, String accountName, String storageAccountName, ListOperationCallback<StorageContainer> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listStorageContainersSinglePageAsync(resourceGroupName, accountName, storageAccountName), (Func1)new Func1<String, Observable<ServiceResponse<Page<StorageContainer>>>>(){

            public Observable<ServiceResponse<Page<StorageContainer>>> call(String nextPageLink) {
                return StorageAccountsImpl.this.listStorageContainersNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<StorageContainer>> listStorageContainersAsync(String resourceGroupName, String accountName, String storageAccountName) {
        return this.listStorageContainersWithServiceResponseAsync(resourceGroupName, accountName, storageAccountName).map((Func1)new Func1<ServiceResponse<Page<StorageContainer>>, Page<StorageContainer>>(){

            public Page<StorageContainer> call(ServiceResponse<Page<StorageContainer>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<StorageContainer>>> listStorageContainersWithServiceResponseAsync(String resourceGroupName, String accountName, String storageAccountName) {
        return this.listStorageContainersSinglePageAsync(resourceGroupName, accountName, storageAccountName).concatMap((Func1)new Func1<ServiceResponse<Page<StorageContainer>>, Observable<ServiceResponse<Page<StorageContainer>>>>(){

            public Observable<ServiceResponse<Page<StorageContainer>>> call(ServiceResponse<Page<StorageContainer>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(StorageAccountsImpl.this.listStorageContainersNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<StorageContainer>>> listStorageContainersSinglePageAsync(String resourceGroupName, String accountName, String storageAccountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listStorageContainers(this.client.subscriptionId(), resourceGroupName, accountName, storageAccountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<StorageContainer>>>>(){

            public Observable<ServiceResponse<Page<StorageContainer>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = StorageAccountsImpl.this.listStorageContainersDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<StorageContainer>> listStorageContainersDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<StorageContainer>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public StorageContainer getStorageContainer(String resourceGroupName, String accountName, String storageAccountName, String containerName) {
        return (StorageContainer)((ServiceResponse)this.getStorageContainerWithServiceResponseAsync(resourceGroupName, accountName, storageAccountName, containerName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<StorageContainer> getStorageContainerAsync(String resourceGroupName, String accountName, String storageAccountName, String containerName, ServiceCallback<StorageContainer> serviceCallback) {
        return ServiceFuture.fromResponse(this.getStorageContainerWithServiceResponseAsync(resourceGroupName, accountName, storageAccountName, containerName), serviceCallback);
    }

    @Override
    public Observable<StorageContainer> getStorageContainerAsync(String resourceGroupName, String accountName, String storageAccountName, String containerName) {
        return this.getStorageContainerWithServiceResponseAsync(resourceGroupName, accountName, storageAccountName, containerName).map((Func1)new Func1<ServiceResponse<StorageContainer>, StorageContainer>(){

            public StorageContainer call(ServiceResponse<StorageContainer> response) {
                return (StorageContainer)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<StorageContainer>> getStorageContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String storageAccountName, String containerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getStorageContainer(this.client.subscriptionId(), resourceGroupName, accountName, storageAccountName, containerName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageContainer>>>(){

            public Observable<ServiceResponse<StorageContainer>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsImpl.this.getStorageContainerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<StorageContainer> getStorageContainerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<StorageContainer>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<SasTokenInformation> listSasTokens(String resourceGroupName, String accountName, String storageAccountName, String containerName) {
        ServiceResponse response = (ServiceResponse)this.listSasTokensSinglePageAsync(resourceGroupName, accountName, storageAccountName, containerName).toBlocking().single();
        return new PagedList<SasTokenInformation>((Page)response.body()){

            public Page<SasTokenInformation> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)StorageAccountsImpl.this.listSasTokensNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<SasTokenInformation>> listSasTokensAsync(String resourceGroupName, String accountName, String storageAccountName, String containerName, ListOperationCallback<SasTokenInformation> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSasTokensSinglePageAsync(resourceGroupName, accountName, storageAccountName, containerName), (Func1)new Func1<String, Observable<ServiceResponse<Page<SasTokenInformation>>>>(){

            public Observable<ServiceResponse<Page<SasTokenInformation>>> call(String nextPageLink) {
                return StorageAccountsImpl.this.listSasTokensNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<SasTokenInformation>> listSasTokensAsync(String resourceGroupName, String accountName, String storageAccountName, String containerName) {
        return this.listSasTokensWithServiceResponseAsync(resourceGroupName, accountName, storageAccountName, containerName).map((Func1)new Func1<ServiceResponse<Page<SasTokenInformation>>, Page<SasTokenInformation>>(){

            public Page<SasTokenInformation> call(ServiceResponse<Page<SasTokenInformation>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<SasTokenInformation>>> listSasTokensWithServiceResponseAsync(String resourceGroupName, String accountName, String storageAccountName, String containerName) {
        return this.listSasTokensSinglePageAsync(resourceGroupName, accountName, storageAccountName, containerName).concatMap((Func1)new Func1<ServiceResponse<Page<SasTokenInformation>>, Observable<ServiceResponse<Page<SasTokenInformation>>>>(){

            public Observable<ServiceResponse<Page<SasTokenInformation>>> call(ServiceResponse<Page<SasTokenInformation>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(StorageAccountsImpl.this.listSasTokensNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SasTokenInformation>>> listSasTokensSinglePageAsync(String resourceGroupName, String accountName, String storageAccountName, String containerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listSasTokens(this.client.subscriptionId(), resourceGroupName, accountName, storageAccountName, containerName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SasTokenInformation>>>>(){

            public Observable<ServiceResponse<Page<SasTokenInformation>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = StorageAccountsImpl.this.listSasTokensDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SasTokenInformation>> listSasTokensDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<SasTokenInformation>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<StorageAccountInformation> listByAccountNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByAccountNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<StorageAccountInformation>((Page)response.body()){

            public Page<StorageAccountInformation> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)StorageAccountsImpl.this.listByAccountNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<StorageAccountInformation>> listByAccountNextAsync(String nextPageLink, ServiceFuture<List<StorageAccountInformation>> serviceFuture, ListOperationCallback<StorageAccountInformation> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByAccountNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<StorageAccountInformation>>>>(){

            public Observable<ServiceResponse<Page<StorageAccountInformation>>> call(String nextPageLink) {
                return StorageAccountsImpl.this.listByAccountNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<StorageAccountInformation>> listByAccountNextAsync(String nextPageLink) {
        return this.listByAccountNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<StorageAccountInformation>>, Page<StorageAccountInformation>>(){

            public Page<StorageAccountInformation> call(ServiceResponse<Page<StorageAccountInformation>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<StorageAccountInformation>>> listByAccountNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByAccountNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<StorageAccountInformation>>, Observable<ServiceResponse<Page<StorageAccountInformation>>>>(){

            public Observable<ServiceResponse<Page<StorageAccountInformation>>> call(ServiceResponse<Page<StorageAccountInformation>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(StorageAccountsImpl.this.listByAccountNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<StorageAccountInformation>>> listByAccountNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByAccountNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<StorageAccountInformation>>>>(){

            public Observable<ServiceResponse<Page<StorageAccountInformation>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = StorageAccountsImpl.this.listByAccountNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<StorageAccountInformation>> listByAccountNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<StorageAccountInformation>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<StorageContainer> listStorageContainersNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listStorageContainersNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<StorageContainer>((Page)response.body()){

            public Page<StorageContainer> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)StorageAccountsImpl.this.listStorageContainersNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<StorageContainer>> listStorageContainersNextAsync(String nextPageLink, ServiceFuture<List<StorageContainer>> serviceFuture, ListOperationCallback<StorageContainer> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listStorageContainersNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<StorageContainer>>>>(){

            public Observable<ServiceResponse<Page<StorageContainer>>> call(String nextPageLink) {
                return StorageAccountsImpl.this.listStorageContainersNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<StorageContainer>> listStorageContainersNextAsync(String nextPageLink) {
        return this.listStorageContainersNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<StorageContainer>>, Page<StorageContainer>>(){

            public Page<StorageContainer> call(ServiceResponse<Page<StorageContainer>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<StorageContainer>>> listStorageContainersNextWithServiceResponseAsync(String nextPageLink) {
        return this.listStorageContainersNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<StorageContainer>>, Observable<ServiceResponse<Page<StorageContainer>>>>(){

            public Observable<ServiceResponse<Page<StorageContainer>>> call(ServiceResponse<Page<StorageContainer>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(StorageAccountsImpl.this.listStorageContainersNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<StorageContainer>>> listStorageContainersNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listStorageContainersNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<StorageContainer>>>>(){

            public Observable<ServiceResponse<Page<StorageContainer>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = StorageAccountsImpl.this.listStorageContainersNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<StorageContainer>> listStorageContainersNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<StorageContainer>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<SasTokenInformation> listSasTokensNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listSasTokensNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SasTokenInformation>((Page)response.body()){

            public Page<SasTokenInformation> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)StorageAccountsImpl.this.listSasTokensNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<SasTokenInformation>> listSasTokensNextAsync(String nextPageLink, ServiceFuture<List<SasTokenInformation>> serviceFuture, ListOperationCallback<SasTokenInformation> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSasTokensNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SasTokenInformation>>>>(){

            public Observable<ServiceResponse<Page<SasTokenInformation>>> call(String nextPageLink) {
                return StorageAccountsImpl.this.listSasTokensNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<SasTokenInformation>> listSasTokensNextAsync(String nextPageLink) {
        return this.listSasTokensNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SasTokenInformation>>, Page<SasTokenInformation>>(){

            public Page<SasTokenInformation> call(ServiceResponse<Page<SasTokenInformation>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<SasTokenInformation>>> listSasTokensNextWithServiceResponseAsync(String nextPageLink) {
        return this.listSasTokensNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SasTokenInformation>>, Observable<ServiceResponse<Page<SasTokenInformation>>>>(){

            public Observable<ServiceResponse<Page<SasTokenInformation>>> call(ServiceResponse<Page<SasTokenInformation>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(StorageAccountsImpl.this.listSasTokensNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SasTokenInformation>>> listSasTokensNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listSasTokensNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SasTokenInformation>>>>(){

            public Observable<ServiceResponse<Page<SasTokenInformation>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = StorageAccountsImpl.this.listSasTokensNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SasTokenInformation>> listSasTokensNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<SasTokenInformation>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface StorageAccountsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.StorageAccounts listByAccount"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/storageAccounts")
        public Observable<Response<ResponseBody>> listByAccount(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="$filter") String var4, @Query(value="$top") Integer var5, @Query(value="$skip") Integer var6, @Query(value="$select") String var7, @Query(value="$orderby") String var8, @Query(value="$count") Boolean var9, @Query(value="api-version") String var10, @Header(value="accept-language") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.StorageAccounts add"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/storageAccounts/{storageAccountName}")
        public Observable<Response<ResponseBody>> add(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="storageAccountName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body AddStorageAccountParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.StorageAccounts get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/storageAccounts/{storageAccountName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="storageAccountName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.StorageAccounts update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/storageAccounts/{storageAccountName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="storageAccountName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body UpdateStorageAccountParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.StorageAccounts delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/storageAccounts/{storageAccountName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="storageAccountName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.StorageAccounts listStorageContainers"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/storageAccounts/{storageAccountName}/containers")
        public Observable<Response<ResponseBody>> listStorageContainers(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="storageAccountName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.StorageAccounts getStorageContainer"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/storageAccounts/{storageAccountName}/containers/{containerName}")
        public Observable<Response<ResponseBody>> getStorageContainer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="storageAccountName") String var4, @Path(value="containerName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.StorageAccounts listSasTokens"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/storageAccounts/{storageAccountName}/containers/{containerName}/listSasTokens")
        public Observable<Response<ResponseBody>> listSasTokens(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="storageAccountName") String var4, @Path(value="containerName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.StorageAccounts listByAccountNext"})
        @GET
        public Observable<Response<ResponseBody>> listByAccountNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.StorageAccounts listStorageContainersNext"})
        @GET
        public Observable<Response<ResponseBody>> listStorageContainersNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.StorageAccounts listSasTokensNext"})
        @GET
        public Observable<Response<ResponseBody>> listSasTokensNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

