/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.datalake.analytics.implementation;

import com.google.common.base.Joiner;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.datalake.analytics.Pipelines;
import com.microsoft.azure.management.datalake.analytics.implementation.DataLakeAnalyticsJobManagementClientImpl;
import com.microsoft.azure.management.datalake.analytics.models.JobPipelineInformation;
import com.microsoft.azure.management.datalake.analytics.models.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import okhttp3.ResponseBody;
import org.joda.time.DateTime;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class PipelinesImpl
implements Pipelines {
    private PipelinesService service;
    private DataLakeAnalyticsJobManagementClientImpl client;

    public PipelinesImpl(Retrofit retrofit, DataLakeAnalyticsJobManagementClientImpl client) {
        this.service = (PipelinesService)retrofit.create(PipelinesService.class);
        this.client = client;
    }

    @Override
    public PagedList<JobPipelineInformation> list(String accountName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(accountName).toBlocking().single();
        return new PagedList<JobPipelineInformation>((Page)response.body()){

            public Page<JobPipelineInformation> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PipelinesImpl.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<JobPipelineInformation>> listAsync(String accountName, ListOperationCallback<JobPipelineInformation> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(accountName), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobPipelineInformation>>>>(){

            public Observable<ServiceResponse<Page<JobPipelineInformation>>> call(String nextPageLink) {
                return PipelinesImpl.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<JobPipelineInformation>> listAsync(String accountName) {
        return this.listWithServiceResponseAsync(accountName).map((Func1)new Func1<ServiceResponse<Page<JobPipelineInformation>>, Page<JobPipelineInformation>>(){

            public Page<JobPipelineInformation> call(ServiceResponse<Page<JobPipelineInformation>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<JobPipelineInformation>>> listWithServiceResponseAsync(String accountName) {
        return this.listSinglePageAsync(accountName).concatMap((Func1)new Func1<ServiceResponse<Page<JobPipelineInformation>>, Observable<ServiceResponse<Page<JobPipelineInformation>>>>(){

            public Observable<ServiceResponse<Page<JobPipelineInformation>>> call(ServiceResponse<Page<JobPipelineInformation>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PipelinesImpl.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobPipelineInformation>>> listSinglePageAsync(String accountName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        DateTime startDateTime = null;
        DateTime endDateTime = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix()});
        return this.service.list(startDateTime, endDateTime, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobPipelineInformation>>>>(){

            public Observable<ServiceResponse<Page<JobPipelineInformation>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PipelinesImpl.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<JobPipelineInformation> list(String accountName, DateTime startDateTime, DateTime endDateTime) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(accountName, startDateTime, endDateTime).toBlocking().single();
        return new PagedList<JobPipelineInformation>((Page)response.body()){

            public Page<JobPipelineInformation> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PipelinesImpl.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<JobPipelineInformation>> listAsync(String accountName, DateTime startDateTime, DateTime endDateTime, ListOperationCallback<JobPipelineInformation> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(accountName, startDateTime, endDateTime), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobPipelineInformation>>>>(){

            public Observable<ServiceResponse<Page<JobPipelineInformation>>> call(String nextPageLink) {
                return PipelinesImpl.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<JobPipelineInformation>> listAsync(String accountName, DateTime startDateTime, DateTime endDateTime) {
        return this.listWithServiceResponseAsync(accountName, startDateTime, endDateTime).map((Func1)new Func1<ServiceResponse<Page<JobPipelineInformation>>, Page<JobPipelineInformation>>(){

            public Page<JobPipelineInformation> call(ServiceResponse<Page<JobPipelineInformation>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<JobPipelineInformation>>> listWithServiceResponseAsync(String accountName, DateTime startDateTime, DateTime endDateTime) {
        return this.listSinglePageAsync(accountName, startDateTime, endDateTime).concatMap((Func1)new Func1<ServiceResponse<Page<JobPipelineInformation>>, Observable<ServiceResponse<Page<JobPipelineInformation>>>>(){

            public Observable<ServiceResponse<Page<JobPipelineInformation>>> call(ServiceResponse<Page<JobPipelineInformation>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PipelinesImpl.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobPipelineInformation>>> listSinglePageAsync(String accountName, DateTime startDateTime, DateTime endDateTime) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix()});
        return this.service.list(startDateTime, endDateTime, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobPipelineInformation>>>>(){

            public Observable<ServiceResponse<Page<JobPipelineInformation>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PipelinesImpl.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<JobPipelineInformation>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<JobPipelineInformation>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public JobPipelineInformation get(String accountName, UUID pipelineIdentity) {
        return (JobPipelineInformation)((ServiceResponse)this.getWithServiceResponseAsync(accountName, pipelineIdentity).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<JobPipelineInformation> getAsync(String accountName, UUID pipelineIdentity, ServiceCallback<JobPipelineInformation> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(accountName, pipelineIdentity), serviceCallback);
    }

    @Override
    public Observable<JobPipelineInformation> getAsync(String accountName, UUID pipelineIdentity) {
        return this.getWithServiceResponseAsync(accountName, pipelineIdentity).map((Func1)new Func1<ServiceResponse<JobPipelineInformation>, JobPipelineInformation>(){

            public JobPipelineInformation call(ServiceResponse<JobPipelineInformation> response) {
                return (JobPipelineInformation)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<JobPipelineInformation>> getWithServiceResponseAsync(String accountName, UUID pipelineIdentity) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (pipelineIdentity == null) {
            throw new IllegalArgumentException("Parameter pipelineIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        DateTime startDateTime = null;
        DateTime endDateTime = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix()});
        return this.service.get(pipelineIdentity, startDateTime, endDateTime, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobPipelineInformation>>>(){

            public Observable<ServiceResponse<JobPipelineInformation>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PipelinesImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public JobPipelineInformation get(String accountName, UUID pipelineIdentity, DateTime startDateTime, DateTime endDateTime) {
        return (JobPipelineInformation)((ServiceResponse)this.getWithServiceResponseAsync(accountName, pipelineIdentity, startDateTime, endDateTime).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<JobPipelineInformation> getAsync(String accountName, UUID pipelineIdentity, DateTime startDateTime, DateTime endDateTime, ServiceCallback<JobPipelineInformation> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(accountName, pipelineIdentity, startDateTime, endDateTime), serviceCallback);
    }

    @Override
    public Observable<JobPipelineInformation> getAsync(String accountName, UUID pipelineIdentity, DateTime startDateTime, DateTime endDateTime) {
        return this.getWithServiceResponseAsync(accountName, pipelineIdentity, startDateTime, endDateTime).map((Func1)new Func1<ServiceResponse<JobPipelineInformation>, JobPipelineInformation>(){

            public JobPipelineInformation call(ServiceResponse<JobPipelineInformation> response) {
                return (JobPipelineInformation)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<JobPipelineInformation>> getWithServiceResponseAsync(String accountName, UUID pipelineIdentity, DateTime startDateTime, DateTime endDateTime) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (pipelineIdentity == null) {
            throw new IllegalArgumentException("Parameter pipelineIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix()});
        return this.service.get(pipelineIdentity, startDateTime, endDateTime, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobPipelineInformation>>>(){

            public Observable<ServiceResponse<JobPipelineInformation>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PipelinesImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobPipelineInformation> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobPipelineInformation>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<JobPipelineInformation> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobPipelineInformation>((Page)response.body()){

            public Page<JobPipelineInformation> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PipelinesImpl.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<JobPipelineInformation>> listNextAsync(String nextPageLink, ServiceFuture<List<JobPipelineInformation>> serviceFuture, ListOperationCallback<JobPipelineInformation> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobPipelineInformation>>>>(){

            public Observable<ServiceResponse<Page<JobPipelineInformation>>> call(String nextPageLink) {
                return PipelinesImpl.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<JobPipelineInformation>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<JobPipelineInformation>>, Page<JobPipelineInformation>>(){

            public Page<JobPipelineInformation> call(ServiceResponse<Page<JobPipelineInformation>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<JobPipelineInformation>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<JobPipelineInformation>>, Observable<ServiceResponse<Page<JobPipelineInformation>>>>(){

            public Observable<ServiceResponse<Page<JobPipelineInformation>>> call(ServiceResponse<Page<JobPipelineInformation>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PipelinesImpl.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobPipelineInformation>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobPipelineInformation>>>>(){

            public Observable<ServiceResponse<Page<JobPipelineInformation>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PipelinesImpl.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<JobPipelineInformation>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<JobPipelineInformation>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface PipelinesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Pipelines list"})
        @GET(value="pipelines")
        public Observable<Response<ResponseBody>> list(@Query(value="startDateTime") DateTime var1, @Query(value="endDateTime") DateTime var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Pipelines get"})
        @GET(value="pipelines/{pipelineIdentity}")
        public Observable<Response<ResponseBody>> get(@Path(value="pipelineIdentity") UUID var1, @Query(value="startDateTime") DateTime var2, @Query(value="endDateTime") DateTime var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Pipelines listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

