/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.datalake.analytics.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.management.datalake.analytics.DataLakeAnalyticsJobManagementClient;
import com.microsoft.azure.management.datalake.analytics.Jobs;
import com.microsoft.azure.management.datalake.analytics.Pipelines;
import com.microsoft.azure.management.datalake.analytics.Recurrences;
import com.microsoft.azure.management.datalake.analytics.implementation.JobsImpl;
import com.microsoft.azure.management.datalake.analytics.implementation.PipelinesImpl;
import com.microsoft.azure.management.datalake.analytics.implementation.RecurrencesImpl;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public class DataLakeAnalyticsJobManagementClientImpl
extends AzureServiceClient
implements DataLakeAnalyticsJobManagementClient {
    private AzureClient azureClient;
    private String adlaJobDnsSuffix;
    private String apiVersion;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private Jobs jobs;
    private Pipelines pipelines;
    private Recurrences recurrences;

    @Override
    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    @Override
    public String adlaJobDnsSuffix() {
        return this.adlaJobDnsSuffix;
    }

    @Override
    public DataLakeAnalyticsJobManagementClientImpl withAdlaJobDnsSuffix(String adlaJobDnsSuffix) {
        this.adlaJobDnsSuffix = adlaJobDnsSuffix;
        return this;
    }

    @Override
    public String apiVersion() {
        return this.apiVersion;
    }

    @Override
    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    @Override
    public DataLakeAnalyticsJobManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    @Override
    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    @Override
    public DataLakeAnalyticsJobManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    @Override
    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    @Override
    public DataLakeAnalyticsJobManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    @Override
    public Jobs jobs() {
        return this.jobs;
    }

    @Override
    public Pipelines pipelines() {
        return this.pipelines;
    }

    @Override
    public Recurrences recurrences() {
        return this.recurrences;
    }

    public DataLakeAnalyticsJobManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://{accountName}.{adlaJobDnsSuffix}", credentials);
    }

    private DataLakeAnalyticsJobManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public DataLakeAnalyticsJobManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.adlaJobDnsSuffix = "azuredatalakeanalytics.net";
        this.apiVersion = "2017-09-01-preview";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.jobs = new JobsImpl(this.restClient().retrofit(), this);
        this.pipelines = new PipelinesImpl(this.restClient().retrofit(), this);
        this.recurrences = new RecurrencesImpl(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    @Override
    public String userAgent() {
        return String.format("%s (%s, %s)", super.userAgent(), "DataLakeAnalyticsJobManagementClient", "2017-09-01-preview");
    }
}

