/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.datalake.analytics.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.management.datalake.analytics.Catalogs;
import com.microsoft.azure.management.datalake.analytics.DataLakeAnalyticsCatalogManagementClient;
import com.microsoft.azure.management.datalake.analytics.implementation.CatalogsImpl;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public class DataLakeAnalyticsCatalogManagementClientImpl
extends AzureServiceClient
implements DataLakeAnalyticsCatalogManagementClient {
    private AzureClient azureClient;
    private String apiVersion;
    private String adlaCatalogDnsSuffix;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private Catalogs catalogs;

    @Override
    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    @Override
    public String apiVersion() {
        return this.apiVersion;
    }

    @Override
    public String adlaCatalogDnsSuffix() {
        return this.adlaCatalogDnsSuffix;
    }

    @Override
    public DataLakeAnalyticsCatalogManagementClientImpl withAdlaCatalogDnsSuffix(String adlaCatalogDnsSuffix) {
        this.adlaCatalogDnsSuffix = adlaCatalogDnsSuffix;
        return this;
    }

    @Override
    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    @Override
    public DataLakeAnalyticsCatalogManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    @Override
    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    @Override
    public DataLakeAnalyticsCatalogManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    @Override
    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    @Override
    public DataLakeAnalyticsCatalogManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    @Override
    public Catalogs catalogs() {
        return this.catalogs;
    }

    public DataLakeAnalyticsCatalogManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://{accountName}.{adlaCatalogDnsSuffix}", credentials);
    }

    private DataLakeAnalyticsCatalogManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public DataLakeAnalyticsCatalogManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.apiVersion = "2016-11-01";
        this.adlaCatalogDnsSuffix = "azuredatalakeanalytics.net";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.catalogs = new CatalogsImpl(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    @Override
    public String userAgent() {
        return String.format("%s (%s, %s)", super.userAgent(), "DataLakeAnalyticsCatalogManagementClient", "2016-11-01");
    }
}

