/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.datalake.analytics.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.management.datalake.analytics.Accounts;
import com.microsoft.azure.management.datalake.analytics.ComputePolicies;
import com.microsoft.azure.management.datalake.analytics.DataLakeAnalyticsAccountManagementClient;
import com.microsoft.azure.management.datalake.analytics.DataLakeStoreAccounts;
import com.microsoft.azure.management.datalake.analytics.FirewallRules;
import com.microsoft.azure.management.datalake.analytics.Locations;
import com.microsoft.azure.management.datalake.analytics.Operations;
import com.microsoft.azure.management.datalake.analytics.StorageAccounts;
import com.microsoft.azure.management.datalake.analytics.implementation.AccountsImpl;
import com.microsoft.azure.management.datalake.analytics.implementation.ComputePoliciesImpl;
import com.microsoft.azure.management.datalake.analytics.implementation.DataLakeStoreAccountsImpl;
import com.microsoft.azure.management.datalake.analytics.implementation.FirewallRulesImpl;
import com.microsoft.azure.management.datalake.analytics.implementation.LocationsImpl;
import com.microsoft.azure.management.datalake.analytics.implementation.OperationsImpl;
import com.microsoft.azure.management.datalake.analytics.implementation.StorageAccountsImpl;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public class DataLakeAnalyticsAccountManagementClientImpl
extends AzureServiceClient
implements DataLakeAnalyticsAccountManagementClient {
    private AzureClient azureClient;
    private String subscriptionId;
    private String apiVersion;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private Accounts accounts;
    private DataLakeStoreAccounts dataLakeStoreAccounts;
    private StorageAccounts storageAccounts;
    private ComputePolicies computePolicies;
    private FirewallRules firewallRules;
    private Operations operations;
    private Locations locations;

    @Override
    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    @Override
    public String subscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public DataLakeAnalyticsAccountManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    @Override
    public String apiVersion() {
        return this.apiVersion;
    }

    @Override
    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    @Override
    public DataLakeAnalyticsAccountManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    @Override
    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    @Override
    public DataLakeAnalyticsAccountManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    @Override
    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    @Override
    public DataLakeAnalyticsAccountManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    @Override
    public Accounts accounts() {
        return this.accounts;
    }

    @Override
    public DataLakeStoreAccounts dataLakeStoreAccounts() {
        return this.dataLakeStoreAccounts;
    }

    @Override
    public StorageAccounts storageAccounts() {
        return this.storageAccounts;
    }

    @Override
    public ComputePolicies computePolicies() {
        return this.computePolicies;
    }

    @Override
    public FirewallRules firewallRules() {
        return this.firewallRules;
    }

    @Override
    public Operations operations() {
        return this.operations;
    }

    @Override
    public Locations locations() {
        return this.locations;
    }

    public DataLakeAnalyticsAccountManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public DataLakeAnalyticsAccountManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public DataLakeAnalyticsAccountManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.apiVersion = "2016-11-01";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.accounts = new AccountsImpl(this.restClient().retrofit(), this);
        this.dataLakeStoreAccounts = new DataLakeStoreAccountsImpl(this.restClient().retrofit(), this);
        this.storageAccounts = new StorageAccountsImpl(this.restClient().retrofit(), this);
        this.computePolicies = new ComputePoliciesImpl(this.restClient().retrofit(), this);
        this.firewallRules = new FirewallRulesImpl(this.restClient().retrofit(), this);
        this.operations = new OperationsImpl(this.restClient().retrofit(), this);
        this.locations = new LocationsImpl(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    @Override
    public String userAgent() {
        return String.format("%s (%s, %s)", super.userAgent(), "DataLakeAnalyticsAccountManagementClient", "2016-11-01");
    }
}

