/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerservice.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerservice.KubernetesCluster;
import com.microsoft.azure.management.containerservice.KubernetesClusters;
import com.microsoft.azure.management.containerservice.OrchestratorVersionProfile;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceManagementClientImpl;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceManager;
import com.microsoft.azure.management.containerservice.implementation.CredentialResultsInner;
import com.microsoft.azure.management.containerservice.implementation.KubernetesClusterImpl;
import com.microsoft.azure.management.containerservice.implementation.ManagedClusterInner;
import com.microsoft.azure.management.containerservice.implementation.ManagedClustersInner;
import com.microsoft.azure.management.containerservice.implementation.OrchestratorVersionProfileListResultInner;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupPagedList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import rx.Completable;
import rx.Observable;
import rx.functions.Action2;
import rx.functions.Func0;
import rx.functions.Func1;

@LangDefinition
public class KubernetesClustersImpl
extends GroupableResourcesImpl<KubernetesCluster, KubernetesClusterImpl, ManagedClusterInner, ManagedClustersInner, ContainerServiceManager>
implements KubernetesClusters {
    KubernetesClustersImpl(ContainerServiceManager containerServiceManager) {
        super((Object)((ContainerServiceManagementClientImpl)((Object)containerServiceManager.inner())).managedClusters(), (ManagerBase)containerServiceManager);
    }

    public PagedList<KubernetesCluster> list() {
        final KubernetesClustersImpl self = this;
        return new GroupPagedList<KubernetesCluster>(((ContainerServiceManager)this.manager()).resourceManager().resourceGroups().list()){

            public List<KubernetesCluster> listNextGroup(String resourceGroupName) {
                return KubernetesClustersImpl.this.wrapList(((ManagedClustersInner)self.inner()).listByResourceGroup(resourceGroupName));
            }
        };
    }

    public Observable<KubernetesCluster> listAsync() {
        return ((ContainerServiceManager)this.manager()).resourceManager().resourceGroups().listAsync().flatMap((Func1)new Func1<ResourceGroup, Observable<KubernetesCluster>>(){

            public Observable<KubernetesCluster> call(ResourceGroup resourceGroup) {
                return KubernetesClustersImpl.this.wrapPageAsync(((ManagedClustersInner)KubernetesClustersImpl.this.inner()).listByResourceGroupAsync(resourceGroup.name()));
            }
        });
    }

    public PagedList<KubernetesCluster> listByResourceGroup(String resourceGroupName) {
        return this.wrapList(((ManagedClustersInner)this.inner()).listByResourceGroup(resourceGroupName));
    }

    public Observable<KubernetesCluster> listByResourceGroupAsync(String resourceGroupName) {
        return this.wrapPageAsync(((ManagedClustersInner)this.inner()).listByResourceGroupAsync(resourceGroupName));
    }

    protected Observable<ManagedClusterInner> getInnerAsync(String resourceGroupName, String name) {
        return ((ManagedClustersInner)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    protected Completable deleteInnerAsync(String resourceGroupName, String name) {
        return ((ManagedClustersInner)this.inner()).deleteAsync(resourceGroupName, name).toCompletable();
    }

    protected KubernetesClusterImpl wrapModel(String name) {
        return new KubernetesClusterImpl(name, new ManagedClusterInner(), (ContainerServiceManager)this.manager());
    }

    protected KubernetesClusterImpl wrapModel(ManagedClusterInner inner) {
        if (inner == null) {
            return null;
        }
        return new KubernetesClusterImpl(inner.name(), inner, (ContainerServiceManager)this.manager());
    }

    public KubernetesClusterImpl define(String name) {
        return this.wrapModel(name);
    }

    @Override
    public Set<String> listKubernetesVersions(Region region) {
        TreeSet<String> kubernetesVersions = new TreeSet<String>();
        OrchestratorVersionProfileListResultInner inner = ((ContainerServiceManagementClientImpl)((Object)((ContainerServiceManager)this.manager()).inner())).containerServices().listOrchestrators(region.name());
        if (inner != null && inner.orchestrators() != null && inner.orchestrators().size() > 0) {
            for (OrchestratorVersionProfile orchestrator : inner.orchestrators()) {
                if (!orchestrator.orchestratorType().equals("Kubernetes")) continue;
                kubernetesVersions.add(orchestrator.orchestratorVersion());
            }
        }
        return Collections.unmodifiableSet(kubernetesVersions);
    }

    @Override
    public Observable<Set<String>> listKubernetesVersionsAsync(Region region) {
        return ((ContainerServiceManagementClientImpl)((Object)((ContainerServiceManager)this.manager()).inner())).containerServices().listOrchestratorsAsync(region.name()).collect((Func0)new Func0<TreeSet<String>>(){

            public TreeSet<String> call() {
                return new TreeSet<String>();
            }
        }, (Action2)new Action2<TreeSet<String>, OrchestratorVersionProfileListResultInner>(){

            public void call(TreeSet<String> kubernetesVersions, OrchestratorVersionProfileListResultInner inner) {
                if (inner != null && inner.orchestrators() != null && inner.orchestrators().size() > 0) {
                    for (OrchestratorVersionProfile orchestrator : inner.orchestrators()) {
                        if (!orchestrator.orchestratorType().equals("Kubernetes")) continue;
                        kubernetesVersions.add(orchestrator.orchestratorVersion());
                    }
                }
            }
        }).map((Func1)new Func1<TreeSet<String>, Set<String>>(){

            public Set<String> call(TreeSet<String> kubernetesVersions) {
                return Collections.unmodifiableSet(kubernetesVersions);
            }
        });
    }

    @Override
    public byte[] getAdminKubeConfigContent(String resourceGroupName, String kubernetesClusterName) {
        return (byte[])this.getAdminKubeConfigContentAsync(resourceGroupName, kubernetesClusterName).toBlocking().last();
    }

    @Override
    public Observable<byte[]> getAdminKubeConfigContentAsync(String resourceGroupName, String kubernetesClusterName) {
        return ((ContainerServiceManagementClientImpl)((Object)((ContainerServiceManager)this.manager()).inner())).managedClusters().listClusterAdminCredentialsAsync(resourceGroupName, kubernetesClusterName).map((Func1)new Func1<CredentialResultsInner, byte[]>(){

            public byte[] call(CredentialResultsInner credentialInner) {
                if (credentialInner == null || credentialInner.kubeconfigs() == null || credentialInner.kubeconfigs().isEmpty()) {
                    return new byte[0];
                }
                return credentialInner.kubeconfigs().get(0).value();
            }
        });
    }

    @Override
    public byte[] getUserKubeConfigContent(String resourceGroupName, String kubernetesClusterName) {
        return (byte[])this.getUserKubeConfigContentAsync(resourceGroupName, kubernetesClusterName).toBlocking().last();
    }

    @Override
    public Observable<byte[]> getUserKubeConfigContentAsync(String resourceGroupName, String kubernetesClusterName) {
        return ((ContainerServiceManagementClientImpl)((Object)((ContainerServiceManager)this.manager()).inner())).managedClusters().listClusterUserCredentialsAsync(resourceGroupName, kubernetesClusterName).map((Func1)new Func1<CredentialResultsInner, byte[]>(){

            public byte[] call(CredentialResultsInner credentialInner) {
                if (credentialInner == null || credentialInner.kubeconfigs() == null || credentialInner.kubeconfigs().isEmpty()) {
                    return new byte[0];
                }
                return credentialInner.kubeconfigs().get(0).value();
            }
        });
    }
}

