/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerregistry.PasswordName;
import com.microsoft.azure.management.containerregistry.Registry;
import com.microsoft.azure.management.containerregistry.Sku;
import com.microsoft.azure.management.containerregistry.StorageAccountParameters;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManager;
import com.microsoft.azure.management.containerregistry.implementation.RegistryCreateParametersInner;
import com.microsoft.azure.management.containerregistry.implementation.RegistryInner;
import com.microsoft.azure.management.containerregistry.implementation.RegistryListCredentials;
import com.microsoft.azure.management.containerregistry.implementation.RegistryUpdateParametersInner;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.storage.StorageAccount;
import com.microsoft.azure.management.storage.StorageAccountKey;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import java.util.List;
import org.joda.time.DateTime;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class RegistryImpl
extends GroupableResourceImpl<Registry, RegistryInner, RegistryImpl, ContainerRegistryManager>
implements Registry,
Registry.Definition,
Registry.Update {
    private RegistryCreateParametersInner createParameters = new RegistryCreateParametersInner();
    private RegistryUpdateParametersInner updateParameters;
    private final StorageManager storageManager;
    private StorageAccount storageAccount;
    private String creatableStorageAccountKey;

    protected RegistryImpl(String name, RegistryInner innerObject, ContainerRegistryManager manager, StorageManager storageManager) {
        super(name, (Resource)innerObject, (ManagerBase)manager);
        Sku sku = new Sku();
        sku.withName("Basic");
        this.createParameters.withSku(sku);
        this.storageManager = storageManager;
    }

    @Override
    public Sku sku() {
        return ((RegistryInner)((Object)this.inner())).sku();
    }

    @Override
    public String loginServerUrl() {
        return ((RegistryInner)((Object)this.inner())).loginServer();
    }

    @Override
    public DateTime creationDate() {
        return ((RegistryInner)((Object)this.inner())).creationDate();
    }

    @Override
    public boolean adminUserEnabled() {
        return ((RegistryInner)((Object)this.inner())).adminUserEnabled();
    }

    @Override
    public String storageAccountName() {
        if (((RegistryInner)((Object)this.inner())).storageAccount() == null) {
            return null;
        }
        return ((RegistryInner)((Object)this.inner())).storageAccount().name();
    }

    @Override
    public RegistryImpl withRegistryNameAsAdminUser() {
        if (this.isInCreateMode()) {
            this.createParameters.withAdminUserEnabled(true);
        } else {
            this.updateParameters.withAdminUserEnabled(true);
        }
        return this;
    }

    @Override
    public RegistryImpl withoutRegistryNameAsAdminUser() {
        if (this.isInCreateMode()) {
            this.createParameters.withAdminUserEnabled(false);
        } else {
            this.updateParameters.withAdminUserEnabled(false);
        }
        return this;
    }

    @Override
    public RegistryImpl withExistingStorageAccount(StorageAccount storageAccount) {
        this.storageAccount = storageAccount;
        return this;
    }

    @Override
    public RegistryImpl withNewStorageAccount(String storageAccountName) {
        StorageAccount.DefinitionStages.WithGroup definitionWithGroup = (StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.storageManager.storageAccounts().define(storageAccountName)).withRegion(this.regionName());
        Creatable definitionAfterGroup = this.creatableGroup != null ? (Creatable)definitionWithGroup.withNewResourceGroup(this.creatableGroup) : (Creatable)definitionWithGroup.withExistingResourceGroup(this.resourceGroupName());
        return this.withNewStorageAccount(definitionAfterGroup);
    }

    @Override
    public RegistryImpl withNewStorageAccount(Creatable<StorageAccount> creatable) {
        if (this.creatableStorageAccountKey == null) {
            this.creatableStorageAccountKey = creatable.key();
            this.addCreatableDependency(creatable);
        }
        return this;
    }

    protected Observable<RegistryInner> getInnerAsync() {
        return ((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)this.manager()).inner())).registries().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public RegistryImpl update() {
        this.updateParameters = new RegistryUpdateParametersInner();
        return (RegistryImpl)super.update();
    }

    public Observable<Registry> createResourceAsync() {
        final RegistryImpl self = this;
        if (this.isInCreateMode()) {
            return this.handleStorageSettings().flatMap((Func1)new Func1<StorageAccountParameters, Observable<? extends Registry>>(){

                public Observable<? extends Registry> call(StorageAccountParameters storageAccountParameters) {
                    RegistryImpl.this.createParameters.withStorageAccount(storageAccountParameters);
                    RegistryImpl.this.createParameters.withLocation(RegistryImpl.this.regionName().toLowerCase());
                    RegistryImpl.this.createParameters.withTags(((RegistryInner)((Object)RegistryImpl.this.inner())).getTags());
                    return ((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)RegistryImpl.this.manager()).inner())).registries().createAsync(RegistryImpl.this.resourceGroupName(), RegistryImpl.this.name(), RegistryImpl.this.createParameters).map((Func1)new Func1<RegistryInner, Registry>(){

                        public Registry call(RegistryInner containerServiceInner) {
                            self.setInner((Object)containerServiceInner);
                            return self;
                        }
                    });
                }
            });
        }
        this.updateParameters.withTags(((RegistryInner)((Object)this.inner())).getTags());
        return ((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)this.manager()).inner())).registries().updateAsync(this.resourceGroupName(), this.name(), this.updateParameters).map((Func1)new Func1<RegistryInner, Registry>(){

            public Registry call(RegistryInner containerServiceInner) {
                self.setInner((Object)containerServiceInner);
                return self;
            }
        });
    }

    @Override
    public RegistryListCredentials regenerateCredential(PasswordName passwordName) {
        return (RegistryListCredentials)this.regenerateCredentialAsync(passwordName).toBlocking().last();
    }

    @Override
    public Observable<RegistryListCredentials> regenerateCredentialAsync(PasswordName passwordName) {
        return ((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)this.manager()).inner())).registries().regenerateCredentialAsync(this.resourceGroupName(), this.name(), passwordName);
    }

    @Override
    public RegistryListCredentials listCredentials() {
        return (RegistryListCredentials)this.listCredentialsAsync().toBlocking().last();
    }

    @Override
    public Observable<RegistryListCredentials> listCredentialsAsync() {
        return ((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)this.manager()).inner())).registries().listCredentialsAsync(this.resourceGroupName(), this.name());
    }

    private Observable<StorageAccountParameters> handleStorageSettings() {
        Func1<StorageAccount, StorageAccountParameters> onStorageAccountReady = new Func1<StorageAccount, StorageAccountParameters>(){

            public StorageAccountParameters call(StorageAccount storageAccount) {
                RegistryImpl.this.storageAccount = storageAccount;
                List keys = storageAccount.getKeys();
                StorageAccountParameters storageAccountParameters = new StorageAccountParameters();
                storageAccountParameters.withName(storageAccount.name());
                storageAccountParameters.withAccessKey(((StorageAccountKey)keys.get(0)).value());
                return storageAccountParameters;
            }
        };
        if (this.creatableStorageAccountKey != null) {
            return Observable.just((Object)((StorageAccount)this.createdResource(this.creatableStorageAccountKey))).map((Func1)onStorageAccountReady);
        }
        return Observable.just((Object)this.storageAccount).map((Func1)onStorageAccountReady);
    }
}

