/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.ResourceIdentityType;
import com.microsoft.azure.management.compute.VirtualMachineScaleSet;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetExtension;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetIdentity;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetInner;
import com.microsoft.azure.management.graphrbac.BuiltInRole;
import com.microsoft.azure.management.graphrbac.RoleAssignment;
import com.microsoft.azure.management.graphrbac.ServicePrincipal;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.resources.implementation.ResourceManager;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.tuple.Pair;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func2;

@LangDefinition
class VirtualMachineScaleSetMsiHelper {
    private static final String CURRENT_RESOURCE_GROUP_SCOPE = "CURRENT_RESOURCE_GROUP";
    private static final int DEFAULT_TOKEN_PORT = 50342;
    private static final String MSI_EXTENSION_PUBLISHER_NAME = "Microsoft.ManagedIdentity";
    private static final String LINUX_MSI_EXTENSION = "ManagedIdentityExtensionForLinux";
    private static final String WINDOWS_MSI_EXTENSION = "ManagedIdentityExtensionForWindows";
    private final GraphRbacManager rbacManager;
    private Integer tokenPort;
    private boolean requireSetup;
    private LinkedHashMap<String, Pair<String, BuiltInRole>> rolesToAssign;
    private LinkedHashMap<String, Pair<String, String>> roleDefinitionsToAssign;

    VirtualMachineScaleSetMsiHelper(GraphRbacManager rbacManager) {
        this.rbacManager = rbacManager;
        this.rolesToAssign = new LinkedHashMap();
        this.roleDefinitionsToAssign = new LinkedHashMap();
        this.clear();
    }

    VirtualMachineScaleSetMsiHelper withManagedServiceIdentity(VirtualMachineScaleSetInner scaleSetInner) {
        return this.withManagedServiceIdentity(null, scaleSetInner);
    }

    VirtualMachineScaleSetMsiHelper withManagedServiceIdentity(Integer port, VirtualMachineScaleSetInner scaleSetInner) {
        this.requireSetup = true;
        this.tokenPort = port;
        if (scaleSetInner.identity() == null) {
            scaleSetInner.withIdentity(new VirtualMachineScaleSetIdentity());
        }
        if (scaleSetInner.identity().type() == null) {
            scaleSetInner.identity().withType(ResourceIdentityType.SYSTEM_ASSIGNED);
        }
        return this;
    }

    VirtualMachineScaleSetMsiHelper withRoleBasedAccessToCurrentResourceGroup(BuiltInRole asRole) {
        return this.withRoleBasedAccessTo(CURRENT_RESOURCE_GROUP_SCOPE, asRole);
    }

    VirtualMachineScaleSetMsiHelper withRoleBasedAccessTo(String scope, BuiltInRole asRole) {
        this.requireSetup = true;
        String key = scope.toLowerCase() + "_" + asRole.toString().toLowerCase();
        this.rolesToAssign.put(key, (Pair<String, BuiltInRole>)Pair.of((Object)scope, (Object)asRole));
        return this;
    }

    VirtualMachineScaleSetMsiHelper withRoleDefinitionBasedAccessToCurrentResourceGroup(String roleDefintionId) {
        return this.withRoleDefinitionBasedAccessTo(CURRENT_RESOURCE_GROUP_SCOPE, roleDefintionId);
    }

    VirtualMachineScaleSetMsiHelper withRoleDefinitionBasedAccessTo(String scope, String roleDefinition) {
        this.requireSetup = true;
        String key = scope.toLowerCase() + "_" + roleDefinition.toLowerCase();
        this.roleDefinitionsToAssign.put(key, (Pair<String, String>)Pair.of((Object)scope, (Object)roleDefinition));
        return this;
    }

    void addOrUpdateMSIExtension(VirtualMachineScaleSetImpl scaleSetImpl) {
        if (!this.requireSetup) {
            return;
        }
        String msiExtensionType = this.msiExtensionType(scaleSetImpl.osTypeIntern());
        VirtualMachineScaleSetExtension msiExtension = this.getMSIExtension(scaleSetImpl.extensions(), msiExtensionType);
        if (msiExtension != null) {
            Object currentTokenPortObj = msiExtension.publicSettings().get("port");
            Integer currentTokenPort = this.objectToInteger(currentTokenPortObj);
            Integer newPort = this.tokenPort != null ? this.tokenPort : (currentTokenPort != null ? currentTokenPort : Integer.valueOf(50342));
            VirtualMachineScaleSetImpl appliableVMSS = scaleSetImpl;
            appliableVMSS.updateExtension(msiExtension.name()).withPublicSetting("port", newPort).parent();
        } else {
            Integer port = this.tokenPort != null ? this.tokenPort : Integer.valueOf(50342);
            if (scaleSetImpl.isInCreateMode()) {
                VirtualMachineScaleSetImpl creatableVMSS = scaleSetImpl;
                creatableVMSS.defineNewExtension(msiExtensionType).withPublisher(MSI_EXTENSION_PUBLISHER_NAME).withType(msiExtensionType).withVersion("1.0").withMinorVersionAutoUpgrade().withPublicSetting("port", port).attach();
            } else {
                VirtualMachineScaleSetImpl appliableVMSS = scaleSetImpl;
                appliableVMSS.defineNewExtension(msiExtensionType).withPublisher(MSI_EXTENSION_PUBLISHER_NAME).withType(msiExtensionType).withVersion("1.0").withMinorVersionAutoUpgrade().withPublicSetting("port", port).attach();
            }
        }
    }

    Observable<RoleAssignment> createMSIRbacRoleAssignmentsAsync(VirtualMachineScaleSet scaleSet) {
        Func0<Observable<RoleAssignment>> empty = new Func0<Observable<RoleAssignment>>(){

            public Observable<RoleAssignment> call() {
                VirtualMachineScaleSetMsiHelper.this.clear();
                return Observable.empty();
            }
        };
        if (!this.requireSetup) {
            return (Observable)empty.call();
        }
        if (!scaleSet.isManagedServiceIdentityEnabled()) {
            return (Observable)empty.call();
        }
        if (this.rolesToAssign.isEmpty() && this.roleDefinitionsToAssign.isEmpty()) {
            return (Observable)empty.call();
        }
        return this.rbacManager.servicePrincipals().getByIdAsync(((VirtualMachineScaleSetInner)((Object)scaleSet.inner())).identity().principalId()).zipWith(this.resolveCurrentResourceGroupScopeAsync(scaleSet), (Func2)new Func2<ServicePrincipal, Boolean, ServicePrincipal>(){

            public ServicePrincipal call(ServicePrincipal servicePrincipal, Boolean resolvedAny) {
                return servicePrincipal;
            }
        }).flatMap((Func1)new Func1<ServicePrincipal, Observable<RoleAssignment>>(){

            public Observable<RoleAssignment> call(final ServicePrincipal servicePrincipal) {
                Observable observable1 = Observable.from(VirtualMachineScaleSetMsiHelper.this.rolesToAssign.values()).flatMap((Func1)new Func1<Pair<String, BuiltInRole>, Observable<RoleAssignment>>(){

                    public Observable<RoleAssignment> call(Pair<String, BuiltInRole> scopeAndRole) {
                        BuiltInRole role = (BuiltInRole)scopeAndRole.getRight();
                        String scope = (String)scopeAndRole.getLeft();
                        return VirtualMachineScaleSetMsiHelper.this.createRbacRoleAssignmentIfNotExistsAsync(servicePrincipal, role.toString(), scope, true);
                    }
                });
                Observable observable2 = Observable.from(VirtualMachineScaleSetMsiHelper.this.roleDefinitionsToAssign.values()).flatMap((Func1)new Func1<Pair<String, String>, Observable<RoleAssignment>>(){

                    public Observable<RoleAssignment> call(Pair<String, String> scopeAndRole) {
                        String roleDefinition = (String)scopeAndRole.getRight();
                        String scope = (String)scopeAndRole.getLeft();
                        return VirtualMachineScaleSetMsiHelper.this.createRbacRoleAssignmentIfNotExistsAsync(servicePrincipal, roleDefinition, scope, false);
                    }
                });
                return Observable.mergeDelayError((Observable)observable1, (Observable)observable2);
            }
        }).doAfterTerminate(new Action0(){

            public void call() {
                VirtualMachineScaleSetMsiHelper.this.clear();
            }
        });
    }

    private Observable<Boolean> resolveCurrentResourceGroupScopeAsync(final VirtualMachineScaleSet scaleSet) {
        final ArrayList<String> keysWithCurrentResourceGroupScopeForRoles = new ArrayList<String>();
        for (Map.Entry<String, Pair<String, BuiltInRole>> entrySet : this.rolesToAssign.entrySet()) {
            if (!((String)entrySet.getValue().getLeft()).equals(CURRENT_RESOURCE_GROUP_SCOPE)) continue;
            keysWithCurrentResourceGroupScopeForRoles.add(entrySet.getKey());
        }
        final ArrayList<String> keysWithCurrentResourceGroupScopeForRoleDefinitions = new ArrayList<String>();
        for (Map.Entry<String, Pair<String, String>> entrySet : this.roleDefinitionsToAssign.entrySet()) {
            if (!((String)entrySet.getValue().getLeft()).equals(CURRENT_RESOURCE_GROUP_SCOPE)) continue;
            keysWithCurrentResourceGroupScopeForRoleDefinitions.add(entrySet.getKey());
        }
        if (keysWithCurrentResourceGroupScopeForRoles.isEmpty() && keysWithCurrentResourceGroupScopeForRoleDefinitions.isEmpty()) {
            return Observable.just((Object)false);
        }
        return Observable.fromCallable((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                ResourceManager resourceManager = ((ComputeManager)((Object)scaleSet.manager())).resourceManager();
                return ((ResourceGroup)resourceManager.resourceGroups().getByName(scaleSet.resourceGroupName())).id();
            }
        }).subscribeOn(SdkContext.getRxScheduler()).map((Func1)new Func1<String, Boolean>(){

            public Boolean call(String resourceGroupScope) {
                for (String key : keysWithCurrentResourceGroupScopeForRoles) {
                    VirtualMachineScaleSetMsiHelper.this.rolesToAssign.put(key, Pair.of((Object)resourceGroupScope, (Object)((Pair)VirtualMachineScaleSetMsiHelper.this.rolesToAssign.get(key)).getRight()));
                }
                for (String key : keysWithCurrentResourceGroupScopeForRoleDefinitions) {
                    VirtualMachineScaleSetMsiHelper.this.roleDefinitionsToAssign.put(key, Pair.of((Object)resourceGroupScope, (Object)((Pair)VirtualMachineScaleSetMsiHelper.this.roleDefinitionsToAssign.get(key)).getRight()));
                }
                return true;
            }
        });
    }

    private Observable<RoleAssignment> createRbacRoleAssignmentIfNotExistsAsync(ServicePrincipal servicePrincipal, String roleOrRoleDefinition, String scope, boolean isRole) {
        Func1<Throwable, Observable<? extends Indexable>> onErrorResumeNext = new Func1<Throwable, Observable<? extends Indexable>>(){

            public Observable<? extends Indexable> call(Throwable throwable) {
                CloudException exception;
                if (throwable instanceof CloudException && (exception = (CloudException)throwable).body() != null && exception.body().code() != null && exception.body().code().equalsIgnoreCase("RoleAssignmentExists")) {
                    return Observable.empty();
                }
                return Observable.error((Throwable)throwable);
            }
        };
        String roleAssignmentName = SdkContext.randomUuid();
        if (isRole) {
            return ((RoleAssignment.DefinitionStages.Blank)this.rbacManager.roleAssignments().define(roleAssignmentName)).forServicePrincipal(servicePrincipal).withBuiltInRole(BuiltInRole.fromString((String)roleOrRoleDefinition)).withScope(scope).createAsync().last().onErrorResumeNext((Func1)onErrorResumeNext).map((Func1)new Func1<Indexable, RoleAssignment>(){

                public RoleAssignment call(Indexable indexable) {
                    return (RoleAssignment)indexable;
                }
            });
        }
        return ((RoleAssignment.DefinitionStages.Blank)this.rbacManager.roleAssignments().define(roleAssignmentName)).forServicePrincipal(servicePrincipal).withRoleDefinition(roleOrRoleDefinition).withScope(scope).createAsync().last().onErrorResumeNext((Func1)onErrorResumeNext).map((Func1)new Func1<Indexable, RoleAssignment>(){

            public RoleAssignment call(Indexable indexable) {
                return (RoleAssignment)indexable;
            }
        });
    }

    private String msiExtensionType(OperatingSystemTypes osType) {
        return osType == OperatingSystemTypes.LINUX ? LINUX_MSI_EXTENSION : WINDOWS_MSI_EXTENSION;
    }

    private VirtualMachineScaleSetExtension getMSIExtension(Map<String, VirtualMachineScaleSetExtension> extensions, String typeName) {
        for (VirtualMachineScaleSetExtension extension : extensions.values()) {
            if (!extension.publisherName().equalsIgnoreCase(MSI_EXTENSION_PUBLISHER_NAME) || !extension.typeName().equalsIgnoreCase(typeName)) continue;
            return extension;
        }
        return null;
    }

    private Integer objectToInteger(Object obj) {
        Integer result = null;
        if (obj != null) {
            result = obj instanceof Integer ? (Integer)obj : Integer.valueOf((String)obj);
        }
        return result;
    }

    private void clear() {
        this.requireSetup = false;
        this.tokenPort = null;
        this.rolesToAssign.clear();
        this.roleDefinitionsToAssign.clear();
    }
}

