/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.AccessLevel;
import com.microsoft.azure.management.compute.CreationData;
import com.microsoft.azure.management.compute.CreationSource;
import com.microsoft.azure.management.compute.Disk;
import com.microsoft.azure.management.compute.DiskCreateOption;
import com.microsoft.azure.management.compute.DiskSku;
import com.microsoft.azure.management.compute.DiskSkuTypes;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.Snapshot;
import com.microsoft.azure.management.compute.implementation.AccessUriInner;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.DiskInner;
import com.microsoft.azure.management.compute.implementation.GrantAccessDataInner;
import com.microsoft.azure.management.resources.fluentcore.arm.AvailabilityZoneId;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class DiskImpl
extends GroupableResourceImpl<Disk, DiskInner, DiskImpl, ComputeManager>
implements Disk,
Disk.Definition,
Disk.Update {
    DiskImpl(String name, DiskInner innerModel, ComputeManager computeManager) {
        super(name, (Resource)innerModel, (ManagerBase)computeManager);
    }

    @Override
    public DiskSkuTypes sku() {
        return DiskSkuTypes.fromDiskSku(((DiskInner)((Object)this.inner())).sku());
    }

    @Override
    public DiskCreateOption creationMethod() {
        return ((DiskInner)((Object)this.inner())).creationData().createOption();
    }

    @Override
    public boolean isAttachedToVirtualMachine() {
        return this.virtualMachineId() != null;
    }

    @Override
    public String virtualMachineId() {
        return ((DiskInner)((Object)this.inner())).managedBy();
    }

    @Override
    public int sizeInGB() {
        return Utils.toPrimitiveInt((Integer)((DiskInner)((Object)this.inner())).diskSizeGB());
    }

    @Override
    public OperatingSystemTypes osType() {
        return ((DiskInner)((Object)this.inner())).osType();
    }

    @Override
    public CreationSource source() {
        return new CreationSource(((DiskInner)((Object)this.inner())).creationData());
    }

    @Override
    public Set<AvailabilityZoneId> availabilityZones() {
        HashSet<AvailabilityZoneId> zones = new HashSet<AvailabilityZoneId>();
        if (((DiskInner)((Object)this.inner())).zones() != null) {
            for (String zone : ((DiskInner)((Object)this.inner())).zones()) {
                zones.add(AvailabilityZoneId.fromString((String)zone));
            }
        }
        return Collections.unmodifiableSet(zones);
    }

    @Override
    public String grantAccess(int accessDurationInSeconds) {
        return (String)this.grantAccessAsync(accessDurationInSeconds).toBlocking().last();
    }

    @Override
    public Observable<String> grantAccessAsync(int accessDurationInSeconds) {
        GrantAccessDataInner grantAccessDataInner = new GrantAccessDataInner();
        grantAccessDataInner.withAccess(AccessLevel.READ).withDurationInSeconds(accessDurationInSeconds);
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).disks().grantAccessAsync(this.resourceGroupName(), this.name(), grantAccessDataInner).map((Func1)new Func1<AccessUriInner, String>(){

            public String call(AccessUriInner accessUriInner) {
                if (accessUriInner == null) {
                    return null;
                }
                return accessUriInner.accessSAS();
            }
        });
    }

    @Override
    public ServiceFuture<String> grantAccessAsync(int accessDurationInSeconds, ServiceCallback<String> callback) {
        return ServiceFuture.fromBody(this.grantAccessAsync(accessDurationInSeconds), callback);
    }

    @Override
    public void revokeAccess() {
        this.revokeAccessAsync().await();
    }

    @Override
    public Completable revokeAccessAsync() {
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).disks().revokeAccessAsync(this.resourceGroupName(), this.name()).toCompletable();
    }

    @Override
    public ServiceFuture<Void> revokeAccessAsync(ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Observable)this.revokeAccessAsync().toObservable(), callback);
    }

    @Override
    public DiskImpl withLinuxFromVhd(String vhdUrl) {
        ((DiskInner)((Object)this.inner())).withOsType(OperatingSystemTypes.LINUX).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.IMPORT).withSourceUri(vhdUrl);
        return this;
    }

    @Override
    public DiskImpl withLinuxFromDisk(String sourceDiskId) {
        ((DiskInner)((Object)this.inner())).withOsType(OperatingSystemTypes.LINUX).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceDiskId);
        return this;
    }

    @Override
    public DiskImpl withLinuxFromDisk(Disk sourceDisk) {
        this.withLinuxFromDisk(sourceDisk.id());
        if (sourceDisk.osType() != null) {
            this.withOSType(sourceDisk.osType());
        }
        this.withSku(sourceDisk.sku());
        return this;
    }

    @Override
    public DiskImpl withLinuxFromSnapshot(String sourceSnapshotId) {
        ((DiskInner)((Object)this.inner())).withOsType(OperatingSystemTypes.LINUX).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceSnapshotId);
        return this;
    }

    @Override
    public DiskImpl withLinuxFromSnapshot(Snapshot sourceSnapshot) {
        this.withLinuxFromSnapshot(sourceSnapshot.id());
        if (sourceSnapshot.osType() != null) {
            this.withOSType(sourceSnapshot.osType());
        }
        this.withSku(sourceSnapshot.sku());
        return this;
    }

    @Override
    public DiskImpl withWindowsFromVhd(String vhdUrl) {
        ((DiskInner)((Object)this.inner())).withOsType(OperatingSystemTypes.WINDOWS).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.IMPORT).withSourceUri(vhdUrl);
        return this;
    }

    @Override
    public DiskImpl withWindowsFromDisk(String sourceDiskId) {
        ((DiskInner)((Object)this.inner())).withOsType(OperatingSystemTypes.WINDOWS).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceDiskId);
        return this;
    }

    @Override
    public DiskImpl withWindowsFromDisk(Disk sourceDisk) {
        this.withWindowsFromDisk(sourceDisk.id());
        if (sourceDisk.osType() != null) {
            this.withOSType(sourceDisk.osType());
        }
        this.withSku(sourceDisk.sku());
        return this;
    }

    @Override
    public DiskImpl withWindowsFromSnapshot(String sourceSnapshotId) {
        ((DiskInner)((Object)this.inner())).withOsType(OperatingSystemTypes.WINDOWS).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceSnapshotId);
        return this;
    }

    @Override
    public DiskImpl withWindowsFromSnapshot(Snapshot sourceSnapshot) {
        this.withWindowsFromSnapshot(sourceSnapshot.id());
        if (sourceSnapshot.osType() != null) {
            this.withOSType(sourceSnapshot.osType());
        }
        this.withSku(sourceSnapshot.sku());
        return this;
    }

    @Override
    public DiskImpl withData() {
        ((DiskInner)((Object)this.inner())).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.EMPTY);
        return this;
    }

    @Override
    public DiskImpl fromVhd(String vhdUrl) {
        ((DiskInner)((Object)this.inner())).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.IMPORT).withSourceUri(vhdUrl);
        return this;
    }

    @Override
    public DiskImpl fromSnapshot(String snapshotId) {
        ((DiskInner)((Object)this.inner())).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(snapshotId);
        return this;
    }

    @Override
    public DiskImpl fromSnapshot(Snapshot snapshot) {
        return this.fromSnapshot(snapshot.id());
    }

    @Override
    public DiskImpl fromDisk(String managedDiskId) {
        ((DiskInner)((Object)this.inner())).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(managedDiskId);
        return this;
    }

    @Override
    public DiskImpl fromDisk(Disk managedDisk) {
        return this.fromDisk(managedDisk.id()).withOSType(managedDisk.osType()).withSku(managedDisk.sku());
    }

    @Override
    public DiskImpl withSizeInGB(int sizeInGB) {
        ((DiskInner)((Object)this.inner())).withDiskSizeGB(sizeInGB);
        return this;
    }

    @Override
    public DiskImpl withOSType(OperatingSystemTypes osType) {
        ((DiskInner)((Object)this.inner())).withOsType(osType);
        return this;
    }

    @Override
    public DiskImpl withSku(DiskSkuTypes sku) {
        ((DiskInner)((Object)this.inner())).withSku(new DiskSku().withName(sku.accountType()));
        return this;
    }

    @Override
    public DiskImpl withAvailabilityZone(AvailabilityZoneId zoneId) {
        if (((DiskInner)((Object)this.inner())).zones() == null) {
            ((DiskInner)((Object)this.inner())).withZones(new ArrayList<String>());
        }
        ((DiskInner)((Object)this.inner())).zones().add(zoneId.toString());
        return this;
    }

    public Observable<Disk> createResourceAsync() {
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).disks().createOrUpdateAsync(this.resourceGroupName(), this.name(), (DiskInner)((Object)this.inner())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Observable<DiskInner> getInnerAsync() {
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).disks().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }
}

