/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.compute.ContainerServiceAgentPool;
import com.microsoft.azure.management.compute.ContainerServiceMasterProfileCount;
import com.microsoft.azure.management.compute.ContainerServiceOrchestratorTypes;
import com.microsoft.azure.management.compute.ContainerServiceVMSizeTypes;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.ContainerServiceInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;

@Fluent
@Beta(value=Beta.SinceVersion.V1_1_0)
public interface ContainerService
extends GroupableResource<ComputeManager, ContainerServiceInner>,
Refreshable<ContainerService>,
Updatable<Update> {
    public int masterNodeCount();

    public ContainerServiceOrchestratorTypes orchestratorType();

    public String masterLeafDomainLabel();

    public String masterFqdn();

    public String agentPoolName();

    public int agentPoolCount();

    public String agentPoolLeafDomainLabel();

    public ContainerServiceVMSizeTypes agentPoolVMSize();

    public String agentPoolFqdn();

    public String linuxRootUsername();

    public String sshKey();

    public boolean isDiagnosticsEnabled();

    public String servicePrincipalClientId();

    public String servicePrincipalSecret();

    public static interface UpdateStages {

        public static interface WithUpdateAgentPoolCount {
            public Update withAgentVMCount(int var1);
        }
    }

    public static interface Update
    extends Resource.UpdateWithTags<Update>,
    Appliable<ContainerService>,
    UpdateStages.WithUpdateAgentPoolCount {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<ContainerService>,
        Resource.DefinitionWithTags<WithCreate> {
        }

        public static interface WithDiagnostics
        extends WithLinux {
            public WithLinux withDiagnostics();
        }

        public static interface WithLinuxSshKey {
            public WithMasterNodeCount withSshKey(String var1);
        }

        public static interface WithLinuxRootUsername {
            public WithLinuxSshKey withRootUsername(String var1);
        }

        public static interface WithLinux {
            public WithLinuxRootUsername withLinux();
        }

        public static interface WithAgentPool {
            public ContainerServiceAgentPool.DefinitionStages.Blank<WithCreate> defineAgentPool(String var1);
        }

        public static interface WithMasterLeafDomainLabel {
            public WithAgentPool withMasterLeafDomainLabel(String var1);
        }

        public static interface WithMasterNodeCount {
            public WithMasterLeafDomainLabel withMasterNodeCount(ContainerServiceMasterProfileCount var1);
        }

        public static interface WithServicePrincipalProfile {
            public WithLinux withServicePrincipal(String var1, String var2);
        }

        public static interface WithOrchestrator {
            public WithDiagnostics withSwarmOrchestration();

            public WithDiagnostics withDcosOrchestration();

            public WithServicePrincipalProfile withKubernetesOrchestration();
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithOrchestrator> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithOrchestrator,
    DefinitionStages.WithMasterNodeCount,
    DefinitionStages.WithMasterLeafDomainLabel,
    DefinitionStages.WithLinux,
    DefinitionStages.WithLinuxRootUsername,
    DefinitionStages.WithLinuxSshKey,
    DefinitionStages.WithAgentPool,
    DefinitionStages.WithServicePrincipalProfile,
    DefinitionStages.WithDiagnostics,
    DefinitionStages.WithCreate {
    }
}

