/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Describes the properties of a Run Command metadata.
 */
public class RunCommandDocumentBaseInner {
    /**
     * The VM run command schema.
     */
    @JsonProperty(value = "$schema", required = true)
    private String schema;

    /**
     * The VM run command id.
     */
    @JsonProperty(value = "id", required = true)
    private String id;

    /**
     * The Operating System type. Possible values include: 'Windows', 'Linux'.
     */
    @JsonProperty(value = "osType", required = true)
    private OperatingSystemTypes osType;

    /**
     * The VM run command label.
     */
    @JsonProperty(value = "label", required = true)
    private String label;

    /**
     * The VM run command description.
     */
    @JsonProperty(value = "description", required = true)
    private String description;

    /**
     * Get the schema value.
     *
     * @return the schema value
     */
    public String schema() {
        return this.schema;
    }

    /**
     * Set the schema value.
     *
     * @param schema the schema value to set
     * @return the RunCommandDocumentBaseInner object itself.
     */
    public RunCommandDocumentBaseInner withSchema(String schema) {
        this.schema = schema;
        return this;
    }

    /**
     * Get the id value.
     *
     * @return the id value
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id value.
     *
     * @param id the id value to set
     * @return the RunCommandDocumentBaseInner object itself.
     */
    public RunCommandDocumentBaseInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the osType value.
     *
     * @return the osType value
     */
    public OperatingSystemTypes osType() {
        return this.osType;
    }

    /**
     * Set the osType value.
     *
     * @param osType the osType value to set
     * @return the RunCommandDocumentBaseInner object itself.
     */
    public RunCommandDocumentBaseInner withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    /**
     * Get the label value.
     *
     * @return the label value
     */
    public String label() {
        return this.label;
    }

    /**
     * Set the label value.
     *
     * @param label the label value to set
     * @return the RunCommandDocumentBaseInner object itself.
     */
    public RunCommandDocumentBaseInner withLabel(String label) {
        this.label = label;
        return this;
    }

    /**
     * Get the description value.
     *
     * @return the description value
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description value.
     *
     * @param description the description value to set
     * @return the RunCommandDocumentBaseInner object itself.
     */
    public RunCommandDocumentBaseInner withDescription(String description) {
        this.description = description;
        return this;
    }

}
