/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Disks.
 */
public class DisksInner implements InnerSupportsGet<DiskInner>, InnerSupportsDelete<OperationStatusResponseInner>, InnerSupportsListing<DiskInner> {
    /** The Retrofit service to perform REST calls. */
    private DisksService service;
    /** The service client containing this operation class. */
    private ComputeManagementClientImpl client;

    /**
     * Initializes an instance of DisksInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public DisksInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = retrofit.create(DisksService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Disks to be
     * used by Retrofit to perform actually REST calls.
     */
    interface DisksService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskName") String diskName, @Query("api-version") String apiVersion, @Body DiskInner disk, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskName") String diskName, @Query("api-version") String apiVersion, @Body DiskInner disk, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}")
        Observable<Response<ResponseBody>> update(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskName") String diskName, @Query("api-version") String apiVersion, @Body DiskUpdateInner disk, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskName") String diskName, @Query("api-version") String apiVersion, @Body DiskUpdateInner disk, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskName") String diskName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskName") String diskName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskName") String diskName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Compute/disks")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks grantAccess" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}/beginGetAccess")
        Observable<Response<ResponseBody>> grantAccess(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskName") String diskName, @Query("api-version") String apiVersion, @Body GrantAccessDataInner grantAccessData, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks beginGrantAccess" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}/beginGetAccess")
        Observable<Response<ResponseBody>> beginGrantAccess(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskName") String diskName, @Query("api-version") String apiVersion, @Body GrantAccessDataInner grantAccessData, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks revokeAccess" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}/endGetAccess")
        Observable<Response<ResponseBody>> revokeAccess(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskName") String diskName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks beginRevokeAccess" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}/endGetAccess")
        Observable<Response<ResponseBody>> beginRevokeAccess(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("diskName") String diskName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Disks listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Creates or updates a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param disk Disk object supplied in the body of the Put disk operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiskInner object if successful.
     */
    public DiskInner createOrUpdate(String resourceGroupName, String diskName, DiskInner disk) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, diskName, disk).toBlocking().last().body();
    }

    /**
     * Creates or updates a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param disk Disk object supplied in the body of the Put disk operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiskInner> createOrUpdateAsync(String resourceGroupName, String diskName, DiskInner disk, final ServiceCallback<DiskInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, diskName, disk), serviceCallback);
    }

    /**
     * Creates or updates a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param disk Disk object supplied in the body of the Put disk operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<DiskInner> createOrUpdateAsync(String resourceGroupName, String diskName, DiskInner disk) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, diskName, disk).map(new Func1<ServiceResponse<DiskInner>, DiskInner>() {
            @Override
            public DiskInner call(ServiceResponse<DiskInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param disk Disk object supplied in the body of the Put disk operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<DiskInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String diskName, DiskInner disk) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskName == null) {
            throw new IllegalArgumentException("Parameter diskName is required and cannot be null.");
        }
        if (disk == null) {
            throw new IllegalArgumentException("Parameter disk is required and cannot be null.");
        }
        Validator.validate(disk);
        final String apiVersion = "2017-03-30";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, diskName, apiVersion, disk, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DiskInner>() { }.getType());
    }

    /**
     * Creates or updates a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param disk Disk object supplied in the body of the Put disk operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiskInner object if successful.
     */
    public DiskInner beginCreateOrUpdate(String resourceGroupName, String diskName, DiskInner disk) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, diskName, disk).toBlocking().single().body();
    }

    /**
     * Creates or updates a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param disk Disk object supplied in the body of the Put disk operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiskInner> beginCreateOrUpdateAsync(String resourceGroupName, String diskName, DiskInner disk, final ServiceCallback<DiskInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, diskName, disk), serviceCallback);
    }

    /**
     * Creates or updates a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param disk Disk object supplied in the body of the Put disk operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiskInner object
     */
    public Observable<DiskInner> beginCreateOrUpdateAsync(String resourceGroupName, String diskName, DiskInner disk) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, diskName, disk).map(new Func1<ServiceResponse<DiskInner>, DiskInner>() {
            @Override
            public DiskInner call(ServiceResponse<DiskInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param disk Disk object supplied in the body of the Put disk operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiskInner object
     */
    public Observable<ServiceResponse<DiskInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String diskName, DiskInner disk) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskName == null) {
            throw new IllegalArgumentException("Parameter diskName is required and cannot be null.");
        }
        if (disk == null) {
            throw new IllegalArgumentException("Parameter disk is required and cannot be null.");
        }
        Validator.validate(disk);
        final String apiVersion = "2017-03-30";
        return service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, diskName, apiVersion, disk, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiskInner>>>() {
                @Override
                public Observable<ServiceResponse<DiskInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DiskInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DiskInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DiskInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DiskInner>() { }.getType())
                .register(202, new TypeToken<DiskInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates (patches) a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param disk Disk object supplied in the body of the Patch disk operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiskInner object if successful.
     */
    public DiskInner update(String resourceGroupName, String diskName, DiskUpdateInner disk) {
        return updateWithServiceResponseAsync(resourceGroupName, diskName, disk).toBlocking().last().body();
    }

    /**
     * Updates (patches) a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param disk Disk object supplied in the body of the Patch disk operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiskInner> updateAsync(String resourceGroupName, String diskName, DiskUpdateInner disk, final ServiceCallback<DiskInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, diskName, disk), serviceCallback);
    }

    /**
     * Updates (patches) a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param disk Disk object supplied in the body of the Patch disk operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<DiskInner> updateAsync(String resourceGroupName, String diskName, DiskUpdateInner disk) {
        return updateWithServiceResponseAsync(resourceGroupName, diskName, disk).map(new Func1<ServiceResponse<DiskInner>, DiskInner>() {
            @Override
            public DiskInner call(ServiceResponse<DiskInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates (patches) a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param disk Disk object supplied in the body of the Patch disk operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<DiskInner>> updateWithServiceResponseAsync(String resourceGroupName, String diskName, DiskUpdateInner disk) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskName == null) {
            throw new IllegalArgumentException("Parameter diskName is required and cannot be null.");
        }
        if (disk == null) {
            throw new IllegalArgumentException("Parameter disk is required and cannot be null.");
        }
        Validator.validate(disk);
        final String apiVersion = "2017-03-30";
        Observable<Response<ResponseBody>> observable = service.update(this.client.subscriptionId(), resourceGroupName, diskName, apiVersion, disk, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DiskInner>() { }.getType());
    }

    /**
     * Updates (patches) a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param disk Disk object supplied in the body of the Patch disk operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiskInner object if successful.
     */
    public DiskInner beginUpdate(String resourceGroupName, String diskName, DiskUpdateInner disk) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, diskName, disk).toBlocking().single().body();
    }

    /**
     * Updates (patches) a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param disk Disk object supplied in the body of the Patch disk operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiskInner> beginUpdateAsync(String resourceGroupName, String diskName, DiskUpdateInner disk, final ServiceCallback<DiskInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, diskName, disk), serviceCallback);
    }

    /**
     * Updates (patches) a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param disk Disk object supplied in the body of the Patch disk operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiskInner object
     */
    public Observable<DiskInner> beginUpdateAsync(String resourceGroupName, String diskName, DiskUpdateInner disk) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, diskName, disk).map(new Func1<ServiceResponse<DiskInner>, DiskInner>() {
            @Override
            public DiskInner call(ServiceResponse<DiskInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates (patches) a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param disk Disk object supplied in the body of the Patch disk operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiskInner object
     */
    public Observable<ServiceResponse<DiskInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String diskName, DiskUpdateInner disk) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskName == null) {
            throw new IllegalArgumentException("Parameter diskName is required and cannot be null.");
        }
        if (disk == null) {
            throw new IllegalArgumentException("Parameter disk is required and cannot be null.");
        }
        Validator.validate(disk);
        final String apiVersion = "2017-03-30";
        return service.beginUpdate(this.client.subscriptionId(), resourceGroupName, diskName, apiVersion, disk, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiskInner>>>() {
                @Override
                public Observable<ServiceResponse<DiskInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DiskInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DiskInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DiskInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DiskInner>() { }.getType())
                .register(202, new TypeToken<DiskInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets information about a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiskInner object if successful.
     */
    public DiskInner getByResourceGroup(String resourceGroupName, String diskName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, diskName).toBlocking().single().body();
    }

    /**
     * Gets information about a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiskInner> getByResourceGroupAsync(String resourceGroupName, String diskName, final ServiceCallback<DiskInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, diskName), serviceCallback);
    }

    /**
     * Gets information about a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiskInner object
     */
    public Observable<DiskInner> getByResourceGroupAsync(String resourceGroupName, String diskName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, diskName).map(new Func1<ServiceResponse<DiskInner>, DiskInner>() {
            @Override
            public DiskInner call(ServiceResponse<DiskInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets information about a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiskInner object
     */
    public Observable<ServiceResponse<DiskInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String diskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskName == null) {
            throw new IllegalArgumentException("Parameter diskName is required and cannot be null.");
        }
        final String apiVersion = "2017-03-30";
        return service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, diskName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiskInner>>>() {
                @Override
                public Observable<ServiceResponse<DiskInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DiskInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DiskInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DiskInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DiskInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the OperationStatusResponseInner object if successful.
     */
    public OperationStatusResponseInner delete(String resourceGroupName, String diskName) {
        return deleteWithServiceResponseAsync(resourceGroupName, diskName).toBlocking().last().body();
    }

    /**
     * Deletes a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<OperationStatusResponseInner> deleteAsync(String resourceGroupName, String diskName, final ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, diskName), serviceCallback);
    }

    /**
     * Deletes a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<OperationStatusResponseInner> deleteAsync(String resourceGroupName, String diskName) {
        return deleteWithServiceResponseAsync(resourceGroupName, diskName).map(new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>() {
            @Override
            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<OperationStatusResponseInner>> deleteWithServiceResponseAsync(String resourceGroupName, String diskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskName == null) {
            throw new IllegalArgumentException("Parameter diskName is required and cannot be null.");
        }
        final String apiVersion = "2017-03-30";
        Observable<Response<ResponseBody>> observable = service.delete(this.client.subscriptionId(), resourceGroupName, diskName, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<OperationStatusResponseInner>() { }.getType());
    }

    /**
     * Deletes a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the OperationStatusResponseInner object if successful.
     */
    public OperationStatusResponseInner beginDelete(String resourceGroupName, String diskName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, diskName).toBlocking().single().body();
    }

    /**
     * Deletes a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<OperationStatusResponseInner> beginDeleteAsync(String resourceGroupName, String diskName, final ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, diskName), serviceCallback);
    }

    /**
     * Deletes a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the OperationStatusResponseInner object
     */
    public Observable<OperationStatusResponseInner> beginDeleteAsync(String resourceGroupName, String diskName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, diskName).map(new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>() {
            @Override
            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the OperationStatusResponseInner object
     */
    public Observable<ServiceResponse<OperationStatusResponseInner>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String diskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskName == null) {
            throw new IllegalArgumentException("Parameter diskName is required and cannot be null.");
        }
        final String apiVersion = "2017-03-30";
        return service.beginDelete(this.client.subscriptionId(), resourceGroupName, diskName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<OperationStatusResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<OperationStatusResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<OperationStatusResponseInner> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<OperationStatusResponseInner> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<OperationStatusResponseInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<OperationStatusResponseInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the disks under a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DiskInner&gt; object if successful.
     */
    public PagedList<DiskInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<DiskInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<DiskInner>(response.body()) {
            @Override
            public Page<DiskInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the disks under a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DiskInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<DiskInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<DiskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the disks under a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskInner&gt; object
     */
    public Observable<Page<DiskInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<DiskInner>>, Page<DiskInner>>() {
                @Override
                public Page<DiskInner> call(ServiceResponse<Page<DiskInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the disks under a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskInner&gt; object
     */
    public Observable<ServiceResponse<Page<DiskInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<DiskInner>>, Observable<ServiceResponse<Page<DiskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskInner>>> call(ServiceResponse<Page<DiskInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the disks under a resource group.
     *
    ServiceResponse<PageImpl1<DiskInner>> * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DiskInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DiskInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        final String apiVersion = "2017-03-30";
        return service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<DiskInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DiskInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<DiskInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<DiskInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<DiskInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the disks under a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DiskInner&gt; object if successful.
     */
    public PagedList<DiskInner> list() {
        ServiceResponse<Page<DiskInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<DiskInner>(response.body()) {
            @Override
            public Page<DiskInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the disks under a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DiskInner>> listAsync(final ListOperationCallback<DiskInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<DiskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the disks under a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskInner&gt; object
     */
    public Observable<Page<DiskInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<DiskInner>>, Page<DiskInner>>() {
                @Override
                public Page<DiskInner> call(ServiceResponse<Page<DiskInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the disks under a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskInner&gt; object
     */
    public Observable<ServiceResponse<Page<DiskInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<DiskInner>>, Observable<ServiceResponse<Page<DiskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskInner>>> call(ServiceResponse<Page<DiskInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the disks under a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DiskInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DiskInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-30";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<DiskInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DiskInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<DiskInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<DiskInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<DiskInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Grants access to a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param grantAccessData Access data object supplied in the body of the get disk access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AccessUriInner object if successful.
     */
    public AccessUriInner grantAccess(String resourceGroupName, String diskName, GrantAccessDataInner grantAccessData) {
        return grantAccessWithServiceResponseAsync(resourceGroupName, diskName, grantAccessData).toBlocking().last().body();
    }

    /**
     * Grants access to a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param grantAccessData Access data object supplied in the body of the get disk access operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AccessUriInner> grantAccessAsync(String resourceGroupName, String diskName, GrantAccessDataInner grantAccessData, final ServiceCallback<AccessUriInner> serviceCallback) {
        return ServiceFuture.fromResponse(grantAccessWithServiceResponseAsync(resourceGroupName, diskName, grantAccessData), serviceCallback);
    }

    /**
     * Grants access to a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param grantAccessData Access data object supplied in the body of the get disk access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<AccessUriInner> grantAccessAsync(String resourceGroupName, String diskName, GrantAccessDataInner grantAccessData) {
        return grantAccessWithServiceResponseAsync(resourceGroupName, diskName, grantAccessData).map(new Func1<ServiceResponse<AccessUriInner>, AccessUriInner>() {
            @Override
            public AccessUriInner call(ServiceResponse<AccessUriInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Grants access to a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param grantAccessData Access data object supplied in the body of the get disk access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<AccessUriInner>> grantAccessWithServiceResponseAsync(String resourceGroupName, String diskName, GrantAccessDataInner grantAccessData) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskName == null) {
            throw new IllegalArgumentException("Parameter diskName is required and cannot be null.");
        }
        if (grantAccessData == null) {
            throw new IllegalArgumentException("Parameter grantAccessData is required and cannot be null.");
        }
        Validator.validate(grantAccessData);
        final String apiVersion = "2017-03-30";
        Observable<Response<ResponseBody>> observable = service.grantAccess(this.client.subscriptionId(), resourceGroupName, diskName, apiVersion, grantAccessData, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<AccessUriInner>() { }.getType());
    }

    /**
     * Grants access to a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param grantAccessData Access data object supplied in the body of the get disk access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AccessUriInner object if successful.
     */
    public AccessUriInner beginGrantAccess(String resourceGroupName, String diskName, GrantAccessDataInner grantAccessData) {
        return beginGrantAccessWithServiceResponseAsync(resourceGroupName, diskName, grantAccessData).toBlocking().single().body();
    }

    /**
     * Grants access to a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param grantAccessData Access data object supplied in the body of the get disk access operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AccessUriInner> beginGrantAccessAsync(String resourceGroupName, String diskName, GrantAccessDataInner grantAccessData, final ServiceCallback<AccessUriInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginGrantAccessWithServiceResponseAsync(resourceGroupName, diskName, grantAccessData), serviceCallback);
    }

    /**
     * Grants access to a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param grantAccessData Access data object supplied in the body of the get disk access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AccessUriInner object
     */
    public Observable<AccessUriInner> beginGrantAccessAsync(String resourceGroupName, String diskName, GrantAccessDataInner grantAccessData) {
        return beginGrantAccessWithServiceResponseAsync(resourceGroupName, diskName, grantAccessData).map(new Func1<ServiceResponse<AccessUriInner>, AccessUriInner>() {
            @Override
            public AccessUriInner call(ServiceResponse<AccessUriInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Grants access to a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param grantAccessData Access data object supplied in the body of the get disk access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AccessUriInner object
     */
    public Observable<ServiceResponse<AccessUriInner>> beginGrantAccessWithServiceResponseAsync(String resourceGroupName, String diskName, GrantAccessDataInner grantAccessData) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskName == null) {
            throw new IllegalArgumentException("Parameter diskName is required and cannot be null.");
        }
        if (grantAccessData == null) {
            throw new IllegalArgumentException("Parameter grantAccessData is required and cannot be null.");
        }
        Validator.validate(grantAccessData);
        final String apiVersion = "2017-03-30";
        return service.beginGrantAccess(this.client.subscriptionId(), resourceGroupName, diskName, apiVersion, grantAccessData, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AccessUriInner>>>() {
                @Override
                public Observable<ServiceResponse<AccessUriInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AccessUriInner> clientResponse = beginGrantAccessDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AccessUriInner> beginGrantAccessDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AccessUriInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AccessUriInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Revokes access to a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the OperationStatusResponseInner object if successful.
     */
    public OperationStatusResponseInner revokeAccess(String resourceGroupName, String diskName) {
        return revokeAccessWithServiceResponseAsync(resourceGroupName, diskName).toBlocking().last().body();
    }

    /**
     * Revokes access to a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<OperationStatusResponseInner> revokeAccessAsync(String resourceGroupName, String diskName, final ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(revokeAccessWithServiceResponseAsync(resourceGroupName, diskName), serviceCallback);
    }

    /**
     * Revokes access to a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<OperationStatusResponseInner> revokeAccessAsync(String resourceGroupName, String diskName) {
        return revokeAccessWithServiceResponseAsync(resourceGroupName, diskName).map(new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>() {
            @Override
            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Revokes access to a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<OperationStatusResponseInner>> revokeAccessWithServiceResponseAsync(String resourceGroupName, String diskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskName == null) {
            throw new IllegalArgumentException("Parameter diskName is required and cannot be null.");
        }
        final String apiVersion = "2017-03-30";
        Observable<Response<ResponseBody>> observable = service.revokeAccess(this.client.subscriptionId(), resourceGroupName, diskName, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<OperationStatusResponseInner>() { }.getType());
    }

    /**
     * Revokes access to a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the OperationStatusResponseInner object if successful.
     */
    public OperationStatusResponseInner beginRevokeAccess(String resourceGroupName, String diskName) {
        return beginRevokeAccessWithServiceResponseAsync(resourceGroupName, diskName).toBlocking().single().body();
    }

    /**
     * Revokes access to a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<OperationStatusResponseInner> beginRevokeAccessAsync(String resourceGroupName, String diskName, final ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginRevokeAccessWithServiceResponseAsync(resourceGroupName, diskName), serviceCallback);
    }

    /**
     * Revokes access to a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the OperationStatusResponseInner object
     */
    public Observable<OperationStatusResponseInner> beginRevokeAccessAsync(String resourceGroupName, String diskName) {
        return beginRevokeAccessWithServiceResponseAsync(resourceGroupName, diskName).map(new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>() {
            @Override
            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Revokes access to a disk.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskName The name of the disk within the given subscription and resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the OperationStatusResponseInner object
     */
    public Observable<ServiceResponse<OperationStatusResponseInner>> beginRevokeAccessWithServiceResponseAsync(String resourceGroupName, String diskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (diskName == null) {
            throw new IllegalArgumentException("Parameter diskName is required and cannot be null.");
        }
        final String apiVersion = "2017-03-30";
        return service.beginRevokeAccess(this.client.subscriptionId(), resourceGroupName, diskName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<OperationStatusResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<OperationStatusResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<OperationStatusResponseInner> clientResponse = beginRevokeAccessDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<OperationStatusResponseInner> beginRevokeAccessDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<OperationStatusResponseInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<OperationStatusResponseInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the disks under a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DiskInner&gt; object if successful.
     */
    public PagedList<DiskInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<DiskInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DiskInner>(response.body()) {
            @Override
            public Page<DiskInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the disks under a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DiskInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<DiskInner>> serviceFuture, final ListOperationCallback<DiskInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<DiskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the disks under a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskInner&gt; object
     */
    public Observable<Page<DiskInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<DiskInner>>, Page<DiskInner>>() {
                @Override
                public Page<DiskInner> call(ServiceResponse<Page<DiskInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the disks under a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskInner&gt; object
     */
    public Observable<ServiceResponse<Page<DiskInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<DiskInner>>, Observable<ServiceResponse<Page<DiskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskInner>>> call(ServiceResponse<Page<DiskInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the disks under a resource group.
     *
    ServiceResponse<PageImpl1<DiskInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DiskInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DiskInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<DiskInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DiskInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<DiskInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<DiskInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<DiskInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the disks under a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DiskInner&gt; object if successful.
     */
    public PagedList<DiskInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<DiskInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DiskInner>(response.body()) {
            @Override
            public Page<DiskInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the disks under a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DiskInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<DiskInner>> serviceFuture, final ListOperationCallback<DiskInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<DiskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the disks under a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskInner&gt; object
     */
    public Observable<Page<DiskInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<DiskInner>>, Page<DiskInner>>() {
                @Override
                public Page<DiskInner> call(ServiceResponse<Page<DiskInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the disks under a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskInner&gt; object
     */
    public Observable<ServiceResponse<Page<DiskInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<DiskInner>>, Observable<ServiceResponse<Page<DiskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskInner>>> call(ServiceResponse<Page<DiskInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the disks under a subscription.
     *
    ServiceResponse<PageImpl1<DiskInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DiskInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DiskInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<DiskInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DiskInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<DiskInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<DiskInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<DiskInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
