/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for IPVersion.
 */
public final class IPVersion {
    /** Static value IPv4 for IPVersion. */
    public static final IPVersion IPV4 = new IPVersion("IPv4");

    /** Static value IPv6 for IPVersion. */
    public static final IPVersion IPV6 = new IPVersion("IPv6");

    private String value;

    /**
     * Creates a custom value for IPVersion.
     * @param value the custom value
     */
    public IPVersion(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IPVersion)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        IPVersion rhs = (IPVersion) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
