/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.DiskVolumeEncryptionMonitor;
import com.microsoft.azure.management.compute.EncryptionStatus;
import com.microsoft.azure.management.compute.InstanceViewStatus;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.EncryptionExtensionIdentifier;
import com.microsoft.azure.management.compute.implementation.LinuxEncryptionExtensionUtil;
import com.microsoft.azure.management.compute.implementation.VirtualMachineExtensionInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineInner;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import java.util.HashMap;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class LinuxDiskVolumeLegacyEncryptionMonitorImpl
implements DiskVolumeEncryptionMonitor {
    private final String rgName;
    private final String vmName;
    private final ComputeManager computeManager;
    private VirtualMachineExtensionInner encryptionExtension;

    LinuxDiskVolumeLegacyEncryptionMonitorImpl(String virtualMachineId, ComputeManager computeManager) {
        this.rgName = ResourceUtils.groupFromResourceId((String)virtualMachineId);
        this.vmName = ResourceUtils.nameFromResourceId((String)virtualMachineId);
        this.computeManager = computeManager;
    }

    @Override
    public OperatingSystemTypes osType() {
        return OperatingSystemTypes.LINUX;
    }

    @Override
    public String progressMessage() {
        if (!this.hasEncryptionExtension()) {
            return null;
        }
        return LinuxEncryptionExtensionUtil.progressMessage(this.encryptionExtension.instanceView());
    }

    @Override
    public EncryptionStatus osDiskStatus() {
        if (!this.hasEncryptionExtension()) {
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        return LinuxEncryptionExtensionUtil.osDiskStatus(this.encryptionExtension.instanceView());
    }

    @Override
    public EncryptionStatus dataDiskStatus() {
        if (!this.hasEncryptionExtension()) {
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        return LinuxEncryptionExtensionUtil.dataDiskStatus(this.encryptionExtension.instanceView());
    }

    @Override
    @Beta
    public Map<String, InstanceViewStatus> diskInstanceViewEncryptionStatuses() {
        return new HashMap<String, InstanceViewStatus>();
    }

    public DiskVolumeEncryptionMonitor refresh() {
        return (DiskVolumeEncryptionMonitor)this.refreshAsync().toBlocking().last();
    }

    @Override
    public Observable<DiskVolumeEncryptionMonitor> refreshAsync() {
        final LinuxDiskVolumeLegacyEncryptionMonitorImpl self = this;
        return this.retrieveEncryptExtensionWithInstanceViewAsync().flatMap((Func1)new Func1<VirtualMachineExtensionInner, Observable<DiskVolumeEncryptionMonitor>>(){

            public Observable<DiskVolumeEncryptionMonitor> call(VirtualMachineExtensionInner virtualMachineExtensionInner) {
                LinuxDiskVolumeLegacyEncryptionMonitorImpl.this.encryptionExtension = virtualMachineExtensionInner;
                return Observable.just((Object)self);
            }
        }).switchIfEmpty(Observable.just((Object)self));
    }

    private Observable<VirtualMachineExtensionInner> retrieveEncryptExtensionWithInstanceViewAsync() {
        if (this.encryptionExtension != null) {
            return this.retrieveExtensionWithInstanceViewAsync(this.encryptionExtension);
        }
        return this.retrieveEncryptExtensionWithInstanceViewFromVMAsync();
    }

    private Observable<VirtualMachineExtensionInner> retrieveExtensionWithInstanceViewAsync(VirtualMachineExtensionInner extension) {
        return ((ComputeManagementClientImpl)((Object)this.computeManager.inner())).virtualMachineExtensions().getAsync(this.rgName, this.vmName, extension.name(), "instanceView").flatMap((Func1)new Func1<VirtualMachineExtensionInner, Observable<VirtualMachineExtensionInner>>(){

            public Observable<VirtualMachineExtensionInner> call(VirtualMachineExtensionInner virtualMachineExtensionInner) {
                if (virtualMachineExtensionInner == null) {
                    return Observable.empty();
                }
                return Observable.just((Object)((Object)virtualMachineExtensionInner));
            }
        });
    }

    private Observable<VirtualMachineExtensionInner> retrieveEncryptExtensionWithInstanceViewFromVMAsync() {
        return ((ComputeManagementClientImpl)((Object)this.computeManager.inner())).virtualMachines().getByResourceGroupAsync(this.rgName, this.vmName).flatMap((Func1)new Func1<VirtualMachineInner, Observable<VirtualMachineExtensionInner>>(){

            public Observable<VirtualMachineExtensionInner> call(VirtualMachineInner virtualMachine) {
                if (virtualMachine == null) {
                    return Observable.error((Throwable)new Exception(String.format("VM with name '%s' not found (resource group '%s')", LinuxDiskVolumeLegacyEncryptionMonitorImpl.this.vmName, LinuxDiskVolumeLegacyEncryptionMonitorImpl.this.rgName)));
                }
                if (virtualMachine.resources() != null) {
                    for (VirtualMachineExtensionInner extension : virtualMachine.resources()) {
                        if (!EncryptionExtensionIdentifier.isEncryptionPublisherName(extension.publisher()) || !EncryptionExtensionIdentifier.isEncryptionTypeName(extension.virtualMachineExtensionType(), OperatingSystemTypes.LINUX)) continue;
                        return LinuxDiskVolumeLegacyEncryptionMonitorImpl.this.retrieveExtensionWithInstanceViewAsync(extension);
                    }
                }
                return Observable.empty();
            }
        });
    }

    private boolean hasEncryptionExtension() {
        return this.encryptionExtension != null;
    }
}

