/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute;

import com.microsoft.azure.management.compute.ImageReference;

public enum KnownLinuxVirtualMachineImage {
    UBUNTU_SERVER_14_04_LTS("Canonical", "UbuntuServer", "14.04.4-LTS"),
    UBUNTU_SERVER_16_04_LTS("Canonical", "UbuntuServer", "16.04.0-LTS"),
    DEBIAN_8("credativ", "Debian", "8"),
    CENTOS_7_2("OpenLogic", "CentOS", "7.2"),
    OPENSUSE_LEAP_42_1("SUSE", "openSUSE-Leap", "42.1"),
    SLES_12_SP1("SUSE", "SLES", "12-SP1");

    private final String publisher;
    private final String offer;
    private final String sku;

    private KnownLinuxVirtualMachineImage(String publisher, String offer, String sku) {
        this.publisher = publisher;
        this.offer = offer;
        this.sku = sku;
    }

    public String publisher() {
        return this.publisher;
    }

    public String offer() {
        return this.offer;
    }

    public String sku() {
        return this.sku;
    }

    public ImageReference imageReference() {
        return new ImageReference().withPublisher(this.publisher()).withOffer(this.offer()).withSku(this.sku()).withVersion("latest");
    }
}

