/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute;

import com.microsoft.azure.management.compute.DiskSku;
import com.microsoft.azure.management.compute.DiskStorageAccountTypes;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class DiskSkuTypes {
    private static final Map<String, DiskSkuTypes> VALUES_BY_NAME = new HashMap<String, DiskSkuTypes>();
    public static final DiskSkuTypes STANDARD_LRS = new DiskSkuTypes(DiskStorageAccountTypes.STANDARD_LRS);
    public static final DiskSkuTypes PREMIUM_LRS = new DiskSkuTypes(DiskStorageAccountTypes.PREMIUM_LRS);
    private DiskStorageAccountTypes value;

    public static DiskSkuTypes[] values() {
        Collection<DiskSkuTypes> valuesCollection = VALUES_BY_NAME.values();
        return valuesCollection.toArray(new DiskSkuTypes[valuesCollection.size()]);
    }

    public DiskSkuTypes(DiskStorageAccountTypes value) {
        this.value = value;
        if (value != null) {
            VALUES_BY_NAME.put(value.toString().toLowerCase(), this);
        }
    }

    public static DiskSkuTypes fromStorageAccountType(DiskStorageAccountTypes value) {
        if (value == null) {
            return null;
        }
        DiskSkuTypes result = VALUES_BY_NAME.get(value.toString().toLowerCase());
        if (result != null) {
            return result;
        }
        return new DiskSkuTypes(value);
    }

    public static DiskSkuTypes fromDiskSku(DiskSku diskSku) {
        if (diskSku == null) {
            return null;
        }
        return DiskSkuTypes.fromStorageAccountType(diskSku.name());
    }

    public DiskStorageAccountTypes accountType() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DiskSkuTypes)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.value == null) {
            return ((DiskSkuTypes)obj).value == null;
        }
        return this.value.equals((Object)((DiskSkuTypes)obj).value);
    }

    public String toString() {
        return this.value.toString();
    }
}

