/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Describes a storage profile.
 */
public class ImageStorageProfile {
    /**
     * The OS disk.
     */
    @JsonProperty(value = "osDisk", required = true)
    private ImageOSDisk osDisk;

    /**
     * The data disks.
     */
    @JsonProperty(value = "dataDisks")
    private List<ImageDataDisk> dataDisks;

    /**
     * Get the osDisk value.
     *
     * @return the osDisk value
     */
    public ImageOSDisk osDisk() {
        return this.osDisk;
    }

    /**
     * Set the osDisk value.
     *
     * @param osDisk the osDisk value to set
     * @return the ImageStorageProfile object itself.
     */
    public ImageStorageProfile withOsDisk(ImageOSDisk osDisk) {
        this.osDisk = osDisk;
        return this;
    }

    /**
     * Get the dataDisks value.
     *
     * @return the dataDisks value
     */
    public List<ImageDataDisk> dataDisks() {
        return this.dataDisks;
    }

    /**
     * Set the dataDisks value.
     *
     * @param dataDisks the dataDisks value to set
     * @return the ImageStorageProfile object itself.
     */
    public ImageStorageProfile withDataDisks(List<ImageDataDisk> dataDisks) {
        this.dataDisks = dataDisks;
        return this;
    }

}
