/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Credentials to access a container image in a private repository.
 */
public class PrivateRegistryCredentials {
    /**
     * User name.
     * User name to login to the repository.
     */
    @JsonProperty(value = "username", required = true)
    private String username;

    /**
     * Password.
     * User password to login to the docker repository. One of password or
     * passwordSecretReference must be specified.
     */
    @JsonProperty(value = "password")
    private String password;

    /**
     * Password secret reference.
     * KeyVault Secret storing the password. Users can store their secrets in
     * Azure KeyVault and pass it to the Batch AI service to integrate with
     * KeyVault. One of password or passwordSecretReference must be specified.
     */
    @JsonProperty(value = "passwordSecretReference")
    private KeyVaultSecretReference passwordSecretReference;

    /**
     * Get user name to login to the repository.
     *
     * @return the username value
     */
    public String username() {
        return this.username;
    }

    /**
     * Set user name to login to the repository.
     *
     * @param username the username value to set
     * @return the PrivateRegistryCredentials object itself.
     */
    public PrivateRegistryCredentials withUsername(String username) {
        this.username = username;
        return this;
    }

    /**
     * Get user password to login to the docker repository. One of password or passwordSecretReference must be specified.
     *
     * @return the password value
     */
    public String password() {
        return this.password;
    }

    /**
     * Set user password to login to the docker repository. One of password or passwordSecretReference must be specified.
     *
     * @param password the password value to set
     * @return the PrivateRegistryCredentials object itself.
     */
    public PrivateRegistryCredentials withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * Get keyVault Secret storing the password. Users can store their secrets in Azure KeyVault and pass it to the Batch AI service to integrate with KeyVault. One of password or passwordSecretReference must be specified.
     *
     * @return the passwordSecretReference value
     */
    public KeyVaultSecretReference passwordSecretReference() {
        return this.passwordSecretReference;
    }

    /**
     * Set keyVault Secret storing the password. Users can store their secrets in Azure KeyVault and pass it to the Batch AI service to integrate with KeyVault. One of password or passwordSecretReference must be specified.
     *
     * @param passwordSecretReference the passwordSecretReference value to set
     * @return the PrivateRegistryCredentials object itself.
     */
    public PrivateRegistryCredentials withPasswordSecretReference(KeyVaultSecretReference passwordSecretReference) {
        this.passwordSecretReference = passwordSecretReference;
        return this;
    }

}
