/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Data disks settings.
 */
public class DataDisks {
    /**
     * Disk size in GB.
     * Disk size in GB for the blank data disks.
     */
    @JsonProperty(value = "diskSizeInGB", required = true)
    private int diskSizeInGB;

    /**
     * Caching type.
     * Caching type for the disks. Available values are none (default),
     * readonly, readwrite. Caching type can be set only for VM sizes
     * supporting premium storage. Possible values include: 'none', 'readonly',
     * 'readwrite'.
     */
    @JsonProperty(value = "cachingType")
    private CachingType cachingType;

    /**
     * Number of data disks.
     * Number of data disks attached to the File Server. If multiple disks
     * attached, they will be configured in RAID level 0.
     */
    @JsonProperty(value = "diskCount", required = true)
    private int diskCount;

    /**
     * Storage account type.
     * Type of storage account to be used on the disk. Possible values are:
     * Standard_LRS or Premium_LRS. Premium storage account type can only be
     * used with VM sizes supporting premium storage. Possible values include:
     * 'Standard_LRS', 'Premium_LRS'.
     */
    @JsonProperty(value = "storageAccountType", required = true)
    private StorageAccountType storageAccountType;

    /**
     * Get disk size in GB for the blank data disks.
     *
     * @return the diskSizeInGB value
     */
    public int diskSizeInGB() {
        return this.diskSizeInGB;
    }

    /**
     * Set disk size in GB for the blank data disks.
     *
     * @param diskSizeInGB the diskSizeInGB value to set
     * @return the DataDisks object itself.
     */
    public DataDisks withDiskSizeInGB(int diskSizeInGB) {
        this.diskSizeInGB = diskSizeInGB;
        return this;
    }

    /**
     * Get caching type for the disks. Available values are none (default), readonly, readwrite. Caching type can be set only for VM sizes supporting premium storage. Possible values include: 'none', 'readonly', 'readwrite'.
     *
     * @return the cachingType value
     */
    public CachingType cachingType() {
        return this.cachingType;
    }

    /**
     * Set caching type for the disks. Available values are none (default), readonly, readwrite. Caching type can be set only for VM sizes supporting premium storage. Possible values include: 'none', 'readonly', 'readwrite'.
     *
     * @param cachingType the cachingType value to set
     * @return the DataDisks object itself.
     */
    public DataDisks withCachingType(CachingType cachingType) {
        this.cachingType = cachingType;
        return this;
    }

    /**
     * Get number of data disks attached to the File Server. If multiple disks attached, they will be configured in RAID level 0.
     *
     * @return the diskCount value
     */
    public int diskCount() {
        return this.diskCount;
    }

    /**
     * Set number of data disks attached to the File Server. If multiple disks attached, they will be configured in RAID level 0.
     *
     * @param diskCount the diskCount value to set
     * @return the DataDisks object itself.
     */
    public DataDisks withDiskCount(int diskCount) {
        this.diskCount = diskCount;
        return this;
    }

    /**
     * Get type of storage account to be used on the disk. Possible values are: Standard_LRS or Premium_LRS. Premium storage account type can only be used with VM sizes supporting premium storage. Possible values include: 'Standard_LRS', 'Premium_LRS'.
     *
     * @return the storageAccountType value
     */
    public StorageAccountType storageAccountType() {
        return this.storageAccountType;
    }

    /**
     * Set type of storage account to be used on the disk. Possible values are: Standard_LRS or Premium_LRS. Premium storage account type can only be used with VM sizes supporting premium storage. Possible values include: 'Standard_LRS', 'Premium_LRS'.
     *
     * @param storageAccountType the storageAccountType value to set
     * @return the DataDisks object itself.
     */
    public DataDisks withStorageAccountType(StorageAccountType storageAccountType) {
        this.storageAccountType = storageAccountType;
        return this;
    }

}
